/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.world.grid.chunk;

import CoroUtil.forge.CULog;
import CoroUtil.util.CoroUtilFile;
import CoroUtil.world.grid.chunk.ChunkDataPoint;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ChunkDataGrid {
    public World world;
    public HashMap<Integer, ChunkDataPoint> grid;
    public NBTTagCompound dataAllChunks = new NBTTagCompound();

    public ChunkDataGrid(World parWorld) {
        this.world = parWorld;
        this.grid = new HashMap();
    }

    public int getHash(int i, int k) {
        int j = 0;
        return j & 0xFF | (i & Short.MAX_VALUE) << 8 | (k & Short.MAX_VALUE) << 24 | (i >= 0 ? 0 : Integer.MIN_VALUE) | (k >= 0 ? 0 : 32768);
    }

    public ChunkDataPoint getChunkData(int i, int k) {
        return this.getChunkData(i, k, false);
    }

    public ChunkDataPoint getBlockDataIfExists(int i, int k) {
        return this.getChunkData(i, k, true);
    }

    public ChunkDataPoint getChunkData(int i, int k, boolean onlyIfExists) {
        int hash = this.getHash(i, k);
        if (!this.grid.containsKey(hash)) {
            if (!onlyIfExists) {
                if (this.dataAllChunks.func_74764_b("" + hash)) {
                    NBTTagCompound nbt = this.dataAllChunks.func_74775_l("" + hash);
                    ChunkDataPoint bdp = new ChunkDataPoint(this, nbt.func_74762_e("xCoord"), nbt.func_74762_e("zCoord"));
                    bdp.initFirstTime();
                    bdp.readFromNBT(nbt);
                    this.grid.put(bdp.hash, bdp);
                    return bdp;
                }
                ChunkDataPoint newVec = new ChunkDataPoint(this, i, k);
                newVec.initFirstTime();
                this.grid.put(newVec.hash, newVec);
                return newVec;
            }
            return null;
        }
        return this.grid.get(hash);
    }

    public void removeBlockData(int i, int k) {
        int hash = this.getHash(i, k);
        if (this.grid.containsKey(hash)) {
            ChunkDataPoint bdp = this.grid.get(hash);
            bdp.cleanup();
            this.grid.remove(hash);
        }
    }

    public void readFromFile() {
        try {
            String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "CoroUtil" + File.separator + "World" + File.separator;
            if (new File(saveFolder + "ChunkDataDim_" + this.world.field_73011_w.getDimension() + ".dat").exists()) {
                this.dataAllChunks = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(saveFolder + "ChunkDataDim_" + this.world.field_73011_w.getDimension() + ".dat"));
                for (String keyName : this.dataAllChunks.func_150296_c()) {
                    NBTTagCompound nbt = this.dataAllChunks.func_74775_l(keyName);
                    ChunkDataPoint bdp = new ChunkDataPoint(this, nbt.func_74762_e("xCoord"), nbt.func_74762_e("zCoord"));
                    bdp.initFirstTime();
                    bdp.readFromNBT(nbt);
                    this.grid.put(bdp.hash, bdp);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void writeToFile(boolean unloadInstances) {
        try {
            Collection<ChunkDataPoint> playerDataCl = this.grid.values();
            Iterator<ChunkDataPoint> it = playerDataCl.iterator();
            while (it.hasNext()) {
                ChunkDataPoint bdp = it.next();
                this.dataAllChunks.func_74782_a("" + bdp.hash, (NBTBase)bdp.writeToNBT());
                if (unloadInstances || this.world == null || this.world.func_175667_e(new BlockPos(bdp.xCoord * 16, 0, bdp.zCoord * 16))) continue;
                CULog.dbg("detected saving chunk data for unloaded chunk, removing its data from memory");
                bdp.cleanup();
                it.remove();
            }
            String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "CoroUtil" + File.separator + "World" + File.separator;
            if (!new File(saveFolder).exists()) {
                new File(saveFolder).mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(saveFolder + "ChunkDataDim_" + this.world.field_73011_w.getDimension() + ".dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.dataAllChunks, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (unloadInstances) {
            this.dataAllChunks = new NBTTagCompound();
        }
    }

    public void tick() {
    }
}

