/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer;

import CoroUtil.config.ConfigCoroUtil;
import CoroUtil.config.ConfigCoroUtilAdvanced;
import CoroUtil.forge.CULog;
import CoroUtil.util.CoroUtilBlockLightCache;
import extendedrenderer.ExtendedRenderer;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.ShaderManager;
import extendedrenderer.render.RotatingParticleManager;
import extendedrenderer.shader.ShaderEngine;
import extendedrenderer.shader.ShaderListenerRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class EventHandler {
    public static World lastWorld;
    public static int mip_min;
    public static int mip_mag;
    public static float sandstormFogAmount;
    public static boolean foliageUseLast;
    public static boolean flagFoliageUpdate;
    public static boolean lastLightningBoltLightState;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickRenderScreen(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EventHandler.tickShaderTest();
        }
    }

    public static void tickShaderTest() {
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickClient(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e != null && !this.isPaused()) {
                boolean lightningActive;
                ExtendedRenderer.rotEffRenderer.updateEffects();
                boolean bl = lightningActive = mc.field_71441_e.func_175658_ac() > 0;
                if (mc.field_71441_e.func_82737_E() % 2L == 0L || lightningActive != lastLightningBoltLightState) {
                    CoroUtilBlockLightCache.clear();
                }
                lastLightningBoltLightState = lightningActive;
            }
            if (ConfigCoroUtil.foliageShaders != foliageUseLast) {
                foliageUseLast = ConfigCoroUtil.foliageShaders;
                flagFoliageUpdate = true;
            }
            if (flagFoliageUpdate) {
                CULog.dbg("CoroUtil detected a need to reload resource packs, initiating");
                flagFoliageUpdate = false;
                Minecraft.func_71410_x().func_110436_a();
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void worldRender(RenderWorldLastEvent event) {
        if (!ConfigCoroUtil.useEntityRenderHookForShaders) {
            EventHandler.hookRenderShaders(event.getPartialTicks());
        }
    }

    public static boolean queryUseOfShaders() {
        RotatingParticleManager.useShaders = ShaderManager.canUseShadersInstancedRendering();
        if (ConfigCoroUtil.forceShadersOff) {
            RotatingParticleManager.useShaders = false;
        }
        return RotatingParticleManager.useShaders;
    }

    @SideOnly(value=Side.CLIENT)
    public static void hookRenderShaders(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        if (lastWorld != mc.field_71441_e) {
            CULog.log("CoroUtil: resetting rotating particle renderer");
            ExtendedRenderer.rotEffRenderer.clearEffects((World)mc.field_71441_e);
            lastWorld = mc.field_71441_e;
        }
        EntityRenderer er = mc.field_71460_t;
        if (!ConfigCoroUtilAdvanced.disableParticleRenderer) {
            er.func_180436_i();
            mc.field_71424_I.func_76318_c("litParticles");
            ExtendedRenderer.rotEffRenderer.renderLitParticles(mc.func_175606_aa(), partialTicks);
            RenderHelper.func_74518_a();
            mc.field_71424_I.func_76318_c("particles");
            EventHandler.queryUseOfShaders();
            if (RotatingParticleManager.forceShaderReset) {
                CULog.log("Extended Renderer: Resetting shaders");
                RotatingParticleManager.forceShaderReset = false;
                ShaderEngine.cleanup();
                ShaderListenerRegistry.postReset();
                ExtendedRenderer.foliageRenderer.foliage.clear();
                ShaderEngine.renderer = null;
                ShaderManager.resetCheck();
            }
            if (RotatingParticleManager.useShaders && ShaderEngine.renderer == null) {
                boolean simulateFail = false;
                if (!ShaderEngine.init() || simulateFail) {
                    CULog.log("Extended Renderer: Shaders failed to initialize");
                    ShaderManager.disableShaders();
                    RotatingParticleManager.useShaders = false;
                } else {
                    CULog.log("Extended Renderer: Initialized instanced rendering shaders");
                    ShaderListenerRegistry.postInit();
                }
            }
            EventHandler.preShaderRender(mc.func_175606_aa(), partialTicks);
            if (ConfigCoroUtil.foliageShaders) {
                ExtendedRenderer.foliageRenderer.render(mc.func_175606_aa(), partialTicks);
            }
            ExtendedRenderer.rotEffRenderer.renderParticles(mc.func_175606_aa(), partialTicks);
            EventHandler.postShaderRender(mc.func_175606_aa(), partialTicks);
            er.func_175072_h();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void preShaderRender(Entity entityIn, float partialTicks) {
        boolean ATmode;
        boolean fog;
        Minecraft mc = Minecraft.func_71410_x();
        EntityRenderer er = mc.field_71460_t;
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.004f);
        boolean testGLUOverride = false;
        if (testGLUOverride) {
            // empty if block
        }
        if ((fog = true) && (ATmode = true)) {
            er.func_78468_a(0, partialTicks);
            float f = 1.0f - sandstormFogAmount;
        }
        GlStateManager.func_179129_p();
        CoroUtilBlockLightCache.brightnessPlayer = CoroUtilBlockLightCache.getBrightnessFromLightmap((World)mc.field_71441_e, (float)entityIn.field_70165_t, (float)entityIn.field_70163_u, (float)entityIn.field_70161_v);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mip_min = 0;
        mip_mag = 0;
        if (!ConfigCoroUtilAdvanced.disableMipmapFix) {
            mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            mip_min = GL11.glGetTexParameteri((int)3553, (int)10241);
            mip_mag = GL11.glGetTexParameteri((int)3553, (int)10240);
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void postShaderRender(Entity entityIn, float partialTicks) {
        if (!ConfigCoroUtilAdvanced.disableMipmapFix) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)mip_min);
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)mip_mag);
        }
        GlStateManager.func_179089_o();
        boolean fog = true;
        if (fog) {
            GlStateManager.func_179106_n();
        }
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isPaused() {
        return FMLClientHandler.instance().getClient().func_147113_T();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureStitchEvent.Pre event) {
        ParticleRegistry.init(event);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerIconsPost(TextureStitchEvent.Post event) {
        ParticleRegistry.initPost(event);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void modelBake(ModelBakeEvent event) {
    }

    static {
        mip_min = 0;
        mip_mag = 0;
        sandstormFogAmount = 0.0f;
        flagFoliageUpdate = false;
        lastLightningBoltLightState = false;
    }
}

