/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.particle.entity;

import CoroUtil.util.CoroUtilColor;
import extendedrenderer.particle.entity.ParticleTexFX;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.commons.lang3.ArrayUtils;

public class ParticleTexLeafColor
extends ParticleTexFX {
    private static BlockColors colors;
    private static final Field _blockColorMap;
    private static Map<IRegistryDelegate<Block>, IBlockColor> blockColorMap;
    private static ConcurrentHashMap<IBlockState, int[]> colorCache;
    public float rotationYawMomentum = 0.0f;
    public float rotationPitchMomentum = 0.0f;

    public ParticleTexLeafColor(World worldIn, double posXIn, double posYIn, double posZIn, double mX, double mY, double mZ, TextureAtlasSprite par8Item) {
        super(worldIn, posXIn, posYIn, posZIn, mX, mY, mZ, par8Item);
        BlockPos pos;
        IBlockState state;
        if (colors == null) {
            colors = Minecraft.func_71410_x().func_184125_al();
            try {
                blockColorMap = (Map)_blockColorMap.get(colors);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
        if ((state = worldIn.func_180495_p(pos = new BlockPos(posXIn, posYIn, posZIn))).func_177230_c() instanceof BlockDoublePlant && state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER) {
            state = state.func_177226_a((IProperty)BlockDoublePlant.field_176493_a, worldIn.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)BlockDoublePlant.field_176493_a));
        }
        int multiplier = colors.func_186724_a(state, (IBlockAccess)this.field_187122_b, pos, 0);
        int[] colors = colorCache.get(state);
        if (colors == null) {
            colors = CoroUtilColor.getColors(state);
            if (colors.length == 0) {
                if (!this.hasColor(state) || (multiplier & 0xFFFFFF) == 0xFFFFFF) {
                    multiplier = 5811761;
                }
                colors = new int[]{0xFFFFFF};
            }
            if (colors.length > 1) {
                while (colors[colors.length - 1] == colors[colors.length - 2]) {
                    colors = ArrayUtils.remove((int[])colors, (int)(colors.length - 1));
                }
            }
            colorCache.put(state, colors);
        }
        int randMax = 1 << colors.length - 1;
        int choice = 32 - Integer.numberOfLeadingZeros(worldIn.field_73012_v.nextInt(randMax));
        int color = colors[choice];
        float mr = (float)(multiplier >>> 16 & 0xFF) / 255.0f;
        float mg = (float)(multiplier >>> 8 & 0xFF) / 255.0f;
        float mb = (float)(multiplier & 0xFF) / 255.0f;
        this.field_70552_h *= (float)(color >> 16 & 0xFF) / 255.0f * mr;
        this.field_70553_i *= (float)(color >> 8 & 0xFF) / 255.0f * mg;
        this.field_70551_j *= (float)(color & 0xFF) / 255.0f * mb;
    }

    @Override
    public void func_189213_a() {
        double speed;
        super.func_189213_a();
        if (this.isCollidedVerticallyDownwards && this.field_187136_p.nextInt(10) == 0 && (speed = Math.sqrt(this.field_187129_i * this.field_187129_i + this.field_187131_k * this.field_187131_k)) > 0.07) {
            this.field_187130_j = 0.02 + this.field_187136_p.nextDouble() * 0.03;
            this.field_187129_i *= 0.6;
            this.field_187131_k *= 0.6;
            this.rotationYawMomentum = 30.0f;
            this.rotationPitchMomentum = 30.0f;
        }
        if (this.rotationYawMomentum > 0.0f) {
            this.rotationYaw += this.rotationYawMomentum;
            this.rotationYawMomentum -= 1.5f;
            if (this.rotationYawMomentum < 0.0f) {
                this.rotationYawMomentum = 0.0f;
            }
        }
        if (this.rotationPitchMomentum > 0.0f) {
            this.rotationPitch += this.rotationPitchMomentum;
            this.rotationPitchMomentum -= 1.5f;
            if (this.rotationPitchMomentum < 0.0f) {
                this.rotationPitchMomentum = 0.0f;
            }
        }
    }

    private final boolean hasColor(IBlockState state) {
        return blockColorMap.containsKey(state.func_177230_c().delegate);
    }

    static {
        _blockColorMap = ReflectionHelper.findField(BlockColors.class, (String[])new String[]{"blockColorMap"});
        colorCache = new ConcurrentHashMap();
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(rm -> colorCache.clear());
    }
}

