/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.shader;

import extendedrenderer.particle.ShaderManager;
import extendedrenderer.shader.Matrix4fe;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;

public abstract class ShaderProgram {
    private String name;
    private final int programId;
    private int vertexShaderId;
    private int fragmentShaderId;
    public Map<String, Integer> uniforms;

    public ShaderProgram(String name) throws Exception {
        this.name = name;
        this.programId = OpenGlHelper.func_153183_d();
        if (this.programId == 0) {
            throw new Exception("Could not create Shader");
        }
        this.uniforms = new HashMap<String, Integer>();
    }

    public void createUniform(String uniformName) throws Exception {
        int uniformLocation = OpenGlHelper.func_153194_a((int)this.programId, (CharSequence)uniformName);
        if (uniformLocation < 0) {
            System.out.println("!!!!!!!! GLSL OPTIMIZATION WARNING MAYBE: Could not find uniform:" + uniformName);
        }
        this.uniforms.put(uniformName, uniformLocation);
    }

    public void setUniform(String uniformName, Matrix4fe value) {
        FloatBuffer fb = BufferUtils.createFloatBuffer((int)16);
        value.get(fb);
        OpenGlHelper.func_153160_c((int)this.uniforms.get(uniformName), (boolean)false, (FloatBuffer)fb);
    }

    public void setUniformEfficient(String uniformName, Matrix4fe value, FloatBuffer buffer) {
        value.get(buffer);
        OpenGlHelper.func_153160_c((int)this.uniforms.get(uniformName), (boolean)false, (FloatBuffer)buffer);
    }

    public void setUniform(String uniformName, int value) {
        OpenGlHelper.func_153163_f((int)this.uniforms.get(uniformName), (int)value);
    }

    public void setUniform(String uniformName, float value) {
        GL20.glUniform1f((int)this.uniforms.get(uniformName), (float)value);
    }

    public void createVertexShader(String shaderCode) throws Exception {
        this.vertexShaderId = this.createShader(shaderCode, 35633);
    }

    public void createFragmentShader(String shaderCode) throws Exception {
        this.fragmentShaderId = this.createShader(shaderCode, 35632);
    }

    protected int createShader(String shaderCode, int shaderType) throws Exception {
        int shaderId = OpenGlHelper.func_153195_b((int)shaderType);
        if (shaderId == 0) {
            throw new Exception("Error creating shader. Type: " + shaderType);
        }
        ShaderManager.glShaderSource(shaderId, shaderCode);
        OpenGlHelper.func_153170_c((int)shaderId);
        if (OpenGlHelper.func_153157_c((int)shaderId, (int)35713) == 0) {
            throw new Exception("Error compiling Shader code: " + OpenGlHelper.func_153158_d((int)shaderId, (int)1024));
        }
        OpenGlHelper.func_153178_b((int)this.programId, (int)shaderId);
        if (shaderType == 35633) {
            this.setupAttribLocations();
        }
        return shaderId;
    }

    public abstract void setupAttribLocations();

    public void link() throws Exception {
        OpenGlHelper.func_153179_f((int)this.programId);
        if (OpenGlHelper.func_153175_a((int)this.programId, (int)35714) == 0) {
            throw new Exception("Error linking Shader code: " + OpenGlHelper.func_153166_e((int)this.programId, (int)1024));
        }
        if (this.vertexShaderId != 0) {
            GL20.glDetachShader((int)this.programId, (int)this.vertexShaderId);
        }
        if (this.fragmentShaderId != 0) {
            GL20.glDetachShader((int)this.programId, (int)this.fragmentShaderId);
        }
        GL20.glValidateProgram((int)this.programId);
        if (OpenGlHelper.func_153175_a((int)this.programId, (int)35715) == 0) {
            System.err.println("Warning validating Shader code: " + OpenGlHelper.func_153166_e((int)this.programId, (int)1024));
        }
    }

    public void bind() {
        OpenGlHelper.func_153161_d((int)this.programId);
    }

    public void unbind() {
        OpenGlHelper.func_153161_d((int)0);
    }

    public void cleanup() {
        this.unbind();
        if (this.programId != 0) {
            OpenGlHelper.func_153187_e((int)this.programId);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getProgramId() {
        return this.programId;
    }
}

