/*
 * Decompiled with CFR 0.152.
 */
package magmasrc.ageofweapons.crushing;

import com.google.common.collect.Maps;
import java.util.Map;
import magmasrc.ageofweapons.main.ModBlocks;
import magmasrc.ageofweapons.main.ModItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;

public class CrusherRecipes {
    private static final CrusherRecipes CRUSHING_BASE = new CrusherRecipes();
    private final Map<ItemStack, ItemStack> crushingList = Maps.newHashMap();
    private final Map<ItemStack, Float> experienceList = Maps.newHashMap();

    public static CrusherRecipes instance() {
        return CRUSHING_BASE;
    }

    private CrusherRecipes() {
        this.addCrushing(Items.field_151042_j, new ItemStack(ModItems.ironShard, 4), 0.0f);
        this.addCrushing(Items.field_151043_k, new ItemStack(ModItems.goldShard, 4), 0.0f);
        this.addCrushing(Items.field_151045_i, new ItemStack(ModItems.diamondShard, 4), 0.0f);
        this.addCrushing(Items.field_151166_bC, new ItemStack(ModItems.emeraldShard, 4), 0.0f);
        this.addCrushing(ModItems.rock, new ItemStack(ModItems.stoneShard, 4), 0.0f);
        this.addCrushing(ModItems.ruby, new ItemStack(ModItems.rubyShard, 4), 0.0f);
        this.addCrushing(ModItems.sapphire, new ItemStack(ModItems.sapphireShard, 4), 0.0f);
        this.addCrushing(ModItems.amethyst, new ItemStack(ModItems.amethystShard, 4), 0.0f);
        this.addCrushing(ModItems.topaz, new ItemStack(ModItems.topazShard, 4), 0.0f);
        this.addCrushing(ModItems.witheredIronIngot, new ItemStack(ModItems.witheredIronShard, 4), 0.0f);
        this.addCrushingRecipeForBlock(Blocks.field_150359_w, new ItemStack(ModItems.glassShard, 10), 0.0f);
        this.addCrushingRecipeForBlock(Blocks.field_150410_aZ, new ItemStack(ModItems.glassShard, 4), 0.0f);
        this.addCrushingRecipeForBlock(Blocks.field_150351_n, new ItemStack(Items.field_151145_ak, 1), 0.0f);
        this.addCrushingRecipeForBlock(Blocks.field_150348_b, new ItemStack(ModItems.stoneShard, 10), 0.0f);
        this.addCrushingRecipeForBlock(Blocks.field_150347_e, new ItemStack(ModItems.rock, 6), 0.0f);
        this.addCrushingRecipeForBlock(Blocks.field_150344_f, new ItemStack(ModItems.woodShard, 10), 0.0f);
        this.addCrushingRecipeForBlock(Blocks.field_150364_r, new ItemStack(ModItems.woodShard, 10), 0.0f);
        this.addCrushingRecipeForBlock(Blocks.field_150363_s, new ItemStack(ModItems.woodShard, 10), 0.0f);
        this.addCrushingRecipeForBlock(Blocks.field_150417_aV, new ItemStack(Blocks.field_150417_aV, 4, 2), 0.0f);
        this.addCrushingRecipeForBlock(Blocks.field_150339_S, new ItemStack(ModItems.ironShard, 36), 0.0f);
        this.addCrushingRecipeForBlock(Blocks.field_150340_R, new ItemStack(ModItems.goldShard, 36), 0.0f);
        this.addCrushingRecipeForBlock(Blocks.field_150484_ah, new ItemStack(ModItems.diamondShard, 36), 0.0f);
        this.addCrushingRecipeForBlock(Blocks.field_150475_bE, new ItemStack(ModItems.emeraldShard, 36), 0.0f);
        this.addCrushingRecipeForBlock(ModBlocks.rubyBlock, new ItemStack(ModItems.rubyShard, 36), 0.0f);
        this.addCrushingRecipeForBlock(ModBlocks.sapphireBlock, new ItemStack(ModItems.sapphireShard, 36), 0.0f);
        this.addCrushingRecipeForBlock(ModBlocks.amethystBlock, new ItemStack(ModItems.amethystShard, 36), 0.0f);
        this.addCrushingRecipeForBlock(ModBlocks.topazBlock, new ItemStack(ModItems.topazShard, 36), 0.0f);
        this.addCrushingRecipeForBlock(ModBlocks.witheredIronBlock, new ItemStack(ModItems.witheredIronShard, 36), 0.0f);
    }

    public void addCrushingRecipeForBlock(Block input, ItemStack stack, float experience) {
        this.addCrushing(Item.func_150898_a((Block)input), stack, experience);
    }

    public void addCrushing(Item input, ItemStack stack, float experience) {
        this.addCrushingRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack, experience);
    }

    public void addCrushingRecipe(ItemStack input, ItemStack stack, float experience) {
        if (this.getCrushingResult(input) != ItemStack.field_190927_a) {
            FMLLog.info((String)("Ignored smelting recipe with conflicting input: " + input + " = " + stack), (Object[])new Object[0]);
            return;
        }
        this.crushingList.put(input, stack);
        this.experienceList.put(stack, Float.valueOf(experience));
    }

    public ItemStack getCrushingResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.crushingList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map<ItemStack, ItemStack> getCrushingList() {
        return this.crushingList;
    }

    public float getCrushingExperience(ItemStack stack) {
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

