/*
 * Decompiled with CFR 0.152.
 */
package de.mixothelys.mod_swe;

import de.mixothelys.mod_swe.CreativeTabSWE;
import de.mixothelys.mod_swe.Decorator;
import de.mixothelys.mod_swe.SWESoundHandler;
import de.mixothelys.mod_swe.blocks.SWEBlocks;
import de.mixothelys.mod_swe.items.SWEItems;
import de.mixothelys.mod_swe.proxies.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="mod_swe", version="1.2", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class SWECore {
    public static final String MODID = "mod_swe";
    public static final String VERSION = "1.2";
    public static CreativeTabs tab;
    @SidedProxy(clientSide="de.mixothelys.mod_swe.proxies.ClientProxy", serverSide="de.mixothelys.mod_swe.proxies.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        tab = new CreativeTabSWE(CreativeTabs.getNextID(), "SWE");
        proxy.preInit(event);
        ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new Decorator());
        proxy.init(event);
        ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        SWEItems.preInit(event);
        SWEBlocks.registerItems(event);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        SWEBlocks.registerBlocks(event);
    }

    @SubscribeEvent
    public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        SWESoundHandler.init(event);
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    @Config(modid="mod_swe", type=Config.Type.INSTANCE)
    public static class CONFIGURATIONSWE {
        @Config.Name(value="worldGen")
        public static final WorldGen worldGen = new WorldGen();

        public static class WorldGen {
            @Config.Comment(value={"Bush generation tries for the world generator", "Default: 1"})
            @Config.RangeInt(min=0, max=255)
            public int worldGenTries = 1;
            @Config.Comment(value={"Bush generation patch chances for the world generator", "Default: 1"})
            @Config.RangeInt(min=0, max=255)
            public int worldGenPatchChance = 1;
            @Config.Comment(value={"Bush generation patch size for the world generator", "Default: 4"})
            @Config.RangeInt(min=0, max=255)
            public int worldGenPatchSize = 4;
            @Config.Comment(value={"Bush generation quantity for the world generator", "Default: 1"})
            @Config.RangeInt(min=0, max=255)
            public int worldGenQuantity = 1;
            @Config.Comment(value={"Bush generation density for the world generator", "Default: 3"})
            @Config.RangeInt(min=0, max=255)
            public int worldGenDensity = 3;
        }
    }
}

