/*
 * Decompiled with CFR 0.152.
 */
package de.mixothelys.mod_swe.blocks;

import de.mixothelys.mod_swe.SWECore;
import de.mixothelys.mod_swe.items.SWEItems;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;

public class BlockCannabisBush
extends Block
implements IPlantable,
IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
    public ItemStack droppedItem;
    public static final AxisAlignedBB SMALL_BUSH_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    public static final AxisAlignedBB MEDIUM_BUSH_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.75, 0.875);
    public static final AxisAlignedBB FULL_BUSH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockCannabisBush() {
        super(Material.field_151585_k, MapColor.field_151651_C);
        this.setRegistryName("cannabis_bush");
        this.func_149663_c("cannabis_bush");
        this.func_149647_a(SWECore.tab);
        this.func_149711_c(0.2f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        this.setItemDrop(new ItemStack(SWEItems.cannabisLeaf));
    }

    public boolean isRipe(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) >= 3;
    }

    public void setItemDrop(ItemStack itemIn) {
        this.droppedItem = itemIn;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age == 0) {
            return SMALL_BUSH_AABB;
        }
        if (age == 1) {
            return MEDIUM_BUSH_AABB;
        }
        if (age == 2) {
            return FULL_BUSH_AABB;
        }
        if (age == 3) {
            return FULL_BUSH_AABB;
        }
        return FULL_BUSH_AABB;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getRandomGrowthBush() {
        Random r = new Random();
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(r.nextInt(4)));
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.isRipe(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age < 2) {
            int setMeta = rand.nextInt(2) + 1 + age;
            worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(setMeta)), 4);
            return;
        }
        IBlockState upBlock = worldIn.func_180495_p(pos.func_177984_a());
        if (upBlock == null || worldIn.func_175623_d(pos.func_177984_a())) {
            if (rand.nextInt(3) == 0) {
                worldIn.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)), 2);
            }
            return;
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age == 0) {
            return false;
        }
        if (age == 1) {
            return false;
        }
        if (age == 2) {
            return true;
        }
        return age == 3;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        int age = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)AGE);
        if (age == 3) {
            worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(2)), 2);
            ItemStack itemDrop = new ItemStack(this.droppedItem.func_77973_b(), 1, this.droppedItem.func_77952_i());
            EntityItem entityitem = new EntityItem(worldIn, playerIn.field_70165_t, playerIn.field_70163_u - 1.0, playerIn.field_70161_v, itemDrop);
            worldIn.func_72838_d((Entity)entityitem);
            if (!(playerIn instanceof FakePlayer)) {
                entityitem.func_70100_b_(playerIn);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age == 3) {
            if (worldIn.field_72995_K) {
                return true;
            }
            worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(2)), 2);
            ItemStack itemDrop = new ItemStack(this.droppedItem.func_77973_b(), 1, this.droppedItem.func_77952_i());
            EntityItem entityitem = new EntityItem(worldIn, playerIn.field_70165_t, playerIn.field_70163_u - 1.0, playerIn.field_70161_v, itemDrop);
            worldIn.func_72838_d((Entity)entityitem);
            if (!(playerIn instanceof FakePlayer)) {
                entityitem.func_70100_b_(playerIn);
            }
            return true;
        }
        return false;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        int height = 1;
        while (worldIn.func_180495_p(pos.func_177979_c(height)).func_177230_c() == this) {
            ++height;
        }
        if (rand.nextInt(20) == 0 && worldIn.func_175671_l(pos) >= 8) {
            int age = (Integer)state.func_177229_b((IProperty)AGE);
            if (age < 3) {
                worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            }
            if (rand.nextInt(3) == 0 && height < 3 && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a && age >= 2) {
                worldIn.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)), 2);
            }
        }
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        if (state.func_177227_a().contains(AGE)) {
            return (Integer)state.func_177229_b((IProperty)AGE) > 2;
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }
}

