/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.api.config.settings;

import dev.satyrn.wolfarmor.api.config.settings.ValueSetting;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraftforge.common.config.Property;

public class BooleanSetting
extends ValueSetting<Boolean> {
    public BooleanSetting(boolean defaultValue) {
        super(defaultValue);
        this.setPropertyType(Property.Type.BOOLEAN);
    }

    @Override
    public Boolean readTag(NBTBase tag) {
        return ((NBTTagByte)tag).func_150290_f() != 0;
    }

    @Override
    public NBTBase writeTag(Boolean value) {
        return new NBTTagByte((byte)((Boolean)this.getValue() != false ? 1 : 0));
    }

    @Override
    @Nonnull
    public Boolean parse(String value) {
        switch (value.toLowerCase()) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw new IllegalArgumentException(String.format("The string '%s' is not a valid boolean.", value));
    }
}

