/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.client.gui.elements;

import goblinbob.mobends.core.client.gui.elements.GuiElement;
import goblinbob.mobends.core.util.Draw;
import goblinbob.mobends.core.util.GUtil;
import goblinbob.mobends.core.util.UIScissorHelper;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;

public abstract class GuiScrollPanel
extends GuiElement {
    protected int width;
    protected int height;
    protected int scrollBarWidth;
    protected int contentSize;
    protected int scrollAmountTarget;
    protected int prevScrollAmount;
    protected int scrollAmount;
    protected boolean hovered;
    protected boolean scrollBarHovered;
    protected boolean scrollHandleHovered;
    protected boolean scrollBarGrabbed;
    protected int scrollBarGrabY;

    public GuiScrollPanel(GuiElement parent, int x, int y, int width, int height) {
        super(parent, x, y);
        this.width = width;
        this.height = height;
        this.scrollBarWidth = 6;
        this.contentSize = 0;
        this.scrollAmountTarget = 0;
        this.scrollAmount = 0;
        this.hovered = false;
        this.scrollBarHovered = false;
        this.scrollHandleHovered = false;
        this.scrollBarGrabbed = false;
        this.scrollBarGrabY = 0;
    }

    @Override
    public void update(int mouseX, int mouseY) {
        this.hovered = mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        this.scrollBarHovered = false;
        this.scrollHandleHovered = false;
        if (this.scrollBarGrabbed) {
            this.scrollTo((mouseY - this.y - this.scrollBarGrabY) * this.contentSize / this.height);
        }
        if (this.hovered && mouseX >= this.x + this.width - this.scrollBarWidth) {
            this.scrollBarHovered = true;
            int scrollHandleY = this.getScrollHandleY();
            int scrollBarHeight = this.getScrollHandleHeight();
            if (mouseY >= this.y + scrollHandleY && mouseY <= this.y + scrollHandleY + scrollBarHeight) {
                this.scrollHandleHovered = true;
            }
        }
        this.prevScrollAmount = this.scrollAmount;
        this.scrollAmount = (int)((float)this.scrollAmount + (float)(this.scrollAmountTarget - this.scrollAmount) * this.getScrollTweenSpeed());
    }

    @Override
    public boolean handleMouseClicked(int mouseX, int mouseY, int button) {
        super.handleMouseClicked(mouseX, mouseY, button);
        this.scrollBarGrabbed = false;
        if (this.scrollBarHovered) {
            this.scrollBarGrabY = this.scrollHandleHovered ? mouseY - this.y - this.getScrollHandleY() : this.getScrollHandleHeight() / 2;
            this.scrollBarGrabbed = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMouseReleased(int mouseX, int mouseY, int button) {
        this.scrollBarGrabbed = false;
        return false;
    }

    public boolean handleMouseInput() {
        int mouseWheelRoll = -Mouse.getEventDWheel();
        if (this.hovered) {
            if (mouseWheelRoll != 0) {
                mouseWheelRoll = mouseWheelRoll > 0 ? 1 : -1;
                this.scroll(mouseWheelRoll * this.getScrollSpeed());
            }
            return true;
        }
        return false;
    }

    protected void scrollTo(int value) {
        if (this.contentSize <= this.height) {
            this.scrollAmountTarget = 0;
            return;
        }
        this.scrollAmountTarget = value;
        if (this.scrollAmountTarget < 0) {
            this.scrollAmountTarget = 0;
        } else if (this.scrollAmountTarget > this.contentSize - this.height) {
            this.scrollAmountTarget = this.contentSize - this.height;
        }
    }

    protected void scroll(int amount) {
        this.scrollTo(this.scrollAmountTarget + amount);
    }

    @Override
    public void draw(float partialTicks) {
        float scroll = GUtil.lerp(this.prevScrollAmount, this.scrollAmount, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.getViewX(), (float)this.getViewY(), (float)0.0f);
        this.drawBackground(partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)(-scroll), (float)0.0f);
        UIScissorHelper.INSTANCE.setUIBounds((int)this.getAbsoluteX(), (int)this.getAbsoluteY(), this.width - this.scrollBarWidth, this.height);
        UIScissorHelper.INSTANCE.enable();
        this.drawChildren(partialTicks);
        this.drawContent(partialTicks);
        UIScissorHelper.INSTANCE.disable();
        GlStateManager.func_179121_F();
        this.drawForeground(partialTicks);
        GlStateManager.func_179121_F();
    }

    protected abstract void drawContent(float var1);

    @Override
    protected void drawForeground(float partialTicks) {
        this.drawScrollBar(partialTicks);
    }

    protected void drawScrollBar(float partialTicks) {
        if (this.contentSize <= this.height) {
            return;
        }
        int scrollBarHeight = this.getScrollHandleHeight();
        Draw.rectangle(this.width - this.scrollBarWidth, 0, this.scrollBarWidth, this.height, this.getBackgroundColor());
        int barColor = this.scrollBarGrabbed ? this.getScrollBarGrabbedColor() : (this.scrollHandleHovered ? this.getScrollBarHoveredColor() : this.getScrollBarColor());
        Draw.rectangle(this.width - this.scrollBarWidth, this.getScrollHandleY(partialTicks), this.scrollBarWidth, scrollBarHeight, barColor);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    protected int getScrollHandleY() {
        return this.getScrollHandleY(1.0f);
    }

    protected int getScrollHandleY(float partialTicks) {
        if (this.contentSize <= this.height) {
            return 0;
        }
        int scroll = (int)GUtil.lerp(this.prevScrollAmount, this.scrollAmount, partialTicks);
        return scroll * (this.height + 2) / this.contentSize;
    }

    protected int getScrollHandleHeight() {
        if (this.contentSize <= this.height) {
            return 0;
        }
        return this.height * this.height / this.contentSize;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    protected int getScrollSpeed() {
        return 10;
    }

    protected float getScrollTweenSpeed() {
        return 0.5f;
    }

    protected int getBackgroundColor() {
        return -15658735;
    }

    protected int getScrollBarColor() {
        return -7829368;
    }

    protected int getScrollBarHoveredColor() {
        return -6710887;
    }

    protected int getScrollBarGrabbedColor() {
        return -4473925;
    }
}

