/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.client.model.ModelDriveable;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.CollisionBox;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveablePosition;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.EnumWeaponType;
import com.flansmod.common.driveables.PilotGun;
import com.flansmod.common.driveables.Seat;
import com.flansmod.common.driveables.ShootPoint;
import com.flansmod.common.driveables.collisions.CollisionShapeBox;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.paintjob.PaintableType;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.common.vector.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBase;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class DriveableType
extends PaintableType {
    @SideOnly(value=Side.CLIENT)
    public ModelDriveable model;
    public HashMap<EnumDriveablePart, CollisionBox> health = new HashMap();
    public HashMap<EnumDriveablePart, ItemStack[]> partwiseRecipe = new HashMap();
    public ArrayList<ItemStack> driveableRecipe = new ArrayList();
    public boolean acceptAllAmmo = true;
    public List<BulletType> ammo = new ArrayList<BulletType>();
    public boolean harvestBlocks = false;
    public ArrayList<Material> materialsHarvested = new ArrayList();
    public boolean collectHarvest = false;
    public boolean dropHarvest = false;
    public Vector3f harvestBoxSize = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f harvestBoxPos = new Vector3f(0.0f, 0.0f, 0.0f);
    public int reloadSoundTick = 15214541;
    public float fallDamageFactor = 1.0f;
    public EnumWeaponType primary = EnumWeaponType.NONE;
    public EnumWeaponType secondary = EnumWeaponType.NONE;
    public boolean alternatePrimary = false;
    public boolean alternateSecondary = false;
    public int shootDelayPrimary = 1;
    public int shootDelaySecondary = 1;
    public EnumFireMode modePrimary = EnumFireMode.FULLAUTO;
    public EnumFireMode modeSecondary = EnumFireMode.FULLAUTO;
    public int damageModifierPrimary = 1;
    public int damageModifierSecondary = 1;
    public ArrayList<ShootPoint> shootPointsPrimary = new ArrayList();
    public ArrayList<ShootPoint> shootPointsSecondary = new ArrayList();
    public ArrayList<PilotGun> pilotGuns = new ArrayList();
    public String shootSoundPrimary;
    public String shootSoundSecondary;
    public int reloadTimePrimary = 0;
    public int reloadTimeSecondary = 0;
    public String reloadSoundPrimary = "";
    public String reloadSoundSecondary = "";
    public int placeTimePrimary = 5;
    public int placeTimeSecondary = 5;
    public String placeSoundPrimary = "";
    public String placeSoundSecondary = "";
    public int numPassengers = 0;
    public Seat[] seats;
    public int numPassengerGunners = 0;
    public int numCargoSlots;
    public int numBombSlots;
    public int numMissileSlots;
    public int fuelTankSize = 100;
    public float yOffset = 0.625f;
    public float cameraDistance = 5.0f;
    public ArrayList<ParticleEmitter> emitters = new ArrayList();
    public float vehicleGunModelScale = 1.0f;
    public double hitboxRadius = 0.0;
    public ArrayList<ShootParticle> shootParticlesPrimary = new ArrayList();
    public ArrayList<ShootParticle> shootParticlesSecondary = new ArrayList();
    public float maxThrottle = 1.0f;
    public float maxNegativeThrottle = 0.0f;
    public float ClutchBrake = 0.0f;
    public Vector3f turretOrigin = new Vector3f();
    public Vector3f turretOriginOffset = new Vector3f();
    public DriveablePosition[] wheelPositions = new DriveablePosition[0];
    public float wheelSpringStrength = 0.5f;
    public float wheelStepHeight = 1.0f;
    public boolean canRoll = true;
    public float turretRotationSpeed = 2.5f;
    public ArrayList<DriveablePosition> collisionPoints = new ArrayList();
    public float drag = 1.0f;
    public boolean floatOnWater = false;
    public boolean placeableOnLand = true;
    public boolean placeableOnWater = false;
    public boolean placeableOnSponge = false;
    public float buoyancy = 0.0165f;
    public float floatOffset = 0.0f;
    public float bulletDetectionRadius = 5.0f;
    public boolean onRadar = false;
    public int animFrames = 2;
    public String startSound = "";
    public int startSoundLength;
    public String engineSound = "";
    public int engineSoundLength;
    public boolean collisionDamageEnable = false;
    public float collisionDamageThrottle = 0.0f;
    public float collisionDamageTimes = 0.0f;
    public boolean enableReloadTime = false;
    public boolean canMountEntity = false;
    public float bulletSpread = 0.0f;
    public float bulletSpeed = 3.0f;
    public boolean rangingGun = false;
    public boolean isExplosionWhenDestroyed = false;
    public String lockedOnSound = "";
    public int canLockOnAngle = 10;
    public int lockOnSoundTime = 60;
    public int lockedOnSoundRange = 5;
    public String lockingOnSound = "";
    public boolean lockOnToPlanes = false;
    public boolean lockOnToVehicles = false;
    public boolean lockOnToMechas = false;
    public boolean lockOnToPlayers = false;
    public boolean lockOnToLivings = false;
    public boolean hasFlare = false;
    public int flareDelay = 200;
    public String flareSound = "";
    public int timeFlareUsing = 1;
    public int radarDetectableAltitude = -1;
    public boolean stealth = false;
    public float recoilDist = 5.0f;
    public float recoilTime = 5.0f;
    public boolean fixedPrimaryFire = false;
    public Vector3f primaryFireAngle = new Vector3f(0.0f, 0.0f, 0.0f);
    public float gunLength = 0.0f;
    public boolean setPlayerInvisible = false;
    public float maxThrottleInWater = 0.5f;
    public ArrayList<Vector3f> leftTrackPoints = new ArrayList();
    public ArrayList<Vector3f> rightTrackPoints = new ArrayList();
    public float trackLinkLength = 0.0f;
    public boolean IT1 = false;
    public ArrayList<CollisionShapeBox> collisionBox = new ArrayList();
    public boolean fancyCollision = false;
    public static ArrayList<DriveableType> types = new ArrayList();
    private static HashMap<String, InfoType.ParseFunc<DriveableType>> parsers = new HashMap();

    public DriveableType(TypeFile file) {
        super(file);
    }

    @Override
    public void preRead(TypeFile file) {
        String[] split;
        super.preRead(file);
        for (String line : file.getLines()) {
            if (line == null) break;
            if (line.startsWith("//") || (split = line.split(" ")).length < 2 || !split[0].equals("Passengers")) continue;
            this.numPassengers = Integer.parseInt(split[1]);
            this.seats = new Seat[this.numPassengers + 1];
            break;
        }
        for (String line : file.getLines()) {
            if (line == null) break;
            if (line.startsWith("//") || (split = line.split(" ")).length < 2 || !split[0].equals("NumWheels")) continue;
            this.wheelPositions = new DriveablePosition[Integer.parseInt(split[1])];
            break;
        }
        types.add(this);
    }

    @Override
    public void postRead(TypeFile file) {
        super.postRead(file);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        try {
            if (FMLCommonHandler.instance().getSide().isClient() && split[0].equals("Model")) {
                this.model = FlansMod.proxy.loadModel(split[1], this.shortName, ModelDriveable.class);
            } else {
                InfoType.ParseFunc<DriveableType> parser = parsers.get(split[0]);
                if (parser != null) {
                    parser.Parse(split, this);
                } else {
                    super.read(split, file);
                }
            }
        }
        catch (Exception e) {
            FlansMod.log.error("Errored reading " + file.name);
            FlansMod.log.throwing((Throwable)e);
        }
    }

    public abstract EntityDriveable createDriveable(World var1, double var2, double var4, double var6, DriveableData var8);

    private DriveablePosition getShootPoint(String[] split) {
        if (split.length == 6) {
            return new PilotGun(split);
        }
        if (split.length == 5) {
            return new DriveablePosition(split);
        }
        return new DriveablePosition(new Vector3f(), EnumDriveablePart.core);
    }

    public List<ShootPoint> shootPoints(boolean s) {
        return s ? this.shootPointsSecondary : this.shootPointsPrimary;
    }

    public boolean alternate(boolean s) {
        return s ? this.alternateSecondary : this.alternatePrimary;
    }

    public EnumWeaponType weaponType(boolean s) {
        return s ? this.secondary : this.primary;
    }

    public int shootDelay(boolean s) {
        return s ? this.shootDelaySecondary : this.shootDelayPrimary;
    }

    public String shootSound(boolean s) {
        return s ? this.shootSoundSecondary : this.shootSoundPrimary;
    }

    public int numEngines() {
        return 1;
    }

    public int ammoSlots() {
        return this.numPassengerGunners + this.pilotGuns.size();
    }

    public boolean isValidAmmo(BulletType bulletType, EnumWeaponType weaponType) {
        return (this.acceptAllAmmo || this.ammo.contains(bulletType)) && bulletType.weaponType == weaponType;
    }

    public ArrayList<ItemStack> getItemsRequired(DriveablePart part, PartType engine) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.partwiseRecipe.get((Object)part.type) != null) {
            for (ItemStack itemStack : this.partwiseRecipe.get((Object)part.type)) {
                stacks.add(itemStack.func_77946_l());
            }
        }
        for (PilotGun gun : this.pilotGuns) {
            if (gun.part != part.type) continue;
            stacks.add(new ItemStack(gun.type.item));
        }
        for (Seat seat : this.seats) {
            if (seat == null || seat.part != part.type || seat.gunType == null) continue;
            stacks.add(new ItemStack(seat.gunType.item));
        }
        return stacks;
    }

    public static DriveableType getDriveable(String find) {
        for (DriveableType type : types) {
            if (!type.shortName.equals(find)) continue;
            return type;
        }
        return null;
    }

    @Override
    public void addLoot(LootTableLoadEvent event) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return this.model;
    }

    @Override
    public float GetRecommendedScale() {
        return 100.0f / this.cameraDistance;
    }

    static {
        parsers.put("MaxThrottle", (split, d) -> {
            d.maxThrottle = Float.parseFloat(split[1]);
        });
        parsers.put("MaxNegativeThrottle", (split, d) -> {
            d.maxNegativeThrottle = Float.parseFloat(split[1]);
        });
        parsers.put("Drag", (split, d) -> {
            d.drag = Float.parseFloat(split[1]);
        });
        parsers.put("TurretOrigin", (split, d) -> {
            d.turretOrigin = new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f);
        });
        parsers.put("TurretRotationSpeed", (split, d) -> {
            d.turretRotationSpeed = Float.parseFloat(split[1]);
        });
        parsers.put("CanRoll", (split, d) -> {
            d.canRoll = Boolean.parseBoolean(split[1]);
        });
        parsers.put("YOffset", (split, d) -> {
            d.yOffset = Float.parseFloat(split[1]);
        });
        parsers.put("CameraDistance", (split, d) -> {
            d.cameraDistance = Float.parseFloat(split[1]);
        });
        parsers.put("PlaceableOnLand", (split, d) -> {
            d.placeableOnLand = Boolean.parseBoolean(split[1]);
        });
        parsers.put("PlaceableOnWater", (split, d) -> {
            d.placeableOnWater = Boolean.parseBoolean(split[1]);
        });
        parsers.put("FloatOnWater", (split, d) -> {
            d.floatOnWater = Boolean.parseBoolean(split[1]);
        });
        parsers.put("Boat", (split, d) -> {
            d.placeableOnLand = false;
            d.placeableOnWater = true;
            d.floatOnWater = true;
            d.wheelStepHeight = 0.0f;
        });
        parsers.put("Buoyancy", (split, d) -> {
            d.buoyancy = Float.parseFloat(split[1]);
        });
        parsers.put("Wheel", (split, d) -> {
            d.wheelPositions[Integer.parseInt((String)split[1])] = new DriveablePosition(new Vector3f(Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f, Float.parseFloat(split[4]) / 16.0f), split.length > 5 ? EnumDriveablePart.getPart(split[5]) : EnumDriveablePart.coreWheel);
        });
        parsers.put("WheelPosition", parsers.get("Wheel"));
        parsers.put("WheelRadius", (split, d) -> {
            d.wheelStepHeight = Float.parseFloat(split[1]);
        });
        parsers.put("WheelStepHeight", parsers.get("WheelRadius"));
        parsers.put("WheelSpringStrength", (split, d) -> {
            d.wheelSpringStrength = Float.parseFloat(split[1]);
        });
        parsers.put("SpringStrength", parsers.get("WheelSpringStrength"));
        parsers.put("Harvester", (split, d) -> {
            d.harvestBlocks = Boolean.parseBoolean(split[1]);
        });
        parsers.put("HarvestMaterial", (split, d) -> d.materialsHarvested.add(DriveableType.getMaterial(split[1])));
        parsers.put("HarvestToolType", (split, d) -> {
            switch (split[1]) {
                case "Axe": {
                    d.materialsHarvested.add(Material.field_151575_d);
                    d.materialsHarvested.add(Material.field_151585_k);
                    d.materialsHarvested.add(Material.field_151582_l);
                    break;
                }
                case "Pickaxe": 
                case "Drill": {
                    d.materialsHarvested.add(Material.field_151573_f);
                    d.materialsHarvested.add(Material.field_151574_g);
                    d.materialsHarvested.add(Material.field_151576_e);
                    break;
                }
                case "Spade": 
                case "Shovel": 
                case "Excavator": {
                    d.materialsHarvested.add(Material.field_151578_c);
                    d.materialsHarvested.add(Material.field_151577_b);
                    d.materialsHarvested.add(Material.field_151595_p);
                    d.materialsHarvested.add(Material.field_151597_y);
                    d.materialsHarvested.add(Material.field_151571_B);
                    break;
                }
                case "Hoe": 
                case "Combine": {
                    d.materialsHarvested.add(Material.field_151585_k);
                    d.materialsHarvested.add(Material.field_151584_j);
                    d.materialsHarvested.add(Material.field_151582_l);
                    d.materialsHarvested.add(Material.field_151570_A);
                    d.materialsHarvested.add(Material.field_151572_C);
                }
            }
        });
        parsers.put("CargoSlots", (split, d) -> {
            d.numCargoSlots = Integer.parseInt(split[1]);
        });
        parsers.put("BombSlots", (split, d) -> {
            d.numBombSlots = Integer.parseInt(split[1]);
        });
        parsers.put("MineSlots", parsers.get("BombSlots"));
        parsers.put("MissileSlots", (split, d) -> {
            d.numMissileSlots = Integer.parseInt(split[1]);
        });
        parsers.put("ShellSlots", parsers.get("MissileSlots"));
        parsers.put("FuelTankSize", (split, d) -> {
            d.fuelTankSize = Integer.parseInt(split[1]);
        });
        parsers.put("TrackFrames", (split, d) -> {
            d.animFrames = Integer.parseInt(split[1]) - 1;
        });
        parsers.put("BulletDetection", (split, d) -> {
            d.bulletDetectionRadius = Integer.parseInt(split[1]);
        });
        parsers.put("AddAmmo", (split, d) -> d.ammo.add(BulletType.getBullet(split[1])));
        parsers.put("AllowAllAmmo", (split, d) -> {
            d.acceptAllAmmo = Boolean.parseBoolean(split[1]);
        });
        parsers.put("AcceptAllAmmo", parsers.get("AllowAllAmmo"));
        parsers.put("Primary", (split, d) -> {
            d.primary = EnumWeaponType.valueOf(split[1].toUpperCase());
        });
        parsers.put("Secondary", (split, d) -> {
            d.secondary = EnumWeaponType.valueOf(split[1].toUpperCase());
        });
        parsers.put("ShootDelayPrimary", (split, d) -> {
            d.shootDelayPrimary = Integer.parseInt(split[1]);
        });
        parsers.put("ShootDelaySecondary", (split, d) -> {
            d.shootDelaySecondary = Integer.parseInt(split[1]);
        });
        parsers.put("DamageModifierPrimary", (split, d) -> {
            d.damageModifierPrimary = Integer.parseInt(split[1]);
        });
        parsers.put("DamageModifierSecondary", (split, d) -> {
            d.damageModifierSecondary = Integer.parseInt(split[1]);
        });
        parsers.put("AlternatePrimary", (split, d) -> {
            d.alternatePrimary = Boolean.parseBoolean(split[1]);
        });
        parsers.put("AlternateSecondary", (split, d) -> {
            d.alternateSecondary = Boolean.parseBoolean(split[1]);
        });
        parsers.put("ModePrimary", (split, d) -> {
            d.modePrimary = EnumFireMode.valueOf(split[1].toUpperCase());
        });
        parsers.put("ModeSecondary", (split, d) -> {
            d.modeSecondary = EnumFireMode.valueOf(split[1].toUpperCase());
        });
        parsers.put("ShootPointPrimary", (split, d) -> {
            Vector3f offPos;
            String[] gun;
            if (split.length == 9) {
                gun = new String[]{split[0], split[1], split[2], split[3], split[4], split[5]};
                offPos = new Vector3f(Float.parseFloat(split[6]) / 16.0f, Float.parseFloat(split[7]) / 16.0f, Float.parseFloat(split[8]) / 16.0f);
            } else if (split.length == 8) {
                gun = new String[]{split[0], split[1], split[2], split[3], split[4]};
                offPos = new Vector3f(Float.parseFloat(split[5]) / 16.0f, Float.parseFloat(split[6]) / 16.0f, Float.parseFloat(split[7]) / 16.0f);
            } else {
                gun = split;
                offPos = new Vector3f(0.0f, 0.0f, 0.0f);
            }
            DriveablePosition rootPos = d.getShootPoint(gun);
            ShootPoint sPoint = new ShootPoint(rootPos, offPos);
            d.shootPointsPrimary.add(sPoint);
            if (rootPos instanceof PilotGun) {
                d.pilotGuns.add((PilotGun)sPoint.rootPos);
            }
        });
        parsers.put("ShootPointSecondary", (split, d) -> {
            Vector3f offPos;
            String[] gun;
            if (split.length == 9) {
                gun = new String[]{split[0], split[1], split[2], split[3], split[4], split[5]};
                offPos = new Vector3f(Float.parseFloat(split[6]) / 16.0f, Float.parseFloat(split[7]) / 16.0f, Float.parseFloat(split[8]) / 16.0f);
            } else if (split.length == 8) {
                gun = new String[]{split[0], split[1], split[2], split[3], split[4]};
                offPos = new Vector3f(Float.parseFloat(split[5]) / 16.0f, Float.parseFloat(split[6]) / 16.0f, Float.parseFloat(split[7]) / 16.0f);
            } else {
                gun = split;
                offPos = new Vector3f(0.0f, 0.0f, 0.0f);
            }
            DriveablePosition rootPos = d.getShootPoint(gun);
            ShootPoint sPoint = new ShootPoint(rootPos, offPos);
            d.shootPointsSecondary.add(sPoint);
            if (rootPos instanceof PilotGun) {
                d.pilotGuns.add((PilotGun)sPoint.rootPos);
            }
        });
        parsers.put("AddGun", (split, d) -> {
            d.secondary = EnumWeaponType.GUN;
            PilotGun pilotGun = (PilotGun)d.getShootPoint(split);
            d.shootPointsSecondary.add(new ShootPoint(pilotGun, new Vector3f(0.0f, 0.0f, 0.0f)));
            d.pilotGuns.add(pilotGun);
            d.driveableRecipe.add(new ItemStack(pilotGun.type.item));
        });
        parsers.put("BombPosition", (split, d) -> {
            d.primary = EnumWeaponType.BOMB;
            DriveablePosition pos = new DriveablePosition(new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f), EnumDriveablePart.core);
            d.shootPointsPrimary.add(new ShootPoint(pos, new Vector3f(0.0f, 0.0f, 0.0f)));
        });
        parsers.put("BarrelPosition", (split, d) -> {
            d.primary = EnumWeaponType.SHELL;
            DriveablePosition pos = new DriveablePosition(new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f), EnumDriveablePart.turret);
            d.shootPointsPrimary.add(new ShootPoint(pos, new Vector3f(0.0f, 0.0f, 0.0f)));
        });
        parsers.put("ShootDelay", (split, d) -> {
            d.shootDelaySecondary = Integer.parseInt(split[1]);
        });
        parsers.put("ShellDelay", (split, d) -> {
            d.shootDelayPrimary = Integer.parseInt(split[1]);
        });
        parsers.put("BombDelay", parsers.get("ShellDelay"));
        parsers.put("AddRecipeParts", (split, d) -> {
            EnumDriveablePart part = EnumDriveablePart.getPart(split[1]);
            ItemStack[] stacks = new ItemStack[(split.length - 2) / 2];
            for (int i = 0; i < (split.length - 2) / 2; ++i) {
                int amount = Integer.parseInt(split[2 * i + 2]);
                boolean damaged = split[2 * i + 3].contains(".");
                String itemName = damaged ? split[2 * i + 3].split("\\.")[0] : split[2 * i + 3];
                int damage = damaged ? Integer.parseInt(split[2 * i + 3].split("\\.")[1]) : 0;
                stacks[i] = DriveableType.getRecipeElement(itemName, amount, damage);
                d.driveableRecipe.add(stacks[i]);
            }
            d.partwiseRecipe.put(part, stacks);
        });
        parsers.put("AddDye", (split, d) -> {
            int amount = Integer.parseInt(split[1]);
            int damage = -1;
            for (int i = 0; i < EnumDyeColor.values().length; ++i) {
                if (!EnumDyeColor.func_176766_a((int)i).func_176762_d().equals(split[2])) continue;
                damage = i;
            }
            if (damage == -1) {
                FlansMod.log.warn("Failed to find dye colour : " + split[2] + " while adding " + d.shortName);
                return;
            }
            d.driveableRecipe.add(new ItemStack(Items.field_151100_aR, amount, damage));
        });
        parsers.put("SetupPart", (split, d) -> {
            EnumDriveablePart part = EnumDriveablePart.getPart(split[1]);
            CollisionBox box = new CollisionBox(Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), Integer.parseInt(split[5]), Integer.parseInt(split[6]), Integer.parseInt(split[7]), Integer.parseInt(split[8]));
            d.health.put(part, box);
            double max = box.Max();
            if (max > d.hitboxRadius) {
                d.hitboxRadius = max;
            }
        });
        parsers.put("CollisionPoint", (split, d) -> d.collisionPoints.add(new DriveablePosition(split)));
        parsers.put("AddCollisionPoint", parsers.get("CollisionPoint"));
        parsers.put("Driver", (split, d) -> {
            d.seats[0] = split.length > 4 ? new Seat(Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Float.parseFloat(split[4]), Float.parseFloat(split[5]), Float.parseFloat(split[6]), Float.parseFloat(split[7])) : new Seat(Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]));
        });
        parsers.put("Pilot", parsers.get("Driver"));
        parsers.put("Passenger", (split, d) -> {
            Seat seat;
            d.seats[seat.id] = seat = new Seat(split);
            if (seat.gunType != null) {
                seat.gunnerID = d.numPassengerGunners++;
                d.driveableRecipe.add(new ItemStack(seat.gunType.item));
            }
        });
        parsers.put("GunOrigin", (split, d) -> {
            if (d.seats[Integer.parseInt(split[1])] == null) {
                FlansMod.log.error("GunOrigin line found in vehicle / mecha / plane file before Passenger line [" + d.shortName + "]");
            }
            d.seats[Integer.parseInt((String)split[1])].gunOrigin = new Vector3f(Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f, Float.parseFloat(split[4]) / 16.0f);
        });
        parsers.put("RotatedDriverOffset", (split, d) -> {
            d.seats[0].rotatedOffset = new Vector3f((float)Integer.parseInt(split[1]) / 16.0f, (float)Integer.parseInt(split[2]) / 16.0f, (float)Integer.parseInt(split[3]) / 16.0f);
        });
        parsers.put("DriverAimSpeed", (split, d) -> {
            d.seats[0].aimingSpeed = new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]));
        });
        parsers.put("RotatedPassengerOffset", (split, d) -> {
            d.seats[Integer.parseInt((String)split[1])].rotatedOffset = new Vector3f((float)Integer.parseInt(split[2]) / 16.0f, (float)Integer.parseInt(split[3]) / 16.0f, (float)Integer.parseInt(split[4]) / 16.0f);
        });
        parsers.put("PassengerAimSpeed", (split, d) -> {
            d.seats[Integer.parseInt((String)split[1])].aimingSpeed = new Vector3f(Float.parseFloat(split[2]), Float.parseFloat(split[3]), Float.parseFloat(split[4]));
        });
        parsers.put("DriverLegacyAiming", (split, d) -> {
            d.seats[0].legacyAiming = Boolean.parseBoolean(split[1]);
        });
        parsers.put("PassengerLegacyAiming", (split, d) -> {
            d.seats[Integer.parseInt((String)split[1])].legacyAiming = Boolean.parseBoolean(split[2]);
        });
        parsers.put("DriverYawBeforePitch", (split, d) -> {
            d.seats[0].yawBeforePitch = Boolean.parseBoolean(split[1]);
        });
        parsers.put("PassengerYawBeforePitch", (split, d) -> {
            d.seats[Integer.parseInt((String)split[1])].yawBeforePitch = Boolean.parseBoolean(split[2]);
        });
        parsers.put("DriverLatePitch", (split, d) -> {
            d.seats[0].latePitch = Boolean.parseBoolean(split[1]);
        });
        parsers.put("PassengerLatePitch", (split, d) -> {
            d.seats[Integer.parseInt((String)split[1])].latePitch = Boolean.parseBoolean(split[2]);
        });
        parsers.put("DriverTraverseSounds", (split, d) -> {
            d.seats[0].traverseSounds = Boolean.parseBoolean(split[1]);
        });
        parsers.put("PassengerTraverseSounds", (split, d) -> {
            d.seats[Integer.parseInt((String)split[1])].traverseSounds = Boolean.parseBoolean(split[2]);
        });
        parsers.put("StartSoundLength", (split, d) -> {
            d.startSoundLength = Integer.parseInt(split[1]);
        });
        parsers.put("EngineSoundLength", (split, d) -> {
            d.engineSoundLength = Integer.parseInt(split[1]);
        });
        parsers.put("YawSoundLength", (split, d) -> {
            d.seats[0].yawSoundLength = Integer.parseInt(split[1]);
        });
        parsers.put("PitchSoundLength", (split, d) -> {
            d.seats[0].pitchSoundLength = Integer.parseInt(split[1]);
        });
        parsers.put("PassengerYawSoundLength", (split, d) -> {
            d.seats[Integer.parseInt((String)split[1])].yawSoundLength = Integer.parseInt(split[2]);
        });
        parsers.put("PassengerPitchSoundLength", (split, d) -> {
            d.seats[Integer.parseInt((String)split[1])].pitchSoundLength = Integer.parseInt(split[2]);
        });
        parsers.put("StartSound", (split, d) -> {
            d.startSound = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("EngineSound", (split, d) -> {
            d.engineSound = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("YawSound", (split, d) -> {
            d.seats[0].yawSound = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("PitchSound", (split, d) -> {
            d.seats[0].pitchSound = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("PassengerYawSound", (split, d) -> {
            d.seats[Integer.parseInt((String)split[1])].yawSound = split[2];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("PassengerPitchSound", (split, d) -> {
            d.seats[Integer.parseInt((String)split[1])].pitchSound = split[2];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("ShootMainSound", (split, d) -> {
            d.shootSoundPrimary = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("ShootSoundPrimary", parsers.get("ShootMainSound"));
        parsers.put("ShellSound", parsers.get("ShootMainSound"));
        parsers.put("BombSound", parsers.get("ShootMainSound"));
        parsers.put("ShootSecondarySound", (split, d) -> {
            d.shootSoundSecondary = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("ShootSoundSecondary", parsers.get("ShootSecondarySound"));
        parsers.put("OnRadar", (split, d) -> {
            d.onRadar = split[1].equals("True");
        });
        parsers.put("AddParticle", (split, d) -> {
            ParticleEmitter emitter = (DriveableType)d.new ParticleEmitter();
            emitter.effectType = FlansMod.getParticleType(split[1]);
            emitter.emitRate = Integer.parseInt(split[2]);
            emitter.origin = new Vector3f(split[3], d.shortName);
            emitter.extents = new Vector3f(split[4], d.shortName);
            emitter.velocity = new Vector3f(split[5], d.shortName);
            emitter.minThrottle = Float.parseFloat(split[6]);
            emitter.maxThrottle = Float.parseFloat(split[7]);
            emitter.minHealth = Float.parseFloat(split[8]);
            emitter.maxHealth = Float.parseFloat(split[9]);
            emitter.part = split[10];
            emitter.origin.scale(0.0625f);
            emitter.extents.scale(0.0625f);
            emitter.velocity.scale(0.0625f);
            d.emitters.add(emitter);
        });
        parsers.put("Model", (split, d) -> {
            if (FMLCommonHandler.instance().getSide().isClient()) {
                d.model = FlansMod.proxy.loadModel(split[1], d.shortName, ModelDriveable.class);
            }
        });
        parsers.put("IsExplosionWhenDestroyed", (split, d) -> {
            d.isExplosionWhenDestroyed = Boolean.parseBoolean(split[1]);
        });
        parsers.put("VehicleGunModelScale", (split, d) -> {
            d.vehicleGunModelScale = Float.parseFloat(split[1]);
        });
        parsers.put("VehicleGunReloadTick", (split, d) -> {
            d.reloadSoundTick = Integer.parseInt(split[1]);
        });
        parsers.put("FallDamageFactor", (split, d) -> {
            d.fallDamageFactor = Float.parseFloat(split[1]);
        });
        parsers.put("ClutchBrake", (split, d) -> {
            d.ClutchBrake = Float.parseFloat(split[1]);
        });
        parsers.put("MaxThrottleInWater", (split, d) -> {
            d.maxThrottleInWater = Float.parseFloat(split[1]);
        });
        parsers.put("TurretOriginOffset", (split, d) -> {
            d.turretOriginOffset = new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f);
        });
        parsers.put("CollisionDamageEnable", (split, d) -> {
            d.collisionDamageEnable = Boolean.parseBoolean(split[1]);
        });
        parsers.put("CollisionDamageThrottle", (split, d) -> {
            d.collisionDamageThrottle = Float.parseFloat(split[1]);
        });
        parsers.put("CollisionDamageTimes", (split, d) -> {
            d.collisionDamageTimes = Float.parseFloat(split[1]);
        });
        parsers.put("CanLockAngle", (split, d) -> {
            d.canLockOnAngle = Integer.parseInt(split[1]);
        });
        parsers.put("LockOnSoundTime", (split, d) -> {
            d.lockOnSoundTime = Integer.parseInt(split[1]);
        });
        parsers.put("LockOnToDriveables", (split, d) -> {
            d.lockOnToVehicles = d.lockOnToMechas = Boolean.parseBoolean(split[1].toLowerCase());
            d.lockOnToPlanes = d.lockOnToMechas;
        });
        parsers.put("LockOnToVehicles", (split, d) -> {
            d.lockOnToVehicles = Boolean.parseBoolean(split[1].toLowerCase());
        });
        parsers.put("LockOnToPlanes", (split, d) -> {
            d.lockOnToPlanes = Boolean.parseBoolean(split[1].toLowerCase());
        });
        parsers.put("LockOnToMechas", (split, d) -> {
            d.lockOnToMechas = Boolean.parseBoolean(split[1].toLowerCase());
        });
        parsers.put("LockOnToPlayers", (split, d) -> {
            d.lockOnToPlayers = Boolean.parseBoolean(split[1].toLowerCase());
        });
        parsers.put("LockOnToLivings", (split, d) -> {
            d.lockOnToLivings = Boolean.parseBoolean(split[1].toLowerCase());
        });
        parsers.put("LockedOnSoundRange", (split, d) -> {
            d.lockedOnSoundRange = Integer.parseInt(split[1]);
        });
        parsers.put("HasFlare", (split, d) -> {
            d.hasFlare = Boolean.parseBoolean(split[1]);
        });
        parsers.put("FlareDelay", (split, d) -> {
            d.flareDelay = Integer.parseInt(split[1]);
            if (d.flareDelay <= 0) {
                d.flareDelay = 1;
            }
        });
        parsers.put("TimeFlareUsing", (split, d) -> {
            d.timeFlareUsing = Integer.parseInt(split[1]);
            if (d.timeFlareUsing <= 0) {
                d.timeFlareUsing = 1;
            }
        });
        parsers.put("PlaceableOnSponge", (split, d) -> {
            d.placeableOnSponge = Boolean.parseBoolean(split[1]);
        });
        parsers.put("FloatOffset", (split, d) -> {
            d.floatOffset = Float.parseFloat(split[1]);
        });
        parsers.put("CanMountEntity", (split, d) -> {
            d.canMountEntity = Boolean.parseBoolean(split[1]);
        });
        parsers.put("CollectHarvest", (split, d) -> {
            d.collectHarvest = Boolean.parseBoolean(split[1]);
        });
        parsers.put("DropHarvest", (split, d) -> {
            d.dropHarvest = Boolean.parseBoolean(split[1]);
        });
        parsers.put("HarvestBox", (split, d) -> {
            d.harvestBoxSize = new Vector3f(split[1], d.shortName);
            d.harvestBoxPos = new Vector3f(split[2], d.shortName);
        });
        parsers.put("PlaceTimePrimary", (split, d) -> {
            d.placeTimePrimary = Integer.parseInt(split[1]);
        });
        parsers.put("PlaceTimeSecondary", (split, d) -> {
            d.placeTimeSecondary = Integer.parseInt(split[1]);
        });
        parsers.put("ReloadTimePrimary", (split, d) -> {
            d.reloadTimePrimary = Integer.parseInt(split[1]);
        });
        parsers.put("ReloadTimeSecondary", (split, d) -> {
            d.reloadTimeSecondary = Integer.parseInt(split[1]);
        });
        parsers.put("BulletSpeed", (split, d) -> {
            d.bulletSpeed = Float.parseFloat(split[1]);
        });
        parsers.put("BulletSpread", (split, d) -> {
            d.bulletSpread = Float.parseFloat(split[1]);
        });
        parsers.put("RangingGun", (split, d) -> {
            d.rangingGun = Boolean.parseBoolean(split[1]);
        });
        parsers.put("GunLength", (split, d) -> {
            d.gunLength = Float.parseFloat(split[1]);
        });
        parsers.put("RecoilDistance", (split, d) -> {
            d.recoilDist = Float.parseFloat(split[1]);
        });
        parsers.put("RecoilTime", (split, d) -> {
            d.recoilTime = Float.parseFloat(split[1]);
        });
        parsers.put("EnableReloadTime", (split, d) -> {
            d.enableReloadTime = Boolean.parseBoolean(split[1]);
        });
        parsers.put("ShootParticlesPrimary", (split, d) -> d.shootParticlesPrimary.add(new ShootParticle(split[1], Float.valueOf(split[2]).floatValue(), Float.valueOf(split[3]).floatValue(), Float.valueOf(split[4]).floatValue())));
        parsers.put("ShootParticlesSecondary", (split, d) -> d.shootParticlesSecondary.add(new ShootParticle(split[1], Float.valueOf(split[2]).floatValue(), Float.valueOf(split[3]).floatValue(), Float.valueOf(split[4]).floatValue())));
        parsers.put("SetPlayerInvisible", (split, d) -> {
            d.setPlayerInvisible = Boolean.parseBoolean(split[1].toLowerCase());
        });
        parsers.put("IT1", (split, d) -> {
            d.IT1 = Boolean.parseBoolean(split[1].toLowerCase());
        });
        parsers.put("FixedPrimary", (split, d) -> {
            d.fixedPrimaryFire = Boolean.parseBoolean(split[1].toLowerCase());
        });
        parsers.put("PrimaryAngle", (split, d) -> {
            d.primaryFireAngle = new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]));
        });
        parsers.put("PlaceSoundPrimary", (split, d) -> {
            d.placeSoundPrimary = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("PlaceSoundSecondary", (split, d) -> {
            d.placeSoundSecondary = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("ReloadSoundPrimary", (split, d) -> {
            d.reloadSoundPrimary = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("ReloadSoundSecondary", (split, d) -> {
            d.reloadSoundSecondary = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("LockedOnSound", (split, d) -> {
            d.lockedOnSound = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("LockingOnSound", (split, d) -> {
            d.lockingOnSound = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "guns", split[1]);
        });
        parsers.put("FlareSound", (split, d) -> {
            d.flareSound = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("FancyCollision", (split, d) -> {
            d.fancyCollision = Boolean.parseBoolean(split[1]);
        });
        parsers.put("AddCollisionMesh", (split, d) -> {
            CollisionShapeBox box = new CollisionShapeBox(new Vector3f(split[1], d.shortName), new Vector3f(split[2], d.shortName), new Vector3f(split[3], d.shortName), new Vector3f(split[4], d.shortName), new Vector3f(split[5], d.shortName), new Vector3f(split[6], d.shortName), new Vector3f(split[7], d.shortName), new Vector3f(split[8], d.shortName), new Vector3f(split[9], d.shortName), new Vector3f(split[10], d.shortName), "core");
            d.collisionBox.add(box);
        });
        parsers.put("AddCollisionMeshRaw", (split, d) -> {
            Vector3f pos = new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]));
            Vector3f size = new Vector3f(Float.parseFloat(split[4]), Float.parseFloat(split[5]), Float.parseFloat(split[6]));
            Vector3f p1 = new Vector3f(Float.parseFloat(split[8]), Float.parseFloat(split[9]), Float.parseFloat(split[10]));
            Vector3f p2 = new Vector3f(Float.parseFloat(split[11]), Float.parseFloat(split[12]), Float.parseFloat(split[13]));
            Vector3f p3 = new Vector3f(Float.parseFloat(split[14]), Float.parseFloat(split[15]), Float.parseFloat(split[16]));
            Vector3f p4 = new Vector3f(Float.parseFloat(split[17]), Float.parseFloat(split[18]), Float.parseFloat(split[19]));
            Vector3f p5 = new Vector3f(Float.parseFloat(split[20]), Float.parseFloat(split[21]), Float.parseFloat(split[22]));
            Vector3f p6 = new Vector3f(Float.parseFloat(split[23]), Float.parseFloat(split[24]), Float.parseFloat(split[25]));
            Vector3f p7 = new Vector3f(Float.parseFloat(split[26]), Float.parseFloat(split[27]), Float.parseFloat(split[28]));
            Vector3f p8 = new Vector3f(Float.parseFloat(split[29]), Float.parseFloat(split[30]), Float.parseFloat(split[31]));
            CollisionShapeBox box = new CollisionShapeBox(pos, size, p1, p2, p3, p4, p5, p6, p7, p8, "core");
            d.collisionBox.add(box);
        });
        parsers.put("AddTurretCollisionMesh", (split, d) -> {
            CollisionShapeBox box = new CollisionShapeBox(new Vector3f(split[1], d.shortName), new Vector3f(split[2], d.shortName), new Vector3f(split[3], d.shortName), new Vector3f(split[4], d.shortName), new Vector3f(split[5], d.shortName), new Vector3f(split[6], d.shortName), new Vector3f(split[7], d.shortName), new Vector3f(split[8], d.shortName), new Vector3f(split[9], d.shortName), new Vector3f(split[10], d.shortName), "core");
            d.collisionBox.add(box);
        });
        parsers.put("AddTurretCollisionMeshRaw", (split, d) -> {
            Vector3f pos = new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]));
            Vector3f size = new Vector3f(Float.parseFloat(split[4]), Float.parseFloat(split[5]), Float.parseFloat(split[6]));
            Vector3f p1 = new Vector3f(Float.parseFloat(split[8]), Float.parseFloat(split[9]), Float.parseFloat(split[10]));
            Vector3f p2 = new Vector3f(Float.parseFloat(split[11]), Float.parseFloat(split[12]), Float.parseFloat(split[13]));
            Vector3f p3 = new Vector3f(Float.parseFloat(split[14]), Float.parseFloat(split[15]), Float.parseFloat(split[16]));
            Vector3f p4 = new Vector3f(Float.parseFloat(split[17]), Float.parseFloat(split[18]), Float.parseFloat(split[19]));
            Vector3f p5 = new Vector3f(Float.parseFloat(split[20]), Float.parseFloat(split[21]), Float.parseFloat(split[22]));
            Vector3f p6 = new Vector3f(Float.parseFloat(split[23]), Float.parseFloat(split[24]), Float.parseFloat(split[25]));
            Vector3f p7 = new Vector3f(Float.parseFloat(split[26]), Float.parseFloat(split[27]), Float.parseFloat(split[28]));
            Vector3f p8 = new Vector3f(Float.parseFloat(split[29]), Float.parseFloat(split[30]), Float.parseFloat(split[31]));
            CollisionShapeBox box = new CollisionShapeBox(pos, size, p1, p2, p3, p4, p5, p6, p7, p8, "turret");
            d.collisionBox.add(box);
        });
        parsers.put("LeftLinkPoint", (split, d) -> d.leftTrackPoints.add(new Vector3f(split[1], d.shortName)));
        parsers.put("RightLinkPoint", (split, d) -> d.rightTrackPoints.add(new Vector3f(split[1], d.shortName)));
        parsers.put("TrackLinkLength", (split, d) -> {
            d.trackLinkLength = Float.parseFloat(split[1]);
        });
        parsers.put("RadarDetectableAltitude", (split, d) -> {
            d.radarDetectableAltitude = Integer.parseInt(split[1]);
        });
        parsers.put("Stealth", (split, d) -> {
            d.stealth = split[1].equals("True");
        });
    }

    public class ParticleEmitter {
        public EnumParticleTypes effectType;
        public int emitRate;
        public Vector3f origin;
        public Vector3f extents;
        public Vector3f velocity;
        public float minThrottle;
        public float maxThrottle;
        public String part;
        public float minHealth;
        public float maxHealth;
    }

    public static class ShootParticle {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        String name;

        public ShootParticle(String s, float x1, float y1, float z1) {
            this.x = x1;
            this.y = y1;
            this.z = z1;
            this.name = s;
        }
    }
}

