/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables.mechas;

import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.CollisionBox;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.paintjob.IPaintableItem;
import com.flansmod.common.paintjob.PaintableType;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.types.EnumType;
import com.flansmod.common.types.InfoType;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ItemMecha
extends Item
implements IPaintableItem {
    public MechaType type;

    public ItemMecha(MechaType type1) {
        this.field_77777_bU = 1;
        this.type = type1;
        this.type.item = this;
        this.setRegistryName(this.type.shortName);
        this.func_77637_a(FlansMod.tabFlanMechas);
    }

    public void func_77624_a(ItemStack stack, World world, List<String> lines, ITooltipFlag b) {
        NBTTagCompound tags;
        String engineName;
        PartType part;
        if (this.type.description != null) {
            Collections.addAll(lines, this.type.description.split("_"));
        }
        if ((part = PartType.getPart(engineName = (tags = this.getTagCompound(stack, world)).func_74779_i("Engine"))) != null) {
            lines.add(part.name);
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    private NBTTagCompound getTagCompound(ItemStack stack, World world) {
        if (stack.func_77978_p() == null && stack.func_77978_p() == null) {
            NBTTagCompound tags = new NBTTagCompound();
            stack.func_77982_d(tags);
            tags.func_74778_a("Type", this.type.shortName);
            tags.func_74778_a("Engine", PartType.defaultEngines.get((Object)((Object)EnumType.mecha)).shortName);
        }
        return stack.func_77978_p();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityplayer, EnumHand hand) {
        Vec3d lookVec;
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        float cosYaw = MathHelper.func_76134_b((float)(-entityplayer.field_70177_z * 0.01745329f - 3.141593f));
        float sinYaw = MathHelper.func_76126_a((float)(-entityplayer.field_70177_z * 0.01745329f - 3.141593f));
        float cosPitch = -MathHelper.func_76134_b((float)(-entityplayer.field_70125_A * 0.01745329f));
        float sinPitch = MathHelper.func_76126_a((float)(-entityplayer.field_70125_A * 0.01745329f));
        double length = 5.0;
        Vec3d posVec = new Vec3d(entityplayer.field_70165_t, entityplayer.field_70163_u + 1.62 - entityplayer.func_70033_W(), entityplayer.field_70161_v);
        RayTraceResult RayTraceResult2 = world.func_72901_a(posVec, lookVec = posVec.func_72441_c((double)(sinYaw * cosPitch) * length, (double)sinPitch * length, (double)(cosYaw * cosPitch) * length), true);
        if (RayTraceResult2 == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        if (RayTraceResult2.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = RayTraceResult2.func_178782_a();
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityMecha(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5 + (double)this.type.yOffset, (double)pos.func_177952_p() + 0.5, entityplayer, this.type, this.getData(itemstack, world), this.getTagCompound(itemstack, world)));
            }
            if (!entityplayer.field_71075_bZ.field_75098_d) {
                itemstack.func_190920_e(itemstack.func_190916_E() - 1);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    public DriveableData getData(ItemStack itemstack, World world) {
        return new DriveableData(this.getTagCompound(itemstack, world), itemstack.func_77952_i());
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab != FlansMod.tabFlanMechas && tab != CreativeTabs.field_78027_g) {
            return;
        }
        ItemStack mechaStack = new ItemStack((Item)this, 1, 0);
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("Type", this.type.shortName);
        if (PartType.defaultEngines.containsKey((Object)EnumType.mecha)) {
            tags.func_74778_a("Engine", PartType.defaultEngines.get((Object)((Object)EnumType.mecha)).shortName);
        }
        for (EnumDriveablePart part : EnumDriveablePart.values()) {
            tags.func_74768_a(part.getShortName() + "_Health", this.type.health.get((Object)part) == null ? 0 : ((CollisionBox)this.type.health.get((Object)((Object)part))).health);
            tags.func_74757_a(part.getShortName() + "_Fire", false);
        }
        mechaStack.func_77982_d(tags);
        items.add((Object)mechaStack);
    }

    @Override
    public InfoType getInfoType() {
        return this.type;
    }

    @Override
    public PaintableType GetPaintableType() {
        return this.type;
    }
}

