/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.enchantments;

import com.flansmod.common.FlansMod;
import com.flansmod.common.enchantments.EnchantmentDuelist;
import com.flansmod.common.enchantments.EnchantmentJuggernaut;
import com.flansmod.common.enchantments.EnchantmentLumberjack;
import com.flansmod.common.enchantments.EnchantmentNimble;
import com.flansmod.common.enchantments.EnchantmentSharpshooter;
import com.flansmod.common.enchantments.EnchantmentSteady;
import com.flansmod.common.enchantments.ItemGlove;
import com.flansmod.common.guns.FireableGun;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EnchantmentModule {
    public static final EnumEnchantmentType SHIELDS = EnumHelper.addEnchantmentType((String)"shields", item -> item instanceof ItemShield);
    public static final EnumEnchantmentType GLOVES = EnumHelper.addEnchantmentType((String)"gloves", item -> item instanceof ItemGlove);
    public static final EnumEnchantmentType OFF_HAND = EnumHelper.addEnchantmentType((String)"offHand", item -> item instanceof ItemGlove || item instanceof ItemShield);
    public static Enchantment STEADY_ENCHANT;
    public static Enchantment NIMBLE_ENCHANT;
    public static Enchantment LUMBERJACK_ENCHANT;
    public static Enchantment DUELIST_ENCHANT;
    public static Enchantment SHARPSHOOTER_ENCHANT;
    public static Enchantment JUGGERNAUT_ENCHANT;

    public void PreInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        STEADY_ENCHANT = ((Enchantment)new EnchantmentSteady().setRegistryName("enchantment_steady")).func_77322_b("enchantment_steady");
        NIMBLE_ENCHANT = ((Enchantment)new EnchantmentNimble().setRegistryName("enchantment_nimble")).func_77322_b("enchantment_nimble");
        LUMBERJACK_ENCHANT = ((Enchantment)new EnchantmentLumberjack().setRegistryName("enchantment_lumberjack")).func_77322_b("enchantment_lumberjack");
        DUELIST_ENCHANT = ((Enchantment)new EnchantmentDuelist().setRegistryName("enchantment_duelist")).func_77322_b("enchantment_duelist");
        SHARPSHOOTER_ENCHANT = ((Enchantment)new EnchantmentSharpshooter().setRegistryName("enchantment_sharpshooter")).func_77322_b("enchantment_sharpshooter");
        JUGGERNAUT_ENCHANT = ((Enchantment)new EnchantmentJuggernaut().setRegistryName("enchantment_juggernaut")).func_77322_b("enchantment_juggernaut");
    }

    public void Init() {
    }

    public void PostInit() {
    }

    @SubscribeEvent
    public void RegisterEnchants(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().register((IForgeRegistryEntry)STEADY_ENCHANT);
        event.getRegistry().register((IForgeRegistryEntry)NIMBLE_ENCHANT);
        event.getRegistry().register((IForgeRegistryEntry)LUMBERJACK_ENCHANT);
        event.getRegistry().register((IForgeRegistryEntry)DUELIST_ENCHANT);
        event.getRegistry().register((IForgeRegistryEntry)SHARPSHOOTER_ENCHANT);
        event.getRegistry().register((IForgeRegistryEntry)JUGGERNAUT_ENCHANT);
    }

    @SubscribeEvent
    public void AttackEvent(LivingHurtEvent event) {
        Entity trueSource = event.getSource().func_76346_g();
        if (trueSource != null && trueSource instanceof EntityLivingBase) {
            int i;
            EntityLivingBase attacker = (EntityLivingBase)trueSource;
            ItemStack weaponStack = attacker.func_184614_ca();
            ItemStack offHandStack = attacker.func_184592_cb();
            if (weaponStack.func_77973_b() instanceof ItemAxe) {
                int lumberjackLevel = EnchantmentHelper.func_77506_a((Enchantment)LUMBERJACK_ENCHANT, (ItemStack)offHandStack);
                for (i = 0; i < lumberjackLevel; ++i) {
                    event.setAmount(event.getAmount() * 1.1f);
                }
                if (lumberjackLevel > 0) {
                    offHandStack.func_77972_a(1, attacker);
                }
            }
            if (weaponStack.func_77973_b() instanceof ItemSword) {
                int duelistLevel = EnchantmentHelper.func_77506_a((Enchantment)DUELIST_ENCHANT, (ItemStack)offHandStack);
                for (i = 0; i < duelistLevel; ++i) {
                    event.setAmount(event.getAmount() * 1.1f);
                }
                if (duelistLevel > 0) {
                    offHandStack.func_77972_a(1, attacker);
                }
            }
            int juggernautLevel = 0;
            for (ItemStack armour : event.getEntityLiving().func_184193_aE()) {
                juggernautLevel += EnchantmentHelper.func_77506_a((Enchantment)JUGGERNAUT_ENCHANT, (ItemStack)armour);
            }
            if (juggernautLevel > 0) {
                float minPercent = 0.25f;
                float exponent = (float)Math.log(0.25) / 4.0f;
                float maxDamageAsPercentOfHP = (float)Math.exp(exponent * (float)juggernautLevel);
                float maxHP = event.getEntityLiving().func_110138_aP() + (float)event.getEntityLiving().func_70658_aO();
                if (event.getAmount() > maxHP * maxDamageAsPercentOfHP) {
                    float absorbedDmg = event.getAmount() - maxHP * maxDamageAsPercentOfHP;
                    if (absorbedDmg > 256.0f) {
                        absorbedDmg = 256.0f;
                    }
                    for (ItemStack armour : event.getEntityLiving().func_184193_aE()) {
                        if (EnchantmentHelper.func_77506_a((Enchantment)JUGGERNAUT_ENCHANT, (ItemStack)armour) <= 0) continue;
                        armour.func_77972_a(MathHelper.func_76141_d((float)absorbedDmg), event.getEntityLiving());
                    }
                    FlansMod.log.info("Juggernaut applied to incoming damage of " + event.getAmount() + " over the threshold of " + maxHP * maxDamageAsPercentOfHP);
                    event.setAmount(maxHP * maxDamageAsPercentOfHP);
                }
            }
        }
    }

    public static void ModifyGun(FireableGun fireableGun, EntityLivingBase entity, ItemStack otherHand) {
        if (!FlansMod.enchantmentModuleEnabled) {
            return;
        }
        int steadyLevel = EnchantmentHelper.func_77506_a((Enchantment)STEADY_ENCHANT, (ItemStack)otherHand);
        for (int i = 0; i < steadyLevel; ++i) {
            fireableGun.MultiplySpread(0.75f);
        }
        int sharpshooterLevel = EnchantmentHelper.func_77506_a((Enchantment)SHARPSHOOTER_ENCHANT, (ItemStack)otherHand);
        for (int i = 0; i < sharpshooterLevel; ++i) {
            fireableGun.MultiplyDamage(1.1f);
        }
        if (steadyLevel > 0 || sharpshooterLevel > 0) {
            otherHand.func_77972_a(1, entity);
        }
    }

    public static float ModifyReloadTime(float reloadTime, EntityLivingBase entity, ItemStack otherHand) {
        if (!FlansMod.enchantmentModuleEnabled) {
            return reloadTime;
        }
        int nimbleLevel = EnchantmentHelper.func_77506_a((Enchantment)NIMBLE_ENCHANT, (ItemStack)otherHand);
        for (int i = 0; i < nimbleLevel; ++i) {
            reloadTime *= 0.85f;
        }
        if (nimbleLevel > 0) {
            otherHand.func_77972_a(1, entity);
        }
        return reloadTime;
    }
}

