/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.client.model.ModelAAGun;
import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AAGunType
extends InfoType {
    public List<BulletType> ammo = new ArrayList<BulletType>();
    public int reloadTime;
    public int recoil = 5;
    public int accuracy;
    public int damage;
    public int shootDelay;
    public int numBarrels;
    public boolean fireAlternately;
    public int health;
    public int gunnerX;
    public int gunnerY;
    public int gunnerZ;
    public String shootSound;
    public String reloadSound;
    public ModelAAGun model;
    public float topViewLimit = 75.0f;
    public float bottomViewLimit = 0.0f;
    public int[] barrelX;
    public int[] barrelY;
    public int[] barrelZ;
    public boolean targetMobs = false;
    public boolean targetPlayers = false;
    public boolean targetVehicles = false;
    public boolean targetPlanes = false;
    public boolean targetMechas = false;
    public float targetRange = 10.0f;
    public boolean shareAmmo = false;
    public static List<AAGunType> infoTypes = new ArrayList<AAGunType>();

    public AAGunType(TypeFile file) {
        super(file);
        infoTypes.add(this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            BulletType type;
            if (FMLCommonHandler.instance().getSide().isClient() && split[0].equals("Model")) {
                this.model = FlansMod.proxy.loadModel(split[1], this.shortName, ModelAAGun.class);
            }
            this.damage = this.Read(split, "Damage", this.damage);
            this.reloadTime = this.Read(split, "ReloadTime", this.reloadTime);
            this.recoil = this.Read(split, "Recoil", this.recoil);
            this.accuracy = this.Read(split, "Accuracy", this.accuracy);
            this.shootDelay = this.Read(split, "ShootDelay", this.shootDelay);
            this.fireAlternately = this.Read(split, "FireAlternately", this.fireAlternately);
            this.health = this.Read(split, "Health", this.health);
            this.topViewLimit = this.Read(split, "TopViewLimit", this.topViewLimit);
            this.bottomViewLimit = this.Read(split, "BottomViewLimit", this.bottomViewLimit);
            this.targetMobs = this.Read(split, "TargetMobs", this.targetMobs);
            this.targetPlayers = this.Read(split, "TargetPlayers", this.targetPlayers);
            this.targetVehicles = this.Read(split, "TargetVehicles", this.targetVehicles);
            this.targetPlanes = this.Read(split, "TargetPlanes", this.targetPlanes);
            this.targetMechas = this.Read(split, "TargetMechas", this.targetMechas);
            this.shareAmmo = this.Read(split, "ShareAmmo", this.shareAmmo);
            this.targetRange = this.Read(split, "TargetRange", this.targetRange);
            this.bottomViewLimit = this.Read(split, "BottomViewLimit", this.bottomViewLimit);
            if (split[0].equals("TargetDriveables")) {
                this.targetPlanes = this.targetVehicles = Boolean.parseBoolean(split[1]);
                this.targetMechas = this.targetVehicles;
            }
            if (split[0].equals("ShootSound")) {
                this.shootSound = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "aaguns", split[1]);
            }
            if (split[0].equals("ReloadSound")) {
                this.reloadSound = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "aaguns", split[1]);
            }
            if (split[0].equals("NumBarrels")) {
                this.numBarrels = Integer.parseInt(split[1]);
                this.barrelX = new int[this.numBarrels];
                this.barrelY = new int[this.numBarrels];
                this.barrelZ = new int[this.numBarrels];
            }
            if (split[0].equals("Barrel")) {
                int id = Integer.parseInt(split[1]);
                this.barrelX[id] = Integer.parseInt(split[2]);
                this.barrelY[id] = Integer.parseInt(split[3]);
                this.barrelZ[id] = Integer.parseInt(split[4]);
            }
            if (split[0].equals("Health")) {
                this.health = Integer.parseInt(split[1]);
            }
            if (split[0].equals("Ammo") && (type = BulletType.getBullet(split[1])) != null) {
                this.ammo.add(type);
            }
            if (split[0].equals("GunnerPos")) {
                this.gunnerX = Integer.parseInt(split[1]);
                this.gunnerY = Integer.parseInt(split[2]);
                this.gunnerZ = Integer.parseInt(split[3]);
            }
        }
        catch (Exception e) {
            FlansMod.log.error("" + e);
        }
    }

    public boolean isAmmo(BulletType type) {
        return this.ammo.contains(type);
    }

    public boolean isAmmo(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b() instanceof ItemBullet && this.isAmmo(((ItemBullet)stack.func_77973_b()).type);
    }

    public static AAGunType getAAGun(String s) {
        for (AAGunType gun : infoTypes) {
            if (!gun.shortName.equals(s)) continue;
            return gun;
        }
        return null;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelAAGun.class);
    }

    @Override
    public void addLoot(LootTableLoadEvent event) {
    }

    @Override
    protected void preRead(TypeFile file) {
    }

    @Override
    protected void postRead(TypeFile file) {
        if (this.numBarrels > 16) {
            FlansMod.log.warn("Detected AA Gun type with ludicrous number of barrels " + this.numBarrels);
            this.numBarrels = 16;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return this.model;
    }
}

