/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.handlers.FlansModResourceHandler;
import com.flansmod.common.FlansMod;
import com.flansmod.common.FlansModExplosion;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.guns.EntityDamageSourceFlan;
import com.flansmod.common.guns.EntityShootable;
import com.flansmod.common.guns.GrenadeType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.network.PacketFlak;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.teams.ItemTeamArmour;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.util.BlockUtil;
import com.flansmod.common.vector.Vector3f;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityGrenade
extends EntityShootable
implements IEntityAdditionalSpawnData {
    public GrenadeType type;
    private Optional<EntityPlayer> player = Optional.empty();
    private Optional<Entity> thrower = Optional.empty();
    public Team teamOfThrower;
    public RotatedAxes axes = new RotatedAxes();
    public Vector3f angularVelocity = new Vector3f(0.0f, 0.0f, 0.0f);
    public float prevRotationRoll = 0.0f;
    public int smokeTime = 0;
    public boolean smoking = false;
    public boolean stuck = false;
    public int stuckToX;
    public int stuckToY;
    public int stuckToZ;
    public boolean detonated = false;
    public int numUsesRemaining = 0;

    public EntityGrenade(World w) {
        super(w);
    }

    public EntityGrenade(World w, Vector3f pos, GrenadeType g, float rotationPitch, float rotationYaw) {
        this(w);
        this.func_70107_b(pos.getX(), pos.getY(), pos.getZ());
        this.type = g;
        this.numUsesRemaining = this.type.numUses;
        this.func_70105_a(g.hitBoxSize, g.hitBoxSize);
        this.axes.setAngles(rotationYaw + 90.0f, g.spinWhenThrown ? rotationPitch : 0.0f, 0.0f);
        this.field_70126_B = g.spinWhenThrown ? rotationYaw + 90.0f : 0.0f;
        this.field_70177_z = this.field_70126_B;
        this.field_70125_A = this.field_70127_C = rotationPitch;
        float speed = 0.5f * this.type.throwSpeed;
        this.field_70159_w = this.axes.getXAxis().x * speed;
        this.field_70181_x = this.axes.getXAxis().y * speed;
        this.field_70179_y = this.axes.getXAxis().z * speed;
        if (this.type.spinWhenThrown) {
            this.angularVelocity = new Vector3f(0.0f, 0.0f, 10.0f);
        }
        if (this.type.throwSound != null) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, this.type.throwSound, true);
        }
    }

    public EntityGrenade(EntityLivingBase entity, GrenadeType g) {
        this(entity.field_70170_p, new Vector3f(entity.func_174791_d().func_178787_e(new Vec3d(0.0, (double)entity.func_70047_e(), 0.0))), g, entity.field_70125_A, entity.field_70177_z);
        this.thrower = Optional.of(entity);
    }

    public EntityGrenade(EntityPlayer player, GrenadeType g) {
        this((EntityLivingBase)player, g);
        this.player = Optional.of(player);
    }

    public EntityGrenade(World w, Vector3f pos, GrenadeType g, float rotationPitch, float rotationYaw, Optional<EntityPlayer> player, Optional<Entity> entity) {
        this(w, pos, g, rotationPitch, rotationYaw);
        this.thrower = entity;
        this.player = player;
    }

    public void func_70071_h_() {
        List list;
        super.func_70071_h_();
        if (this.type == null || this.type.despawnTime > 0 && this.field_70173_aa > this.type.despawnTime) {
            this.detonated = true;
            this.func_70106_y();
            return;
        }
        if (this.field_70170_p.field_72995_K && this.type.trailParticles) {
            double dX = (this.field_70165_t - this.field_70169_q) / 10.0;
            double dY = (this.field_70163_u - this.field_70167_r) / 10.0;
            double dZ = (this.field_70161_v - this.field_70166_s) / 10.0;
            for (int i = 0; i < 10; ++i) {
                Particle particle = FlansModClient.getParticle(this.type.trailParticleType, this.field_70170_p, this.field_70169_q + dX * (double)i, this.field_70167_r + dY * (double)i, this.field_70166_s + dZ * (double)i);
            }
        }
        if (this.smoking) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketFlak(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50, this.type.smokeParticleType), this.field_70165_t, this.field_70163_u, this.field_70161_v, 30.0f, this.field_71093_bK);
            List list2 = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72321_a((double)this.type.smokeRadius, (double)this.type.smokeRadius, (double)this.type.smokeRadius));
            for (Object obj : list2) {
                EntityLivingBase entity = (EntityLivingBase)obj;
                if (!(entity.func_70068_e((Entity)this) < (double)(this.type.smokeRadius * this.type.smokeRadius))) continue;
                boolean smokeThem = true;
                for (int i = 0; i < EntityEquipmentSlot.values().length; ++i) {
                    ItemStack stack = entity.func_184582_a(EntityEquipmentSlot.values()[i]);
                    if (stack == null || !(stack.func_77973_b() instanceof ItemTeamArmour) || !((ItemTeamArmour)stack.func_77973_b()).type.smokeProtection) continue;
                    smokeThem = false;
                }
                if (!smokeThem) continue;
                for (PotionEffect effect : this.type.smokeEffects) {
                    entity.func_70690_d(new PotionEffect(effect));
                }
            }
            --this.smokeTime;
            if (this.smokeTime == 0) {
                this.func_70106_y();
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa > this.type.fuse && this.type.fuse > 0) {
                this.detonate();
            }
            if (this.type.livingProximityTrigger > 0.0f || this.type.driveableProximityTrigger > 0.0f) {
                float checkRadius = Math.max(this.type.livingProximityTrigger, this.type.driveableProximityTrigger);
                list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)checkRadius, (double)checkRadius, (double)checkRadius));
                for (Object obj : list) {
                    if (obj == this.thrower && this.field_70173_aa < 10) continue;
                    if (obj instanceof EntityLivingBase && this.func_70068_e((Entity)obj) < (double)(this.type.livingProximityTrigger * this.type.livingProximityTrigger)) {
                        if (TeamsManager.getInstance() != null && TeamsManager.getInstance().currentRound != null && obj instanceof EntityPlayerMP && this.player.isPresent() && !TeamsManager.getInstance().currentRound.gametype.playerAttacked((EntityPlayerMP)obj, (DamageSource)new EntityDamageSourceFlan(this.type.shortName, this, this.player.get(), this.type))) continue;
                        if (this.type.damageToTriggerer > 0.0f) {
                            ((EntityLivingBase)obj).func_70097_a(this.getGrenadeDamage(), this.type.damageToTriggerer);
                        }
                        this.detonate();
                        break;
                    }
                    if (!(obj instanceof EntityDriveable) || !(this.func_70068_e((Entity)obj) < (double)(this.type.driveableProximityTrigger * this.type.driveableProximityTrigger))) continue;
                    if (this.type.damageToTriggerer > 0.0f) {
                        ((EntityDriveable)obj).func_70097_a(this.getGrenadeDamage(), this.type.damageToTriggerer);
                    }
                    this.detonate();
                    break;
                }
            }
        }
        if (this.stuck && this.field_70170_p.func_175623_d(new BlockPos(this.stuckToX, this.stuckToY, this.stuckToZ))) {
            this.stuck = false;
        }
        if (!this.stuck && !this.type.stickToThrower) {
            this.field_70126_B = this.axes.getYaw();
            this.field_70127_C = this.axes.getPitch();
            this.prevRotationRoll = this.axes.getRoll();
            if (this.angularVelocity.lengthSquared() > 1.0E-8f) {
                this.axes.rotateLocal(this.angularVelocity.length(), this.angularVelocity.normalise(null));
            }
            Vector3f posVec = new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vector3f motVec = new Vector3f(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            Vector3f nextPosVec = Vector3f.add(posVec, motVec, null);
            RayTraceResult hit = this.field_70170_p.func_72933_a(posVec.toVec3(), nextPosVec.toVec3());
            if (hit != null && hit.field_72313_a == RayTraceResult.Type.BLOCK) {
                Material mat = this.field_70170_p.func_180495_p(hit.func_178782_a()).func_185904_a();
                if (this.type.explodeOnImpact) {
                    this.detonate();
                } else if (this.type.breaksGlass && mat == Material.field_151592_s && TeamsManager.canBreakGlass) {
                    if (!this.field_70170_p.field_72995_K) {
                        WorldServer worldServer = (WorldServer)this.field_70170_p;
                        BlockUtil.destroyBlock(worldServer, hit.func_178782_a(), this.player.orElse(null), false);
                    }
                } else if (!this.type.penetratesBlocks) {
                    Vector3f hitVec = new Vector3f(hit.field_72307_f);
                    Vector3f preHitMotVec = Vector3f.sub(hitVec, posVec, null);
                    Vector3f postHitMotVec = Vector3f.sub(motVec, preHitMotVec, null);
                    EnumFacing sideHit = hit.field_178784_b;
                    switch (sideHit) {
                        case UP: 
                        case DOWN: {
                            postHitMotVec.setY(-postHitMotVec.getY());
                            break;
                        }
                        case EAST: 
                        case WEST: {
                            postHitMotVec.setX(-postHitMotVec.getX());
                            break;
                        }
                        case NORTH: 
                        case SOUTH: {
                            postHitMotVec.setZ(-postHitMotVec.getZ());
                        }
                    }
                    float lambda = Math.abs(motVec.lengthSquared()) < 1.0E-8f ? 1.0f : postHitMotVec.length() / motVec.length();
                    postHitMotVec.scale(this.type.bounciness / 2.0f);
                    this.field_70165_t += (double)(preHitMotVec.x + postHitMotVec.x);
                    this.field_70163_u += (double)(preHitMotVec.y + postHitMotVec.y);
                    this.field_70161_v += (double)(preHitMotVec.z + postHitMotVec.z);
                    this.field_70159_w = postHitMotVec.x / lambda;
                    this.field_70181_x = postHitMotVec.y / lambda;
                    this.field_70179_y = postHitMotVec.z / lambda;
                    motVec = new Vector3f(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    float randomSpinner = 90.0f;
                    Vector3f.add(this.angularVelocity, new Vector3f(this.field_70146_Z.nextGaussian() * (double)randomSpinner, this.field_70146_Z.nextGaussian() * (double)randomSpinner, this.field_70146_Z.nextGaussian() * (double)randomSpinner), this.angularVelocity);
                    this.angularVelocity.scale(motVec.lengthSquared());
                    if ((double)motVec.lengthSquared() > 0.01) {
                        this.func_184185_a(FlansModResourceHandler.getSoundEvent(this.type.bounceSound), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    }
                    if (this.type.sticky) {
                        this.field_70165_t = hitVec.x;
                        this.field_70163_u = hitVec.y;
                        this.field_70161_v = hitVec.z;
                        this.field_70179_y = 0.0;
                        this.field_70181_x = 0.0;
                        this.field_70159_w = 0.0;
                        this.angularVelocity.set(0.0f, 0.0f, 0.0f);
                        float yaw = this.axes.getYaw();
                        switch (hit.field_178784_b) {
                            case DOWN: {
                                this.axes.setAngles(yaw, 180.0f, 0.0f);
                                break;
                            }
                            case UP: {
                                this.axes.setAngles(yaw, 0.0f, 0.0f);
                                break;
                            }
                            case NORTH: {
                                this.axes.setAngles(270.0f, 90.0f, 0.0f);
                                this.axes.rotateLocalYaw(yaw);
                                break;
                            }
                            case SOUTH: {
                                this.axes.setAngles(90.0f, 90.0f, 0.0f);
                                this.axes.rotateLocalYaw(yaw);
                                break;
                            }
                            case WEST: {
                                this.axes.setAngles(180.0f, 90.0f, 0.0f);
                                this.axes.rotateLocalYaw(yaw);
                                break;
                            }
                            case EAST: {
                                this.axes.setAngles(0.0f, 90.0f, 0.0f);
                                this.axes.rotateLocalYaw(yaw);
                            }
                        }
                        this.stuck = true;
                        this.stuckToX = hit.func_178782_a().func_177958_n();
                        this.stuckToY = hit.func_178782_a().func_177956_o();
                        this.stuckToZ = hit.func_178782_a().func_177952_p();
                    }
                }
            } else {
                this.field_70165_t += this.field_70159_w;
                this.field_70163_u += this.field_70181_x;
                this.field_70161_v += this.field_70179_y;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (this.type.stickToThrower) {
            if (!this.thrower.isPresent() || this.thrower.get().field_70128_L || !(this.thrower.get() instanceof EntityLivingBase)) {
                this.func_70106_y();
            } else {
                EntityLivingBase entity = (EntityLivingBase)this.thrower.get();
                this.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            }
        }
        if (this.type.damageVsLiving > 0.0f && !this.stuck) {
            Vector3f motVec = new Vector3f(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
            for (Object obj : list) {
                if (obj == this.thrower && this.field_70173_aa < 10 || (double)motVec.lengthSquared() < 0.01 || !(obj instanceof EntityLivingBase)) continue;
                ((EntityLivingBase)obj).func_70097_a(this.getGrenadeDamage(), this.type.damageVsLiving * motVec.lengthSquared() * 3.0f);
            }
        }
        this.field_70181_x -= 0.024525 * (double)this.type.fallSpeed;
        if (this.field_70170_p.field_72995_K) {
            this.func_70066_B();
        }
    }

    public boolean func_70097_a(DamageSource source, float f) {
        if (this.type.detonateWhenShot) {
            this.detonate();
        }
        return this.type.detonateWhenShot;
    }

    public void detonate() {
        if (this.field_70173_aa < this.type.primeDelay) {
            return;
        }
        if (this.detonated) {
            return;
        }
        this.detonated = true;
        PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, this.type.detonateSound, true);
        if (!this.field_70170_p.field_72995_K && this.type.explosionRadius > 0.1f) {
            new FlansModExplosion(this.field_70170_p, this, this.player, this.type, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.type.explosionRadius, this.type.fireRadius > 0.0f, this.type.smokeRadius > 0.0f, this.type.explosionBreaksBlocks);
        }
        if (this.type.fireRadius > 0.1f) {
            for (float i = -this.type.fireRadius; i < this.type.fireRadius; i += 1.0f) {
                for (float j = -this.type.fireRadius; j < this.type.fireRadius; j += 1.0f) {
                    for (float k = -this.type.fireRadius; k < this.type.fireRadius; k += 1.0f) {
                        int x = MathHelper.func_76128_c((double)((double)i + this.field_70165_t));
                        int y = MathHelper.func_76128_c((double)((double)j + this.field_70163_u));
                        int z = MathHelper.func_76128_c((double)((double)k + this.field_70161_v));
                        if (!(i * i + j * j + k * k <= this.type.fireRadius * this.type.fireRadius) || this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != Blocks.field_150350_a || !this.field_70146_Z.nextBoolean()) continue;
                        this.field_70170_p.func_180501_a(new BlockPos(x, y, z), Blocks.field_150480_ab.func_176223_P(), 2);
                        this.field_70170_p.func_175684_a(new BlockPos(x, y, z), (Block)Blocks.field_150480_ab, 0);
                    }
                }
            }
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.type.explodeParticles; ++i) {
                this.field_70170_p.func_175688_a(FlansModClient.getParticleType(this.type.explodeParticleType), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextGaussian(), this.field_70146_Z.nextGaussian(), this.field_70146_Z.nextGaussian(), new int[0]);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.type.dropItemOnDetonate != null) {
            ItemStack dropStack = InfoType.getRecipeElement(this.type.dropItemOnDetonate);
            this.func_70099_a(dropStack, 1.0f);
        }
        if (this.type.smokeTime > 0) {
            this.smoking = true;
            this.smokeTime = this.type.smokeTime;
        } else {
            this.func_70106_y();
        }
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int i, boolean b) {
    }

    private DamageSource getGrenadeDamage() {
        if (this.player.isPresent()) {
            return new EntityDamageSourceFlan(this.type.shortName, this, this.player.get(), this.type).func_76349_b();
        }
        return new EntityDamageSource(this.type.shortName, (Entity)this).func_76349_b();
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tags) {
        this.type = GrenadeType.getGrenade(tags.func_74779_i("Type"));
        this.player = Optional.ofNullable(this.field_70170_p.func_72924_a(tags.func_74779_i("Player")));
        this.field_70177_z = tags.func_74760_g("RotationYaw");
        this.field_70125_A = tags.func_74760_g("RotationPitch");
        this.axes.setAngles(this.field_70177_z, this.field_70125_A, 0.0f);
    }

    protected void func_70014_b(NBTTagCompound tags) {
        if (this.type == null) {
            this.func_70106_y();
        } else {
            tags.func_74778_a("Type", this.type.shortName);
            if (this.player.isPresent()) {
                tags.func_74778_a("Player", this.player.get().func_70005_c_());
            }
            tags.func_74776_a("RotationYaw", this.axes.getYaw());
            tags.func_74776_a("RotationPitch", this.axes.getPitch());
        }
    }

    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.type.shortName);
        data.writeInt(this.player.isPresent() ? this.player.get().func_145782_y() : -1);
        data.writeInt(this.thrower.isPresent() ? this.thrower.get().func_145782_y() : -1);
        data.writeFloat(this.axes.getYaw());
        data.writeFloat(this.axes.getPitch());
    }

    public void readSpawnData(ByteBuf data) {
        this.type = GrenadeType.getGrenade(ByteBufUtils.readUTF8String((ByteBuf)data));
        Entity ent = this.field_70170_p.func_73045_a(data.readInt());
        this.player = ent instanceof EntityPlayer ? Optional.of((EntityPlayer)ent) : Optional.empty();
        this.thrower = Optional.ofNullable(this.field_70170_p.func_73045_a(data.readInt()));
        this.func_70101_b(data.readFloat(), data.readFloat());
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.axes.setAngles(this.field_70177_z, this.field_70125_A, 0.0f);
        if (this.type.spinWhenThrown) {
            this.angularVelocity = new Vector3f(0.0f, 0.0f, 10.0f);
        }
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L && this.type.isDeployableBag;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.type.isDeployableBag && !this.field_70170_p.field_72995_K) {
            boolean used = false;
            if (this.type.healAmount > 0.0f && player.func_110143_aJ() < player.func_110138_aP()) {
                player.func_70691_i(this.type.healAmount);
                FlansMod.getPacketHandler().sendToAllAround(new PacketFlak(player.field_70165_t, player.field_70163_u, player.field_70161_v, 5, "heart"), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 50.0));
                used = true;
            }
            for (PotionEffect effect : this.type.potionEffects) {
                player.func_70690_d(new PotionEffect(effect));
                used = true;
            }
            if (this.type.numClips > 0 && player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ItemGun) {
                GunType gun = ((ItemGun)player.func_184614_ca().func_77973_b()).GetType();
                if (gun.ammo.size() > 0) {
                    ShootableType bulletToGive = gun.ammo.get(0);
                    int numToGive = Math.min(bulletToGive.maxStackSize, this.type.numClips * gun.numAmmoItemsInGun);
                    if (player.field_71071_by.func_70441_a(new ItemStack(bulletToGive.item, numToGive))) {
                        used = true;
                    }
                }
            }
            if (used) {
                --this.numUsesRemaining;
                if (this.numUsesRemaining <= 0) {
                    this.func_70106_y();
                }
            }
        }
        return true;
    }
}

