/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.EntityDamageSourceFlan;
import com.flansmod.common.guns.FireableGun;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;

public class FiredShot {
    private FireableGun weapon;
    private BulletType bullet;
    private Optional<EntityPlayerMP> player;
    private Optional<? extends Entity> shooter;

    public FiredShot(FireableGun weapon, BulletType bullet) {
        this.weapon = weapon;
        this.bullet = bullet;
        this.player = Optional.empty();
        this.shooter = this.player;
    }

    public FiredShot(FireableGun weapon, BulletType bullet, EntityPlayerMP player) {
        this(weapon, bullet, (Entity)player, player);
    }

    public FiredShot(FireableGun weapon, BulletType bullet, Entity shooter) {
        this(weapon, bullet, shooter, null);
    }

    public FiredShot(FireableGun weapon, BulletType bullet, Entity shooter, @Nullable EntityPlayerMP player) {
        this.weapon = weapon;
        this.bullet = bullet;
        this.player = Optional.ofNullable(player);
        this.shooter = Optional.of(shooter);
    }

    public FireableGun getFireableGun() {
        return this.weapon;
    }

    public BulletType getBulletType() {
        return this.bullet;
    }

    public DamageSource getDamageSource() {
        return this.getDamageSource(false);
    }

    public DamageSource getDamageSource(Boolean headshot) {
        if (this.player.isPresent()) {
            return new EntityDamageSourceFlan(this.weapon.getShortName(), (Entity)this.player.get(), (EntityPlayer)this.player.get(), this.weapon.getInfoType(), headshot).func_76349_b();
        }
        if (this.shooter.isPresent()) {
            return new EntityDamageSourceFlan(this.weapon.getShortName(), null, null, this.weapon.getInfoType(), headshot).func_76349_b();
        }
        return DamageSource.field_76377_j;
    }

    public Optional<EntityPlayerMP> getPlayerOptional() {
        return this.player;
    }

    public Optional<? extends Entity> getShooterOptional() {
        return this.shooter;
    }
}

