/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns.raytracing;

import com.flansmod.client.debug.EntityDebugDot;
import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.EntityAAGun;
import com.flansmod.common.guns.EntityGrenade;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.ShotHandler;
import com.flansmod.common.guns.raytracing.PlayerHitbox;
import com.flansmod.common.guns.raytracing.PlayerSnapshot;
import com.flansmod.common.teams.Team;
import com.flansmod.common.vector.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class FlansModRaytracer {
    public static List<BulletHit> Raytrace(World world, Entity playerToIgnore, boolean canHitSelf, Entity entityToIgnore, Vector3f origin, Vector3f motion, int pingOfShooter, Float gunPenetration) {
        List<BulletHit> hits = new ArrayList<BulletHit>();
        float speed = motion.length();
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            RayTraceResult mop;
            Entity entity;
            Entity obj = (Entity)world.field_72996_f.get(i);
            boolean shouldDoNormalHitDetect = true;
            if (obj instanceof EntityDriveable) {
                EntityDriveable driveable = (EntityDriveable)obj;
                shouldDoNormalHitDetect = false;
                if (driveable.isDead() || driveable.isPartOfThis(playerToIgnore)) continue;
                if (driveable.func_70092_e(origin.x, origin.y, origin.z) <= (double)((driveable.getDriveableType().bulletDetectionRadius + speed) * (driveable.getDriveableType().bulletDetectionRadius + speed))) {
                    ArrayList<BulletHit> driveableHits = driveable.attackFromBullet(origin, motion);
                    hits.addAll(driveableHits);
                }
            } else if (obj instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)obj;
                PlayerData data = PlayerHandler.getPlayerData(player);
                shouldDoNormalHitDetect = false;
                if (data != null) {
                    PlayerSnapshot snapshot;
                    if (player.field_70128_L || data.team == Team.spectators || player == playerToIgnore && !canHitSelf) continue;
                    int snapshotToTry = pingOfShooter / 50;
                    if (snapshotToTry >= data.snapshots.length) {
                        snapshotToTry = data.snapshots.length - 1;
                    }
                    if ((snapshot = data.snapshots[snapshotToTry]) == null) {
                        snapshot = data.snapshots[0];
                    }
                    if (snapshot == null) {
                        shouldDoNormalHitDetect = true;
                    } else {
                        Entity[] playerHits = snapshot.raytrace(origin, motion);
                        hits.addAll((Collection<BulletHit>)playerHits);
                    }
                }
            }
            if (!shouldDoNormalHitDetect || (entity = obj) == entityToIgnore || entity == playerToIgnore || entity.field_70128_L || !(entity instanceof EntityLivingBase) && !(entity instanceof EntityAAGun) && !(entity instanceof EntityGrenade) || (mop = entity.func_174813_aQ().func_72327_a(origin.toVec3(), new Vec3d((double)(origin.x + motion.x), (double)(origin.y + motion.y), (double)(origin.z + motion.z)))) == null) continue;
            Entity[] parts = entity.func_70021_al();
            boolean hit = true;
            if (parts != null) {
                hit = false;
                for (Entity part : parts) {
                    RayTraceResult result = part.func_174813_aQ().func_72327_a(origin.toVec3(), new Vec3d((double)(origin.x + motion.x), (double)(origin.y + motion.y), (double)(origin.z + motion.z)));
                    if (result == null) continue;
                    mop = result;
                    entity = part;
                    hit = true;
                    break;
                }
            }
            if (!hit) continue;
            Vec3d hitPoint = new Vec3d(mop.field_72307_f.field_72450_a - (double)origin.x, mop.field_72307_f.field_72448_b - (double)origin.y, mop.field_72307_f.field_72449_c - (double)origin.z);
            if (FlansMod.DEBUG) {
                world.func_72838_d((Entity)new EntityDebugDot(world, new Vector3f(mop.field_72307_f), 1000, 1.0f, 0.0f, 0.0f));
            }
            float hitLambda = 1.0f;
            if (motion.x != 0.0f) {
                hitLambda = (float)(hitPoint.field_72450_a / (double)motion.x);
            } else if (motion.y != 0.0f) {
                hitLambda = (float)(hitPoint.field_72448_b / (double)motion.y);
            } else if (motion.z != 0.0f) {
                hitLambda = (float)(hitPoint.field_72449_c / (double)motion.z);
            }
            if (hitLambda < 0.0f) {
                hitLambda = -hitLambda;
            }
            hits.add(new EntityHit(entity, hitLambda));
        }
        Vec3d mot = new Vector3f(motion).toVec3();
        mot = mot.func_72432_b();
        mot = mot.func_186678_a(0.5);
        hits = FlansModRaytracer.raytraceBlock(world, origin.toVec3(), new Vec3d(0.0, 0.0, 0.0), motion, mot, hits, gunPenetration, null);
        if (!hits.isEmpty()) {
            Collections.sort(hits);
        }
        return hits;
    }

    private static List<BulletHit> raytraceBlock(World world, Vec3d posVec, Vec3d previousHit, Vector3f motion, Vec3d normalized_motion, List<BulletHit> hits, Float penetration, BlockPos oldPos) {
        Vec3d nextPosVec = new Vec3d(posVec.field_72450_a + (double)motion.x, posVec.field_72448_b + (double)motion.y, posVec.field_72449_c + (double)motion.z);
        RayTraceResult hit = world.func_147447_a(posVec, nextPosVec, false, true, true);
        if (hit != null) {
            Vec3d hitVec = hit.field_72307_f.func_178788_d(posVec);
            hitVec = hitVec.func_178787_e(previousHit);
            BlockPos pos = hit.func_178782_a();
            IBlockState blockState = world.func_180495_p(hit.func_178782_a());
            if (!pos.equals((Object)oldPos)) {
                float lambda = 1.0f;
                if (motion.x != 0.0f) {
                    lambda = (float)(hitVec.field_72450_a / (double)motion.x);
                } else if (motion.y != 0.0f) {
                    lambda = (float)(hitVec.field_72448_b / (double)motion.y);
                } else if (motion.z != 0.0f) {
                    lambda = (float)(hitVec.field_72449_c / (double)motion.z);
                }
                if (lambda < 0.0f) {
                    lambda = -lambda;
                }
                hits.add(new BlockHit(hit, Float.valueOf(lambda), blockState));
                penetration = Float.valueOf(penetration.floatValue() - ShotHandler.getBlockPenetrationDecrease(blockState, pos, world));
            }
            if (penetration.floatValue() > 0.0f) {
                hits = FlansModRaytracer.raytraceBlock(world, hit.field_72307_f.func_178787_e(normalized_motion), hitVec.func_178787_e(normalized_motion), motion, normalized_motion, hits, penetration, pos);
            }
        }
        return hits;
    }

    public static Vector3f GetPlayerMuzzlePosition(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack;
        PlayerSnapshot snapshot = new PlayerSnapshot(player);
        ItemStack itemStack = itemstack = hand == EnumHand.OFF_HAND ? player.func_184592_cb() : player.func_184614_ca();
        if (itemstack.func_77973_b() instanceof ItemGun) {
            GunType gunType = ((ItemGun)itemstack.func_77973_b()).GetType();
            AttachmentType barrelType = gunType.getBarrel(itemstack);
            return Vector3f.add(new Vector3f(player.field_70165_t, player.field_70163_u, player.field_70161_v), snapshot.GetMuzzleLocation(gunType, barrelType, hand), null);
        }
        return new Vector3f(player.func_174824_e(0.0f));
    }

    public static class PlayerBulletHit
    extends BulletHit {
        public PlayerHitbox hitbox;

        public PlayerBulletHit(PlayerHitbox box, float f) {
            super(f);
            this.hitbox = box;
        }

        @Override
        public Entity GetEntity() {
            return this.hitbox.player;
        }
    }

    public static class DriveableHit
    extends BulletHit {
        public EntityDriveable driveable;
        public EnumDriveablePart part;

        public DriveableHit(EntityDriveable d, EnumDriveablePart p, float f) {
            super(f);
            this.part = p;
            this.driveable = d;
        }

        @Override
        public Entity GetEntity() {
            return this.driveable;
        }
    }

    public static class EntityHit
    extends BulletHit {
        public Entity entity;

        public EntityHit(Entity e, float f) {
            super(f);
            this.entity = e;
        }

        @Override
        public Entity GetEntity() {
            return this.entity;
        }
    }

    public static class BlockHit
    extends BulletHit {
        private RayTraceResult raytraceResult;
        private IBlockState blockstate;

        public BlockHit(RayTraceResult mop, Float f, IBlockState blockstate) {
            super(f.floatValue());
            this.raytraceResult = mop;
            this.blockstate = blockstate;
        }

        @Override
        public Entity GetEntity() {
            return null;
        }

        public IBlockState getIBlockState() {
            return this.blockstate;
        }

        public RayTraceResult getRayTraceResult() {
            return this.raytraceResult;
        }
    }

    public static abstract class BulletHit
    implements Comparable<BulletHit> {
        public float intersectTime;

        public BulletHit(float f) {
            this.intersectTime = f;
        }

        @Override
        public int compareTo(BulletHit other) {
            if (this.intersectTime < other.intersectTime) {
                return -1;
            }
            if (this.intersectTime > other.intersectTime) {
                return 1;
            }
            return 0;
        }

        public abstract Entity GetEntity();
    }
}

