/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.network.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketGunFire
extends PacketBase {
    private EnumHand hand;

    public PacketGunFire() {
    }

    public PacketGunFire(EnumHand hand) {
        this.hand = hand;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeInt(EnumHand.MAIN_HAND.equals((Object)this.hand) ? 0 : 1);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.hand = data.readInt() == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        ItemStack itemstack = playerEntity.func_184586_b(this.hand);
        Item item = itemstack.func_77973_b();
        if (item instanceof ItemGun) {
            ItemGun gun = (ItemGun)item;
            gun.shootServer(this.hand, playerEntity, itemstack);
        } else {
            FlansMod.log.warn("Received invalid PacketGunFire. Item in hand is not an instance of ItemGun");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        FlansMod.log.warn("Received gun button packet on client. Skipping.");
    }
}

