/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.parts;

import com.flansmod.common.FlansMod;
import com.flansmod.common.parts.EnumPartCategory;
import com.flansmod.common.types.EnumType;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PartType
extends InfoType {
    public EnumPartCategory category;
    public int stackSize;
    public float engineSpeed = 1.0f;
    public float fuelConsumption = 1.0f;
    public int fuel = 0;
    public List<EnumType> worksWith = Arrays.asList(EnumType.mecha, EnumType.plane, EnumType.vehicle);
    public boolean isAIChip = false;
    public boolean canBeDefaultEngine = true;
    public ArrayList<ItemStack> partBoxRecipe = new ArrayList();
    public boolean useRFPower = false;
    public int RFDrawRate = 1;
    public static HashMap<EnumType, PartType> defaultEngines = new HashMap();
    public static List<PartType> parts = new ArrayList<PartType>();
    public static HashMap<EnumPartCategory, ArrayList<PartType>> partsByCategory = new HashMap();

    public PartType(TypeFile file) {
        super(file);
        parts.add(this);
    }

    @Override
    public void postRead(TypeFile file) {
        if (this.category == EnumPartCategory.ENGINE && !this.useRFPower && this.canBeDefaultEngine) {
            for (EnumType type : this.worksWith) {
                if (defaultEngines.containsKey((Object)type)) {
                    PartType possiblyInferiorEngine = defaultEngines.get((Object)type);
                    if (!this.isInferiorEngine(possiblyInferiorEngine)) continue;
                    defaultEngines.put(type, this);
                    continue;
                }
                defaultEngines.put(type, this);
            }
        }
        partsByCategory.get((Object)this.category).add(this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            if (split[0].equals("Category")) {
                this.category = this.getCategory(split[1]);
            } else if (split[0].equals("StackSize")) {
                this.stackSize = Integer.parseInt(split[1]);
            } else if (split[0].equals("EngineSpeed")) {
                this.engineSpeed = Float.parseFloat(split[1]);
            } else if (split[0].equals("FuelConsumption")) {
                this.fuelConsumption = Float.parseFloat(split[1]);
            } else if (split[0].equals("Fuel")) {
                this.fuel = Integer.parseInt(split[1]);
            } else if (split[0].equals("PartBoxRecipe")) {
                ItemStack[] stacks = new ItemStack[(split.length - 2) / 2];
                for (int i = 0; i < (split.length - 2) / 2; ++i) {
                    int amount = Integer.parseInt(split[2 * i + 2]);
                    boolean damaged = split[2 * i + 3].contains(".");
                    String itemName = damaged ? split[2 * i + 3].split("\\.")[0] : split[2 * i + 3];
                    int damage = damaged ? Integer.parseInt(split[2 * i + 3].split("\\.")[1]) : 0;
                    stacks[i] = PartType.getRecipeElement(itemName, amount, damage);
                }
                this.partBoxRecipe.addAll(Arrays.asList(stacks));
            } else if (split[0].equals("WorksWith")) {
                this.worksWith = new ArrayList<EnumType>();
                for (int i = 0; i < split.length - 1; ++i) {
                    this.worksWith.add(EnumType.get(split[i + 1]));
                }
            } else if (split[0].equals("UseRF") || split[0].equals("UseRFPower")) {
                this.useRFPower = Boolean.parseBoolean(split[1]);
            } else if (split[0].equals("RFDrawRate")) {
                this.RFDrawRate = Integer.parseInt(split[1]);
            } else if (split[0].equals("IsAIChip")) {
                this.isAIChip = Boolean.parseBoolean(split[1]);
            } else if (split[0].equals("CanBeDefaultEngine")) {
                this.canBeDefaultEngine = Boolean.parseBoolean(split[1]);
            }
        }
        catch (Exception e) {
            FlansMod.log.error("Reading part file failed.");
            FlansMod.log.throwing((Throwable)e);
        }
    }

    public boolean isInferiorEngine(PartType quitePossiblyAnInferiorEngine) {
        return this.engineSpeed > quitePossiblyAnInferiorEngine.engineSpeed;
    }

    public static PartType getPart(String s) {
        for (PartType part : parts) {
            if (!part.shortName.equals(s)) continue;
            return part;
        }
        return null;
    }

    private EnumPartCategory getCategory(String s) {
        if (s.equals("Cockpit")) {
            return EnumPartCategory.COCKPIT;
        }
        if (s.equals("Wing")) {
            return EnumPartCategory.WING;
        }
        if (s.equals("Engine")) {
            return EnumPartCategory.ENGINE;
        }
        if (s.equals("Propeller")) {
            return EnumPartCategory.PROPELLER;
        }
        if (s.equals("Bay")) {
            return EnumPartCategory.BAY;
        }
        if (s.equals("Tail")) {
            return EnumPartCategory.TAIL;
        }
        if (s.equals("Wheel")) {
            return EnumPartCategory.WHEEL;
        }
        if (s.equals("Chassis")) {
            return EnumPartCategory.CHASSIS;
        }
        if (s.equals("Turret")) {
            return EnumPartCategory.TURRET;
        }
        if (s.equals("Fuel")) {
            return EnumPartCategory.FUEL;
        }
        if (s.equals("Misc")) {
            return EnumPartCategory.MISC;
        }
        return EnumPartCategory.MISC;
    }

    @Override
    protected void preRead(TypeFile file) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return null;
    }

    static {
        for (EnumPartCategory cat : EnumPartCategory.values()) {
            partsByCategory.put(cat, new ArrayList());
        }
    }
}

