/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.teams.EntityFlagpole;
import com.flansmod.common.teams.GametypeCTF;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFlag
extends Entity
implements ITeamObject {
    private static final DataParameter<Byte> TEAMID = EntityDataManager.func_187226_a(EntityFlag.class, (DataSerializer)DataSerializers.field_187191_a);
    public int baseID;
    public EntityFlagpole base;
    public boolean isHome = true;
    public int timeUntilReturn;

    public EntityFlag(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70158_ak = true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        double dX = this.field_70165_t - x;
        double dY = this.field_70163_u - y;
        double dZ = this.field_70161_v - z;
        double distSq = dX * dX + dY * dY + dZ * dZ;
        double maxDist = 128.0 * EntityFlag.func_184183_bd();
        return distSq < maxDist * maxDist;
    }

    public EntityFlag(World world, EntityFlagpole pole) {
        this(world);
        this.func_70107_b(pole.field_70165_t, pole.field_70163_u + 2.0, pole.field_70161_v);
        this.setBase(pole);
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(TEAMID, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.base == null && !this.field_70170_p.field_72995_K) {
            this.setBase(TeamsManager.getInstance().getBase(this.baseID));
        }
        if (this.func_184187_bx() != null && this.func_184187_bx().field_70128_L) {
            if (this.func_184187_bx() instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)this.func_184187_bx();
                Team team = PlayerHandler.getPlayerData((String)player.func_70005_c_()).team;
                TeamsManager.getInstance();
                TeamsManager.messageAll("\u00a7f" + player.func_70005_c_() + " dropped the \u00a7" + team.textColour + team.name + "\u00a7f flag");
            } else if (this.func_184187_bx() instanceof EntityFlagpole) {
                this.func_70106_y();
            }
            this.func_184210_p();
        }
        if (!this.field_70175_ag) {
            this.field_70170_p.func_72838_d((Entity)this);
        }
        if (this.timeUntilReturn > 0) {
            if (this.func_184187_bx() instanceof EntityPlayerMP || this.isHome) {
                this.timeUntilReturn = 0;
            } else {
                --this.timeUntilReturn;
                if (this.timeUntilReturn == 0) {
                    this.reset();
                    Team flagTeam = TeamsManager.getInstance().getTeam(this.getBase().getOwnerID());
                    TeamsManager.messageAll("\u00a7fThe \u00a7" + flagTeam.textColour + flagTeam.name + "\u00a7f flag returned itself");
                }
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70066_B();
        }
    }

    public void func_184210_p() {
        this.timeUntilReturn = TeamsManager.getInstance().currentRound != null && TeamsManager.getInstance().currentRound.gametype instanceof GametypeCTF ? ((GametypeCTF)TeamsManager.getInstance().currentRound.gametype).flagReturnTime * 20 : 600;
    }

    public void reset() {
        if (this.base == null && this.func_184187_bx() instanceof EntityFlagpole) {
            this.base = (EntityFlagpole)this.func_184187_bx();
        }
        this.func_184210_p();
        if (this.base != null) {
            this.func_70107_b(this.base.field_70165_t, this.base.field_70163_u + 2.0, this.base.field_70161_v);
        }
        this.isHome = true;
    }

    public boolean func_70039_c(NBTTagCompound tags) {
        return false;
    }

    protected void func_70037_a(NBTTagCompound tags) {
    }

    protected void func_70014_b(NBTTagCompound tags) {
    }

    @Override
    public ITeamBase getBase() {
        return this.base;
    }

    @Override
    public void onBaseSet(int newTeamID) {
        this.func_184212_Q().func_187227_b(TEAMID, (Object)((byte)newTeamID));
        this.func_70107_b(this.base.field_70165_t, this.base.field_70163_u + 2.0, this.base.field_70161_v);
    }

    @Override
    public void onBaseCapture(int newTeamID) {
        this.onBaseSet(newTeamID);
    }

    @Override
    public void tick() {
    }

    @Override
    public void setBase(ITeamBase b) {
        this.base = (EntityFlagpole)b;
        if (this.base != null) {
            this.base.addObject(this);
            this.onBaseSet(this.base.getOwnerID());
        }
    }

    @Override
    public void destroy() {
        this.func_70106_y();
    }

    @Override
    public double getPosX() {
        return this.field_70165_t;
    }

    @Override
    public double getPosY() {
        return this.field_70163_u;
    }

    @Override
    public double getPosZ() {
        return this.field_70161_v;
    }

    public int getTeamID() {
        return ((Byte)this.func_184212_Q().func_187225_a(TEAMID)).byteValue();
    }

    @Override
    public boolean isSpawnPoint() {
        return false;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((Item)FlansMod.flag, 1, 0);
    }

    @Override
    public boolean forceChunkLoading() {
        return false;
    }

    public boolean func_70027_ad() {
        return false;
    }
}

