/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.paintjob.PaintableType;
import com.flansmod.common.teams.LoadoutPool;
import com.flansmod.common.teams.PlayerLoadout;
import com.flansmod.common.teams.RewardBox;
import com.flansmod.common.teams.RewardBoxInstance;
import com.flansmod.common.teams.TeamsManagerRanked;
import com.flansmod.common.types.InfoType;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PlayerRankData {
    public int pendingXP = 0;
    public int currentXP = 0;
    public int currentLevel = 0;
    public int currentKillstreak = 0;
    public int bestKillstreak = 0;
    public ArrayList<RewardBoxInstance> rewardBoxData = new ArrayList();
    public PlayerLoadout[] loadouts = new PlayerLoadout[5];

    public PlayerRankData() {
        for (int i = 0; i < 5; ++i) {
            this.loadouts[i] = new PlayerLoadout();
        }
    }

    public void writeToBuf(ByteBuf data) {
        data.writeInt(this.currentLevel);
        data.writeInt(this.currentXP);
        for (int i = 0; i < 5; ++i) {
            this.loadouts[i].writeToBuf(data);
        }
        data.writeInt(this.rewardBoxData.size());
        for (RewardBoxInstance inst : this.rewardBoxData) {
            data.writeInt(inst.boxHash);
            if (!inst.Verify()) {
                data.writeInt(0);
                FlansMod.Assert(false, "Invalid unlock data");
                continue;
            }
            data.writeInt(inst.unlockHash);
        }
    }

    public void readFromBuf(ByteBuf data) {
        this.currentLevel = data.readInt();
        this.currentXP = data.readInt();
        for (int i = 0; i < 5; ++i) {
            this.loadouts[i].readFromBuf(data);
        }
        this.rewardBoxData.clear();
        int numRewardBoxes = data.readInt();
        for (int i = 0; i < numRewardBoxes; ++i) {
            this.rewardBoxData.add(RewardBoxInstance.CreateClientRewardBoxInstance(data.readInt(), data.readInt()));
        }
    }

    public void readFromNBT(NBTTagCompound tags) {
        this.currentLevel = tags.func_74762_e("level");
        this.currentXP = tags.func_74762_e("XP");
        for (int i = 0; i < 5; ++i) {
            this.loadouts[i].readFromNBT(tags.func_74775_l("Slot_" + i));
        }
        NBTTagList rewardTags = tags.func_150295_c("rewardBoxes", 10);
        if (rewardTags != null) {
            for (int i = 0; i < rewardTags.func_74745_c(); ++i) {
                NBTTagCompound rewardInstanceTags = rewardTags.func_150305_b(i);
                int type = rewardInstanceTags.func_74762_e("type");
                int boxHash = rewardInstanceTags.func_74762_e("boxHash");
                int unlockHash = rewardInstanceTags.func_74762_e("unlockHash");
                this.rewardBoxData.add(RewardBoxInstance.CreateRewardBoxInstanceFromNBT(boxHash, unlockHash, type));
            }
        }
    }

    public void writeToNBT(NBTTagCompound tags) {
        tags.func_74768_a("level", this.currentLevel);
        tags.func_74768_a("XP", this.currentXP);
        for (int i = 0; i < 5; ++i) {
            NBTTagCompound slotTags = new NBTTagCompound();
            this.loadouts[i].writeToNBT(slotTags);
            tags.func_74782_a("Slot_" + i, (NBTBase)slotTags);
        }
        NBTTagList rewardTags = new NBTTagList();
        for (RewardBoxInstance instance : this.rewardBoxData) {
            NBTTagCompound rewardInstanceTags = new NBTTagCompound();
            rewardInstanceTags.func_74768_a("type", instance.origin.ordinal());
            rewardInstanceTags.func_74768_a("boxHash", instance.boxHash);
            rewardInstanceTags.func_74768_a("unlockHash", instance.unlockHash);
            rewardTags.func_74742_a((NBTBase)rewardInstanceTags);
        }
        tags.func_74782_a("rewardBoxes", (NBTBase)rewardTags);
    }

    public void AddXP(int amount) {
        this.pendingXP += amount;
    }

    public void AddToKillstreak() {
        ++this.currentKillstreak;
        if (this.currentKillstreak > this.bestKillstreak) {
            this.bestKillstreak = this.currentKillstreak;
        }
    }

    public void ResetKillstreak() {
        this.currentKillstreak = 0;
    }

    public boolean OwnsUnlock(int unlockHash) {
        for (RewardBoxInstance instance : this.rewardBoxData) {
            if (!instance.opened || instance.unlockHash != unlockHash) continue;
            return true;
        }
        return false;
    }

    public int GetNumOfUnopenedBoxes(RewardBox box) {
        if (box == null) {
            return 0;
        }
        int num = 0;
        for (RewardBoxInstance instance : this.rewardBoxData) {
            if (instance.opened || instance.boxHash != box.hashCode()) continue;
            ++num;
        }
        return num;
    }

    public void AddRewardBoxInstance(RewardBoxInstance instance) {
        this.rewardBoxData.add(instance);
    }

    public int GetNumUnlocksForType(InfoType type) {
        int n = 0;
        if (type instanceof PaintableType) {
            for (RewardBoxInstance instance : this.rewardBoxData) {
                for (int i = 0; i < ((PaintableType)type).paintjobs.size(); ++i) {
                    if (instance.unlockHash != ((PaintableType)type).paintjobs.get(i).hashCode()) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public boolean VerifyLoadouts() {
        for (int i = 0; i < 5; ++i) {
            LoadoutPool pool = TeamsManagerRanked.GetInstance().currentPool;
            if (pool == null || this.currentLevel < pool.slotUnlockLevels[i] || this.loadouts[i].Verify(this.currentLevel, this.rewardBoxData)) continue;
            return false;
        }
        return true;
    }
}

