/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.api.impl;

import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class BookBinder {
    private final ResourceLocation registryName;
    private final List<CategoryAbstract> categories = Lists.newArrayList();
    private String guideTitle = "item.guideapi.book.name";
    private String header;
    private String itemName;
    private String author;
    private ResourceLocation pageTexture = new ResourceLocation("guideapi", "textures/gui/book_colored.png");
    private ResourceLocation outlineTexture = new ResourceLocation("guideapi", "textures/gui/book_greyscale.png");
    private boolean hasCustomModel;
    private Color color = new Color(171, 70, 30);
    private boolean spawnWithBook;
    private CreativeTabs creativeTab = CreativeTabs.field_78026_f;

    public BookBinder(ResourceLocation registryName) {
        this.registryName = registryName;
    }

    public BookBinder addCategory(CategoryAbstract category) {
        this.categories.add(category);
        return this;
    }

    public BookBinder setGuideTitle(String guideTitle) {
        this.guideTitle = guideTitle;
        return this;
    }

    public BookBinder setHeader(String header) {
        this.header = header;
        return this;
    }

    public BookBinder setItemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    public BookBinder setAuthor(String author) {
        this.author = author;
        return this;
    }

    public BookBinder setPageTexture(ResourceLocation pageTexture) {
        this.pageTexture = pageTexture;
        return this;
    }

    public BookBinder setOutlineTexture(ResourceLocation outlineTexture) {
        this.outlineTexture = outlineTexture;
        return this;
    }

    public BookBinder setHasCustomModel() {
        this.hasCustomModel = true;
        return this;
    }

    public BookBinder setColor(Color color) {
        this.color = color;
        return this;
    }

    public BookBinder setColor(int color) {
        return this.setColor(new Color(color));
    }

    public BookBinder setSpawnWithBook() {
        this.spawnWithBook = true;
        return this;
    }

    public BookBinder setCreativeTab(CreativeTabs creativeTab) {
        this.creativeTab = creativeTab;
        return this;
    }

    public Book build() {
        if (Strings.isNullOrEmpty((String)this.author)) {
            this.author = ((ModContainer)Loader.instance().getIndexedModList().getOrDefault(this.registryName.func_110624_b(), Loader.instance().getMinecraftModContainer())).getName();
        }
        if (this.header == null) {
            this.header = this.guideTitle;
        }
        if (this.itemName == null) {
            this.itemName = this.guideTitle.substring(5);
        }
        return new Book(this.categories, this.guideTitle, this.header, this.itemName, this.author, this.pageTexture, this.outlineTexture, this.hasCustomModel, this.color, this.spawnWithBook, this.registryName, this.creativeTab);
    }
}

