/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling;

import java.text.DecimalFormat;
import java.util.Arrays;
import meldexun.entityculling.asm.hook.RenderGlobalHook;
import meldexun.entityculling.config.EntityCullingConfig;
import meldexun.entityculling.util.CameraUtil;
import meldexun.entityculling.util.CullingThread;
import meldexun.entityculling.util.IBoundingBoxCache;
import meldexun.entityculling.util.IEntityRendererCache;
import meldexun.entityculling.util.ILoadable;
import meldexun.entityculling.util.ITileEntityRendererCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GLContext;

@Mod(modid="entityculling")
public class EntityCulling {
    public static final String MOD_ID = "entityculling";
    private static CullingThread cullingThread;
    private static final DecimalFormat FORMAT;
    public static boolean isCubicChunksInstalled;
    public static boolean isFairyLightsInstalled;
    public static boolean isValkyrienSkiesInstalled;
    private static boolean isOpenGL44Supported;
    public static int frame;

    public static boolean useOpenGlBasedCulling() {
        return isOpenGL44Supported && EntityCullingConfig.openglBasedCulling;
    }

    @Mod.EventHandler
    public void onFMLConstructionEvent(FMLConstructionEvent event) {
        isOpenGL44Supported = GLContext.getCapabilities().OpenGL44;
        EntityCullingConfig.onConfigChanged();
        MinecraftForge.EVENT_BUS.register((Object)this);
        cullingThread = new CullingThread();
        cullingThread.start();
    }

    @Mod.EventHandler
    public void onFMLPostInitializationEvent(FMLPostInitializationEvent event) {
        isCubicChunksInstalled = Loader.isModLoaded((String)"cubicchunks");
        isFairyLightsInstalled = Loader.isModLoaded((String)"fairylights");
        isValkyrienSkiesInstalled = Loader.isModLoaded((String)"valkyrienskies");
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
            EntityCullingConfig.onConfigChanged();
        }
    }

    @SubscribeEvent
    public void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        ++frame;
        CameraUtil.update();
        Minecraft mc = Minecraft.func_71410_x();
        double partialTicks = mc.func_184121_ak();
        if (mc.field_71441_e != null) {
            for (Entity e : mc.field_71441_e.field_72996_f) {
                if (!((IEntityRendererCache)e).hasRenderer() || !((ILoadable)e).isChunkLoaded()) continue;
                ((IBoundingBoxCache)e).updateCachedBoundingBox(partialTicks);
            }
            for (TileEntity te : mc.field_71441_e.field_147482_g) {
                if (!((ITileEntityRendererCache)te).hasRenderer() || !((ILoadable)te).isChunkLoaded()) continue;
                ((IBoundingBoxCache)te).updateCachedBoundingBox(partialTicks);
            }
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!EntityCullingConfig.debugCullInfo) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaled = new ScaledResolution(mc);
        this.drawOnLeft("Time: " + FORMAT.format(Arrays.stream(EntityCulling.cullingThread.time).average().getAsDouble() / 1000000.0) + "ms", scaled.func_78326_a(), 160);
        this.drawOnLeft("E: " + RenderGlobalHook.entityRenderer.renderedEntities + "/" + RenderGlobalHook.entityRenderer.occludedEntities + "/" + RenderGlobalHook.entityRenderer.totalEntities, scaled.func_78326_a(), 170);
        this.drawOnLeft("TE: " + RenderGlobalHook.tileEntityRenderer.renderedTileEntities + "/" + RenderGlobalHook.tileEntityRenderer.occludedTileEntities + "/" + RenderGlobalHook.tileEntityRenderer.totalTileEntities, scaled.func_78326_a(), 180);
    }

    private void drawOnLeft(String string, int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_78276_b(string, x - mc.field_71466_p.func_78256_a(string), y, -1);
    }

    static {
        FORMAT = new DecimalFormat("#.#");
    }
}

