/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.opengl;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.function.Supplier;
import org.lwjgl.opengl.GL20;

public class ShaderBuilder {
    private final Int2ObjectMap<Supplier<String>> shaderMap = new Int2ObjectOpenHashMap();

    public ShaderBuilder addShader(int type, Supplier<String> source) {
        this.shaderMap.put(type, source);
        return this;
    }

    public int build() {
        int program = GL20.glCreateProgram();
        IntArrayList shaderList = new IntArrayList();
        for (Int2ObjectMap.Entry entry : this.shaderMap.int2ObjectEntrySet()) {
            int shader2 = GL20.glCreateShader((int)entry.getIntKey());
            GL20.glShaderSource((int)shader2, (CharSequence)((CharSequence)((Supplier)entry.getValue()).get()));
            GL20.glCompileShader((int)shader2);
            int compileStatus = GL20.glGetShaderi((int)shader2, (int)35713);
            if (compileStatus != 1) {
                int logLength = GL20.glGetShaderi((int)shader2, (int)35716);
                String shaderInfoLog = GL20.glGetShaderInfoLog((int)shader2, (int)logLength);
                throw new RuntimeException(String.format("Failed to compile shader: %d%n%s", compileStatus, shaderInfoLog));
            }
            shaderList.add(shader2);
        }
        shaderList.forEach(shader -> GL20.glAttachShader((int)program, (int)shader));
        GL20.glLinkProgram((int)program);
        int linkStatus = GL20.glGetProgrami((int)program, (int)35714);
        if (linkStatus != 1) {
            int logLength = GL20.glGetProgrami((int)program, (int)35716);
            String programInfoLog = GL20.glGetProgramInfoLog((int)program, (int)logLength);
            throw new RuntimeException(String.format("Failed to link program: %d%n%s", linkStatus, programInfoLog));
        }
        shaderList.forEach(GL20::glDeleteShader);
        return program;
    }
}

