/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.util;

public class MathUtil {
    public static double lerp(double min, double max, double x) {
        return min + (max - min) * x;
    }

    public static int signum(double x) {
        if (x > 0.0) {
            return 1;
        }
        if (x < 0.0) {
            return -1;
        }
        return 0;
    }

    public static double frac(double number) {
        return number - (double)MathUtil.floor(number);
    }

    public static int floor(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }

    public static int ceil(double value) {
        int i = (int)value;
        return value > (double)i ? i + 1 : i;
    }

    public static int round(double value) {
        int i = (int)value;
        if (value > (double)i) {
            return (int)(value + 0.5);
        }
        if (value < (double)i) {
            return (int)(value - 0.5);
        }
        return i;
    }

    public static double dist(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(MathUtil.distSqr(x1, y1, z1, x2, y2, z2));
    }

    public static double distSqr(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (x2 -= x1) * x2 + (y2 -= y1) * y2 + (z2 -= z1) * z2;
    }
}

