/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.util;

import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class MutableAABB {
    private double minX;
    private double minY;
    private double minZ;
    private double maxX;
    private double maxY;
    private double maxZ;

    public MutableAABB() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public MutableAABB(MutableAABB aabb) {
        this(aabb.minX, aabb.minY, aabb.minZ, aabb.maxX, aabb.maxY, aabb.maxZ);
    }

    public MutableAABB(AxisAlignedBB aabb) {
        this(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public MutableAABB(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.set(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public AxisAlignedBB toVanillaAABB() {
        return new AxisAlignedBB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public MutableAABB set(MutableAABB aabb) {
        return this.set(aabb.minX, aabb.minY, aabb.minZ, aabb.maxX, aabb.maxY, aabb.maxZ);
    }

    public MutableAABB set(AxisAlignedBB aabb) {
        return this.set(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public MutableAABB set(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        return this;
    }

    public MutableAABB grow(double d) {
        return this.grow(d, d, d);
    }

    public MutableAABB grow(Vec3d vec) {
        return this.grow(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public MutableAABB grow(double x, double y, double z) {
        this.minX -= x;
        this.minY -= y;
        this.minZ -= z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
        return this;
    }

    public MutableAABB offset(double x, double y, double z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
        return this;
    }

    public MutableAABB expand(Vec3d vec) {
        return this.expand(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public MutableAABB expand(Vec3d vec, double d) {
        return this.expand(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, d);
    }

    public MutableAABB expand(double x, double y, double z, double d) {
        return this.expand(x * d, y * d, z * d);
    }

    public MutableAABB expand(double x, double y, double z) {
        if (x < 0.0) {
            this.minX += x;
        } else {
            this.maxX += x;
        }
        if (y < 0.0) {
            this.minY += y;
        } else {
            this.maxY += y;
        }
        if (z < 0.0) {
            this.minZ += z;
        } else {
            this.maxZ += z;
        }
        return this;
    }

    public boolean isVisible(ICamera frustum) {
        if (frustum instanceof Frustum) {
            return ((Frustum)frustum).func_78548_b(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
        return frustum.func_78546_a(this.toVanillaAABB());
    }

    public double sizeX() {
        return this.maxX - this.minX;
    }

    public double sizeY() {
        return this.maxY - this.minY;
    }

    public double sizeZ() {
        return this.maxZ - this.minZ;
    }

    public double minX() {
        return this.minX;
    }

    public double minY() {
        return this.minY;
    }

    public double minZ() {
        return this.minZ;
    }

    public double maxX() {
        return this.maxX;
    }

    public double maxY() {
        return this.maxY;
    }

    public double maxZ() {
        return this.maxZ;
    }
}

