/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.util.culling;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import meldexun.entityculling.asm.EntityCullingClassTransformer;
import meldexun.entityculling.asm.hook.RenderGlobalHook;
import meldexun.entityculling.opengl.Buffer;
import meldexun.entityculling.opengl.ShaderBuilder;
import meldexun.entityculling.util.CameraUtil;
import meldexun.entityculling.util.ICullable;
import meldexun.entityculling.util.ResourceSupplier;
import meldexun.entityculling.util.matrix.Matrix4f;
import meldexun.reflectionutil.ReflectionMethod;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GL42;
import org.lwjgl.opengl.GLSync;

public class CullingInstance {
    private static final ReflectionMethod<Boolean> IS_SHADERS = new ReflectionMethod("Config", "isShaders", "isShaders", new Class[0]);
    private static final int MAX_OBJ_COUNT = 65536;
    private static CullingInstance instance;
    private final int shader;
    private final int uniform_projViewMat;
    private final int uniform_frame;
    private final FloatBuffer matrixBuffer = GLAllocation.func_74529_h((int)16);
    private final int cubeVertexBuffer;
    private final int cubeIndexBuffer;
    private final Buffer vboBuffer;
    private final int vao;
    private final Buffer ssboBuffer;
    private int objCount;
    private int frame;
    private GLSync fence;

    private CullingInstance() {
        this.shader = new ShaderBuilder().addShader(35633, new ResourceSupplier(new ResourceLocation("entityculling", "shaders/vert.glsl"))).addShader(35632, new ResourceSupplier(new ResourceLocation("entityculling", "shaders/frag.glsl"))).build();
        this.uniform_projViewMat = GL20.glGetUniformLocation((int)this.shader, (CharSequence)"projectionViewMatrix");
        this.uniform_frame = GL20.glGetUniformLocation((int)this.shader, (CharSequence)"frame");
        this.vboBuffer = new Buffer(0x1C0000, 66, 35048);
        this.ssboBuffer = new Buffer(262144, 65, 35049);
        this.cubeVertexBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.cubeVertexBuffer);
        GL15.glBufferData((int)34962, (ByteBuffer)CullingInstance.asByteBuffer(new byte[]{0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1}), (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
        this.cubeIndexBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34963, (int)this.cubeIndexBuffer);
        GL15.glBufferData((int)34963, (ByteBuffer)CullingInstance.asByteBuffer(new byte[]{7, 3, 5, 1, 0, 3, 2, 7, 6, 5, 4, 0, 6, 2}), (int)35044);
        GL15.glBindBuffer((int)34963, (int)0);
        this.vao = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.vao);
        GL15.glBindBuffer((int)34962, (int)this.cubeVertexBuffer);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5120, (boolean)false, (int)0, (long)0L);
        GL20.glEnableVertexAttribArray((int)0);
        GL15.glBindBuffer((int)34962, (int)this.vboBuffer.getBuffer());
        GL20.glVertexAttribPointer((int)1, (int)3, (int)5126, (boolean)false, (int)28, (long)0L);
        GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)28, (long)12L);
        GL30.glVertexAttribIPointer((int)3, (int)1, (int)5124, (int)28, (long)24L);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        GL20.glEnableVertexAttribArray((int)3);
        GL33.glVertexAttribDivisor((int)1, (int)1);
        GL33.glVertexAttribDivisor((int)2, (int)1);
        GL33.glVertexAttribDivisor((int)3, (int)1);
        GL15.glBindBuffer((int)34962, (int)0);
        GL15.glBindBuffer((int)34963, (int)this.cubeIndexBuffer);
        GL30.glBindVertexArray((int)0);
    }

    public static CullingInstance getInstance() {
        if (instance == null) {
            instance = new CullingInstance();
        }
        return instance;
    }

    private static ByteBuffer asByteBuffer(byte[] data) {
        return (ByteBuffer)GLAllocation.func_74524_c((int)data.length).put(data).flip();
    }

    private void sync() {
        if (this.fence != null) {
            GL32.glClientWaitSync((GLSync)this.fence, (int)0, (long)1000000000L);
            GL32.glDeleteSync((GLSync)this.fence);
            this.fence = null;
        }
    }

    public boolean isVisible(ICullable cullable) {
        if (cullable.culling_getLastTimeUpdated() < this.frame - 1) {
            return true;
        }
        this.sync();
        return this.ssboBuffer.getByteBuffer().getInt(cullable.culling_getId() * 4) == this.frame;
    }

    public void addBox(ICullable obj, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (obj.culling_getLastTimeUpdated() == this.frame) {
            return;
        }
        Vec3d pos = CameraUtil.getCamera();
        if (pos.field_72450_a >= minX && pos.field_72450_a <= maxX && pos.field_72448_b >= minY && pos.field_72448_b <= maxY && pos.field_72449_c >= minZ && pos.field_72449_c <= maxZ) {
            return;
        }
        this.vboBuffer.getByteBuffer().putFloat(this.objCount * 28, (float)(minX - RenderGlobalHook.cameraEntityX));
        this.vboBuffer.getByteBuffer().putFloat(this.objCount * 28 + 4, (float)(minY - RenderGlobalHook.cameraEntityY));
        this.vboBuffer.getByteBuffer().putFloat(this.objCount * 28 + 8, (float)(minZ - RenderGlobalHook.cameraEntityZ));
        this.vboBuffer.getByteBuffer().putFloat(this.objCount * 28 + 12, (float)(maxX - minX));
        this.vboBuffer.getByteBuffer().putFloat(this.objCount * 28 + 16, (float)(maxY - minY));
        this.vboBuffer.getByteBuffer().putFloat(this.objCount * 28 + 20, (float)(maxZ - minZ));
        this.vboBuffer.getByteBuffer().putInt(this.objCount * 28 + 24, this.objCount);
        obj.culling_setLastTimeUpdated(this.frame);
        obj.culling_setId(this.objCount);
        ++this.objCount;
    }

    public void updateResults(Matrix4f projViewMat) {
        ++this.frame;
        int prevShaderProgram = EntityCullingClassTransformer.OPTIFINE_DETECTED && IS_SHADERS.invoke(null, new Object[0]) != false ? GL11.glGetInteger((int)35725) : 0;
        GL20.glUseProgram((int)this.shader);
        projViewMat.store(this.matrixBuffer);
        GL20.glUniformMatrix4((int)this.uniform_projViewMat, (boolean)false, (FloatBuffer)this.matrixBuffer);
        GL20.glUniform1i((int)this.uniform_frame, (int)this.frame);
        GL30.glBindBufferBase((int)37074, (int)1, (int)this.ssboBuffer.getBuffer());
        this.setupRenderState();
        GL30.glBindVertexArray((int)this.vao);
        GL31.glDrawElementsInstanced((int)5, (int)14, (int)5121, (long)0L, (int)this.objCount);
        GL42.glMemoryBarrier((int)16384);
        this.fence = GL32.glFenceSync((int)37143, (int)0);
        GL30.glBindVertexArray((int)0);
        this.clearRenderState();
        GL20.glUseProgram((int)prevShaderProgram);
        this.objCount = 0;
    }

    private void setupRenderState() {
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.func_179118_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179122_b((int)0);
        GlStateManager.func_179122_b((int)1);
        GlStateManager.func_179119_h();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179106_n();
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)33984);
    }

    private void clearRenderState() {
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179141_d();
        GlStateManager.func_179145_e();
        GlStateManager.func_179085_a((int)0);
        GlStateManager.func_179085_a((int)1);
        GlStateManager.func_179142_g();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179127_m();
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)33984);
    }
}

