/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.alchemyArray;

import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffect;
import WayofTime.bloodmagic.util.Utils;
import java.util.List;
import javax.vecmath.Vector2d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class AlchemyArrayEffectArrowTurret
extends AlchemyArrayEffect {
    public EntityLiving target;
    public int arrowTimer;
    public static final int ARROW_WINDUP = 50;
    private int lastChestSlot = -1;
    private double pitch = 0.0;
    private double lastPitch = 0.0;
    private double yaw = 0.0;
    private double lastYaw = 0.0;

    public AlchemyArrayEffectArrowTurret(String key) {
        super(key);
    }

    @Override
    public boolean update(TileEntity tile, int ticksActive) {
        BlockPos chestPos;
        BlockPos pos = tile.func_174877_v();
        World world = tile.func_145831_w();
        TileEntity chestTile = world.func_175625_s(chestPos = pos.func_177977_b());
        if (chestTile == null) {
            return false;
        }
        IItemHandler itemHandler = Utils.getInventory(chestTile, EnumFacing.UP);
        if (itemHandler == null) {
            return false;
        }
        ItemStack arrowStack = new ItemStack(Items.field_190931_a);
        if (this.lastChestSlot >= 0 && this.lastChestSlot < itemHandler.getSlots()) {
            ItemStack testStack = itemHandler.extractItem(this.lastChestSlot, 1, true);
            if (testStack.func_190926_b() || !(testStack.func_77973_b() instanceof ItemArrow)) {
                this.lastChestSlot = -1;
            } else {
                arrowStack = testStack;
            }
        }
        if (this.lastChestSlot < 0) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack testStack = itemHandler.extractItem(i, 1, true);
                if (testStack.func_190926_b() || !(testStack.func_77973_b() instanceof ItemArrow)) continue;
                arrowStack = testStack;
                this.lastChestSlot = i;
                break;
            }
        }
        if (this.lastChestSlot < 0) {
            return false;
        }
        if (this.canFireOnMob(world, pos, (Entity)this.target)) {
            Vector2d pitchYaw = AlchemyArrayEffectArrowTurret.getPitchYaw(pos, (Entity)this.target);
            this.lastPitch = this.pitch;
            this.lastYaw = this.yaw;
            this.pitch = pitchYaw.x;
            this.yaw = pitchYaw.y;
            ++this.arrowTimer;
            if (this.arrowTimer >= 50) {
                this.fireOnTarget(world, pos, arrowStack, this.target);
                if (!world.field_72995_K) {
                    itemHandler.extractItem(this.lastChestSlot, 1, false);
                }
                this.arrowTimer = 0;
            }
            return false;
        }
        this.target = null;
        this.arrowTimer = -1;
        List mobsInRange = world.func_72872_a(EntityMob.class, this.getBounds(pos));
        for (EntityMob entity : mobsInRange) {
            if (!this.canFireOnMob(world, pos, (Entity)entity)) continue;
            this.target = entity;
            this.arrowTimer = 0;
            return false;
        }
        this.arrowTimer = -1;
        this.target = null;
        return false;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getLastPitch() {
        return this.lastPitch;
    }

    public double getYaw() {
        return this.yaw;
    }

    public double getLastYaw() {
        return this.lastYaw;
    }

    public void fireOnTarget(World world, BlockPos pos, ItemStack arrowStack, EntityLiving targetMob) {
        float vel = 3.0f;
        double damage = 2.0;
        if (!world.field_72995_K && arrowStack.func_77973_b() instanceof ItemArrow) {
            EntityTippedArrow entityarrow = new EntityTippedArrow(world);
            entityarrow.func_184555_a(arrowStack);
            entityarrow.field_70165_t = (double)pos.func_177958_n() + 0.5;
            entityarrow.field_70163_u = (double)pos.func_177956_o() + 0.5;
            entityarrow.field_70161_v = (double)pos.func_177952_p() + 0.5;
            double d0 = targetMob.field_70165_t - ((double)pos.func_177958_n() + 0.5);
            double d1 = targetMob.field_70163_u + (double)targetMob.field_70131_O - ((double)pos.func_177956_o() + 0.5);
            double d2 = targetMob.field_70161_v - ((double)pos.func_177952_p() + 0.5);
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            entityarrow.func_70239_b(damage);
            entityarrow.func_70186_c(d0, d1 + d3 * 0.05, d2, vel, 0.0f);
            world.func_72838_d((Entity)entityarrow);
        }
    }

    public static Vector2d getPitchYaw(BlockPos pos, Entity entityIn) {
        if (entityIn == null) {
            return new Vector2d(0.0, 0.0);
        }
        double distanceX = entityIn.field_70165_t - ((double)pos.func_177958_n() + 0.5);
        double distanceY = entityIn.field_70163_u + (double)entityIn.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
        double distanceZ = entityIn.field_70161_v - ((double)pos.func_177952_p() + 0.5);
        double radialDistance = Math.sqrt(distanceX * distanceX + distanceZ * distanceZ);
        double yaw = Math.atan2(-distanceX, distanceZ) * 180.0 / Math.PI;
        double pitch = -Math.atan2(distanceY, radialDistance) * 180.0 / Math.PI;
        return new Vector2d(pitch, yaw);
    }

    public boolean canEntityBeSeen(World world, BlockPos pos, Entity entityIn) {
        return world.func_147447_a(new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), new Vec3d(entityIn.field_70165_t, entityIn.field_70163_u + (double)entityIn.func_70047_e(), entityIn.field_70161_v), false, true, false) == null;
    }

    public boolean canFireOnMob(World world, BlockPos pos, Entity entityIn) {
        return entityIn != null && !entityIn.field_70128_L && entityIn.func_174831_c(pos) <= (double)(this.getRange() * this.getRange()) && entityIn.func_174831_c(pos) >= (double)(this.getMinRange() * this.getMinRange()) && this.canEntityBeSeen(world, pos, entityIn);
    }

    public AxisAlignedBB getBounds(BlockPos pos) {
        return new AxisAlignedBB(pos).func_72314_b((double)this.getRange(), (double)this.getRange(), (double)this.getRange());
    }

    public float getRange() {
        return 32.0f;
    }

    public float getMinRange() {
        return 3.0f;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public AlchemyArrayEffect getNewCopy() {
        return new AlchemyArrayEffectArrowTurret(this.key);
    }
}

