/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.block;

import WayofTime.bloodmagic.block.base.BlockInteger;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.portal.LocationsHandler;
import WayofTime.bloodmagic.teleport.PortalLocation;
import WayofTime.bloodmagic.teleport.TeleportQueue;
import WayofTime.bloodmagic.teleport.Teleports;
import WayofTime.bloodmagic.tile.TileDimensionalPortal;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDimensionalPortal
extends BlockInteger {
    protected static final AxisAlignedBB AABB_0 = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB AABB_1 = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_DEFAULT = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);

    public BlockDimensionalPortal() {
        super(Material.field_151567_E, 2);
        this.func_149663_c("bloodmagic.dimensionalPortal");
        this.func_149722_s();
        this.func_149752_b(2000.0f);
        this.func_149713_g(0);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean isFullCube() {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 12;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState blockState, Entity entity) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileDimensionalPortal) {
            ArrayList<PortalLocation> linkedLocations;
            TileDimensionalPortal tile = (TileDimensionalPortal)world.func_175625_s(pos);
            if (LocationsHandler.getLocationsHandler() != null && (linkedLocations = LocationsHandler.getLocationsHandler().getLinkedLocations(tile.portalID)) != null && !linkedLocations.isEmpty() && linkedLocations.size() > 1 && world.func_175625_s(tile.getMasterStonePos()) != null && world.func_175625_s(tile.getMasterStonePos()) instanceof IMasterRitualStone) {
                IMasterRitualStone masterRitualStone = (IMasterRitualStone)world.func_175625_s(tile.getMasterStonePos());
                if (linkedLocations.get(0).equals(new PortalLocation(masterRitualStone.getBlockPos().func_177984_a(), world.field_73011_w.getDimension()))) {
                    PortalLocation portal = linkedLocations.get(1);
                    if (portal.getDimension() == world.field_73011_w.getDimension()) {
                        TeleportQueue.getInstance().addITeleport(new Teleports.TeleportSameDim(portal.getX(), portal.getY(), portal.getZ(), entity, masterRitualStone.getOwner(), false));
                    } else {
                        TeleportQueue.getInstance().addITeleport(new Teleports.TeleportToDim(portal.getX(), portal.getY(), portal.getZ(), entity, masterRitualStone.getOwner(), world, portal.getDimension(), false));
                    }
                } else if (linkedLocations.get(1).equals(new PortalLocation(masterRitualStone.getBlockPos().func_177984_a(), world.field_73011_w.getDimension()))) {
                    PortalLocation portal = linkedLocations.get(0);
                    if (portal.getDimension() == world.field_73011_w.getDimension()) {
                        TeleportQueue.getInstance().addITeleport(new Teleports.TeleportSameDim(portal.getX(), portal.getY(), portal.getZ(), entity, masterRitualStone.getOwner(), false));
                    } else {
                        TeleportQueue.getInstance().addITeleport(new Teleports.TeleportToDim(portal.getX(), portal.getY(), portal.getZ(), entity, masterRitualStone.getOwner(), world, portal.getDimension(), false));
                    }
                }
            }
        }
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == 0) {
            return AABB_0;
        }
        if (meta == 1) {
            return AABB_1;
        }
        return AABB_DEFAULT;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        this.spawnParticles(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileDimensionalPortal();
    }

    private void spawnParticles(World world, int x, int y, int z) {
        Random random = world.field_73012_v;
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double particleX = (float)x + random.nextFloat();
            double particleY = (float)y + random.nextFloat();
            double particleZ = (float)z + random.nextFloat();
            if (i == 0 && !world.func_180495_p(new BlockPos(x, y + 1, z)).func_185914_p()) {
                particleY = (double)(y + 1) + d0;
            }
            if (i == 1 && !world.func_180495_p(new BlockPos(x, y - 1, z)).func_185914_p()) {
                particleY = (double)y - d0;
            }
            if (i == 2 && !world.func_180495_p(new BlockPos(x, y, z + 1)).func_185914_p()) {
                particleZ = (double)(z + 1) + d0;
            }
            if (i == 3 && !world.func_180495_p(new BlockPos(x, y, z - 1)).func_185914_p()) {
                particleZ = (double)z - d0;
            }
            if (i == 4 && !world.func_180495_p(new BlockPos(x + 1, y, z)).func_185914_p()) {
                particleX = (double)(x + 1) + d0;
            }
            if (i == 5 && !world.func_180495_p(new BlockPos(x - 1, y, z)).func_185914_p()) {
                particleX = (double)x - d0;
            }
            if (!(particleX < (double)x || particleX > (double)(x + 1) || particleY < 0.0 || particleY > (double)(y + 1) || particleZ < (double)z) && !(particleZ > (double)(z + 1))) continue;
            world.func_175688_a(EnumParticleTypes.REDSTONE, particleX, particleY, particleZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

