/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.core;

import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.altar.AltarTier;
import WayofTime.bloodmagic.api.impl.BloodMagicRecipeRegistrar;
import WayofTime.bloodmagic.block.BlockLifeEssence;
import WayofTime.bloodmagic.core.RegistrarBloodMagic;
import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.core.registry.OrbRegistry;
import WayofTime.bloodmagic.item.ItemSlate;
import WayofTime.bloodmagic.item.alchemy.ItemCuttingFluid;
import WayofTime.bloodmagic.item.alchemy.ItemLivingArmourPointsUpgrade;
import WayofTime.bloodmagic.item.soul.ItemSoulGem;
import WayofTime.bloodmagic.item.types.ComponentTypes;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.util.PluginUtil;
import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod.EventBusSubscriber(modid="bloodmagic")
public class RegistrarBloodMagicRecipes {
    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        for (int i = 0; i < ItemSoulGem.names.length; ++i) {
            for (EnumDemonWillType willType : EnumDemonWillType.values()) {
                ItemStack baseGemStack = new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, i);
                ItemStack newGemStack = new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, i);
                ((ItemSoulGem)RegistrarBloodMagicItems.SOUL_GEM).setCurrentType(willType, newGemStack);
                ShapelessOreRecipe shapeless = new ShapelessOreRecipe(new ResourceLocation("bloodmagic", "soul_gem"), newGemStack, new Object[]{baseGemStack, willType.getStack()});
                event.getRegistry().register(shapeless.setRegistryName("soul_gem_" + willType.func_176610_l()));
            }
        }
        OreDictionary.registerOre((String)"dustIron", (ItemStack)ComponentTypes.SAND_IRON.getStack());
        OreDictionary.registerOre((String)"dustGold", (ItemStack)ComponentTypes.SAND_GOLD.getStack());
        OreDictionary.registerOre((String)"dustCoal", (ItemStack)ComponentTypes.SAND_COAL.getStack());
        PluginUtil.handlePluginStep(PluginUtil.RegistrationStep.RECIPE_REGISTER);
        RegistrarBloodMagicItems.SOUL_TOOL_MATERIAL.setRepairItem(EnumDemonWillType.DEFAULT.getStack());
    }

    public static void registerAltarRecipes(BloodMagicRecipeRegistrar registrar) {
        registrar.addBloodAltar((Ingredient)new OreIngredient("gemDiamond"), OrbRegistry.getOrbStack(RegistrarBloodMagic.ORB_WEAK), AltarTier.ONE.ordinal(), 2000, 2, 1);
        registrar.addBloodAltar((Ingredient)new OreIngredient("stone"), ItemSlate.SlateType.BLANK.getStack(), AltarTier.ONE.ordinal(), 1000, 5, 5);
        registrar.addBloodAltar(Ingredient.func_193367_a((Item)Items.field_151133_ar), FluidUtil.getFilledBucket((FluidStack)new FluidStack(BlockLifeEssence.getLifeEssence(), 1000)), AltarTier.ONE.ordinal(), 1000, 5, 0);
        registrar.addBloodAltar(Ingredient.func_193367_a((Item)Items.field_151122_aG), new ItemStack(RegistrarBloodMagicItems.SANGUINE_BOOK), AltarTier.ONE.ordinal(), 1000, 20, 0);
        registrar.addBloodAltar((Ingredient)new OreIngredient("blockRedstone"), OrbRegistry.getOrbStack(RegistrarBloodMagic.ORB_APPRENTICE), AltarTier.TWO.ordinal(), 5000, 5, 5);
        registrar.addBloodAltar(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemSlate.SlateType.BLANK.getStack()}), ItemSlate.SlateType.REINFORCED.getStack(), AltarTier.TWO.ordinal(), 2000, 5, 5);
        registrar.addBloodAltar(Ingredient.func_193367_a((Item)Items.field_151040_l), new ItemStack(RegistrarBloodMagicItems.DAGGER_OF_SACRIFICE), AltarTier.TWO.ordinal(), 3000, 5, 5);
        registrar.addBloodAltar((Ingredient)new OreIngredient("blockGold"), OrbRegistry.getOrbStack(RegistrarBloodMagic.ORB_MAGICIAN), AltarTier.THREE.ordinal(), 25000, 20, 20);
        registrar.addBloodAltar(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemSlate.SlateType.REINFORCED.getStack()}), ItemSlate.SlateType.IMBUED.getStack(), AltarTier.THREE.ordinal(), 5000, 15, 10);
        registrar.addBloodAltar((Ingredient)new OreIngredient("obsidian"), EnumRuneType.EARTH.getStack(), AltarTier.THREE.ordinal(), 1000, 5, 5);
        registrar.addBloodAltar((Ingredient)new OreIngredient("blockLapis"), EnumRuneType.WATER.getStack(), AltarTier.THREE.ordinal(), 1000, 5, 5);
        registrar.addBloodAltar(Ingredient.func_193367_a((Item)Items.field_151064_bs), EnumRuneType.FIRE.getStack(), AltarTier.THREE.ordinal(), 1000, 5, 5);
        registrar.addBloodAltar(Ingredient.func_193367_a((Item)Items.field_151073_bk), EnumRuneType.AIR.getStack(), AltarTier.THREE.ordinal(), 1000, 5, 5);
        registrar.addBloodAltar(Ingredient.func_193367_a((Item)RegistrarBloodMagicItems.LAVA_CRYSTAL), new ItemStack(RegistrarBloodMagicItems.ACTIVATION_CRYSTAL), AltarTier.THREE.ordinal(), 10000, 20, 10);
        registrar.addBloodAltar(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(RegistrarBloodMagicItems.BLOOD_SHARD)}), OrbRegistry.getOrbStack(RegistrarBloodMagic.ORB_MASTER), AltarTier.FOUR.ordinal(), 40000, 30, 50);
        registrar.addBloodAltar(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemSlate.SlateType.IMBUED.getStack()}), ItemSlate.SlateType.DEMONIC.getStack(), AltarTier.FOUR.ordinal(), 15000, 20, 20);
        registrar.addBloodAltar((Ingredient)new OreIngredient("blockCoal"), EnumRuneType.DUSK.getStack(), AltarTier.FOUR.ordinal(), 2000, 20, 10);
        registrar.addBloodAltar((Ingredient)new OreIngredient("enderpearl"), new ItemStack(RegistrarBloodMagicItems.TELEPOSITION_FOCUS), AltarTier.FOUR.ordinal(), 2000, 10, 10);
        registrar.addBloodAltar(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(RegistrarBloodMagicItems.TELEPOSITION_FOCUS)}), new ItemStack(RegistrarBloodMagicItems.TELEPOSITION_FOCUS, 1, 1), AltarTier.FOUR.ordinal(), 10000, 20, 10);
        registrar.addBloodAltar((Ingredient)new OreIngredient("netherStar"), OrbRegistry.getOrbStack(RegistrarBloodMagic.ORB_ARCHMAGE), AltarTier.FIVE.ordinal(), 80000, 50, 100);
        registrar.addBloodAltar(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemSlate.SlateType.DEMONIC.getStack()}), ItemSlate.SlateType.ETHEREAL.getStack(), AltarTier.FIVE.ordinal(), 30000, 40, 100);
        if (ConfigHandler.general.enableTierSixEvenThoughThereIsNoContent) {
            registrar.addBloodAltar(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(RegistrarBloodMagicBlocks.DECORATIVE_BRICK, 1, 2)}), OrbRegistry.getOrbStack(RegistrarBloodMagic.ORB_TRANSCENDENT), AltarTier.SIX.ordinal(), 200000, 100, 200);
            registrar.addBloodAltar((Ingredient)new OreIngredient("glowstone"), EnumRuneType.DAWN.getStack(), AltarTier.SIX.ordinal(), 200000, 100, 200);
        }
    }

    public static void registerAlchemyTableRecipes(BloodMagicRecipeRegistrar registrar) {
        String[] oreList;
        registrar.addAlchemyTable(new ItemStack(Items.field_151007_F, 4), 0, 100, 0, Blocks.field_150325_L, Items.field_151145_ak);
        registrar.addAlchemyTable(new ItemStack(Items.field_151145_ak, 2), 0, 20, 0, Blocks.field_150351_n, Items.field_151145_ak);
        registrar.addAlchemyTable(new ItemStack(Items.field_151116_aA, 4), 100, 200, 1, Items.field_151078_bh, Items.field_151078_bh, Items.field_151078_bh, Items.field_151078_bh, Items.field_151145_ak, Items.field_151131_as);
        registrar.addAlchemyTable(ItemCuttingFluid.FluidType.EXPLOSIVE.getStack(), 500, 200, 1, "gunpowder", "gunpowder", "dustCoal");
        registrar.addAlchemyTable(new ItemStack(Items.field_151025_P), 100, 200, 1, Items.field_151015_O, Items.field_151102_aT);
        registrar.addAlchemyTable(new ItemStack((Block)Blocks.field_150349_c), 200, 200, 1, Blocks.field_150346_d, new ItemStack(Items.field_151100_aR, 1, 15), Items.field_151014_N);
        registrar.addAlchemyTable(new ItemStack(Items.field_151119_aD, 4), 50, 100, 2, Items.field_151131_as, "sand");
        registrar.addAlchemyTable(new ItemStack(Blocks.field_150435_aG, 5), 200, 200, 1, Items.field_151131_as, Blocks.field_150405_ch, Blocks.field_150405_ch, Blocks.field_150405_ch, Blocks.field_150405_ch, Blocks.field_150405_ch);
        registrar.addAlchemyTable(new ItemStack(Blocks.field_150343_Z), 50, 50, 1, Items.field_151131_as, Items.field_151129_at);
        registrar.addAlchemyTable(ComponentTypes.SULFUR.getStack(8), 0, 100, 0, Items.field_151129_at);
        registrar.addAlchemyTable(ComponentTypes.SALTPETER.getStack(4), 0, 100, 0, ComponentTypes.PLANT_OIL.getStack(), ComponentTypes.PLANT_OIL.getStack(), "dustCoal");
        registrar.addAlchemyTable(new ItemStack(Items.field_151016_H, 3), 0, 100, 0, "dustSaltpeter", "dustSulfur", new ItemStack(Items.field_151044_h, 1, 1));
        registrar.addAlchemyTable(ComponentTypes.SAND_COAL.getStack(4), 100, 100, 1, new ItemStack(Items.field_151044_h, 1, 0), new ItemStack(Items.field_151044_h, 1, 0), Items.field_151145_ak);
        registrar.addAlchemyTable(ItemCuttingFluid.FluidType.BASIC.getStack(), 1000, 400, 1, "dustCoal", "gunpowder", Items.field_151137_ax, Items.field_151102_aT, ComponentTypes.PLANT_OIL.getStack(), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b));
        registrar.addAlchemyTable(ComponentTypes.SAND_IRON.getStack(2), 400, 200, 1, "oreIron", ItemCuttingFluid.FluidType.BASIC.getStack());
        registrar.addAlchemyTable(ComponentTypes.SAND_GOLD.getStack(2), 400, 200, 1, "oreGold", ItemCuttingFluid.FluidType.BASIC.getStack());
        registrar.addAlchemyTable(new ItemStack(Items.field_151137_ax, 8), 400, 200, 1, "oreRedstone", ItemCuttingFluid.FluidType.BASIC.getStack());
        registrar.addAlchemyTable(new ItemStack(Blocks.field_150351_n), 50, 50, 1, "cobblestone", ItemCuttingFluid.FluidType.EXPLOSIVE.getStack());
        registrar.addAlchemyTable(new ItemStack((Block)Blocks.field_150354_m), 50, 50, 1, Blocks.field_150351_n, ItemCuttingFluid.FluidType.EXPLOSIVE.getStack());
        registrar.addAlchemyTable(ComponentTypes.PLANT_OIL.getStack(), 100, 100, 1, "cropCarrot", "cropCarrot", "cropCarrot", new ItemStack(Items.field_151100_aR, 1, 15));
        registrar.addAlchemyTable(ComponentTypes.PLANT_OIL.getStack(), 100, 100, 1, "cropPotato", "cropPotato", new ItemStack(Items.field_151100_aR, 1, 15));
        registrar.addAlchemyTable(ComponentTypes.PLANT_OIL.getStack(), 100, 100, 1, "cropWheat", "cropWheat", new ItemStack(Items.field_151100_aR, 1, 15));
        registrar.addAlchemyTable(ComponentTypes.PLANT_OIL.getStack(), 100, 100, 1, Items.field_185164_cV, Items.field_185164_cV, Items.field_185164_cV, new ItemStack(Items.field_151100_aR, 1, 15));
        registrar.addAlchemyTable(ComponentTypes.NEURO_TOXIN.getStack(), 1000, 100, 2, new ItemStack(Items.field_151115_aP, 1, 3));
        registrar.addAlchemyTable(ComponentTypes.ANTISEPTIC.getStack(2), 1000, 200, 2, ComponentTypes.PLANT_OIL.getStack(), "nuggetGold", "cropWheat", Items.field_151102_aT, Blocks.field_150338_P, Blocks.field_150337_Q);
        registrar.addAlchemyTable(ItemLivingArmourPointsUpgrade.UpgradeType.DRAFT_ANGELUS.getStack(), 20000, 400, 3, ComponentTypes.NEURO_TOXIN.getStack(), ComponentTypes.ANTISEPTIC.getStack(), "dustGold", Items.field_151071_bq, new ItemStack(RegistrarBloodMagicItems.BLOOD_SHARD, 1, 0), Items.field_151073_bk);
        registrar.addAlchemyTable(new ItemStack(RegistrarBloodMagicItems.POTION_FLASK), 1000, 200, 2, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b), "cropNetherWart", "dustRedstone", "dustGlowstone");
        registrar.addAlchemyTable(ComponentTypes.CATALYST_LENGTH_1.getStack(), 1000, 100, 2, "gunpowder", "cropNetherWart", "gemLapis");
        registrar.addAlchemyTable(ComponentTypes.CATALYST_POWER_1.getStack(), 1000, 100, 2, "gunpowder", "cropNetherWart", "dustRedstone");
        HashSet addedOreRecipeList = Sets.newHashSet((Object[])new String[]{"oreIron", "oreGold", "oreCoal", "oreRedstone"});
        for (String ore : oreList = (String[])OreDictionary.getOreNames().clone()) {
            if (!ore.startsWith("ore") || addedOreRecipeList.contains(ore)) continue;
            String dustName = ore.replaceFirst("ore", "dust");
            NonNullList discoveredOres = OreDictionary.getOres((String)ore);
            NonNullList dustList = OreDictionary.getOres((String)dustName);
            if (dustList == null || dustList.isEmpty() || discoveredOres == null || discoveredOres.isEmpty()) continue;
            ItemStack dustStack = ((ItemStack)dustList.get(0)).func_77946_l();
            dustStack.func_190920_e(2);
            registrar.addAlchemyTable(dustStack, 400, 200, 1, ore, ItemCuttingFluid.FluidType.BASIC.getStack());
            addedOreRecipeList.add(ore);
        }
    }

    public static void registerTartaricForgeRecipes(BloodMagicRecipeRegistrar registrar) {
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.SOUL_GEM), 1.0, 1.0, "dustRedstone", "ingotGold", "blockGlass", "dyeBlue");
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 1), 60.0, 20.0, new ItemStack(RegistrarBloodMagicItems.SOUL_GEM), "gemDiamond", "blockRedstone", "blockLapis");
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 2), 240.0, 50.0, new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 1), "gemDiamond", "blockGold", ItemSlate.SlateType.IMBUED.getStack());
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 3), 1000.0, 100.0, new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 2), ItemSlate.SlateType.DEMONIC.getStack(), new ItemStack(RegistrarBloodMagicItems.BLOOD_SHARD), EnumDemonWillType.DEFAULT.getStack());
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 4), 4000.0, 500.0, new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 3), Items.field_151156_bN);
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.SENTIENT_SWORD), 0.0, 0.0, new ItemStack(RegistrarBloodMagicItems.SOUL_GEM), new ItemStack(Items.field_151040_l));
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.SENTIENT_AXE), 0.0, 0.0, new ItemStack(RegistrarBloodMagicItems.SOUL_GEM), new ItemStack(Items.field_151036_c));
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.SENTIENT_PICKAXE), 0.0, 0.0, new ItemStack(RegistrarBloodMagicItems.SOUL_GEM), new ItemStack(Items.field_151035_b));
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.SENTIENT_SHOVEL), 0.0, 0.0, new ItemStack(RegistrarBloodMagicItems.SOUL_GEM), new ItemStack(Items.field_151037_a));
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.SENTIENT_BOW), 70.0, 0.0, new ItemStack((Item)Items.field_151031_f), new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 1), "string", "string");
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.ARCANE_ASHES), 0.0, 0.0, "dustRedstone", "dyeWhite", "gunpowder", Items.field_151044_h);
        registrar.addTartaricForge(ComponentTypes.REAGENT_WATER.getStack(), 10.0, 3.0, new ItemStack(Items.field_151102_aT), new ItemStack(Items.field_151131_as), new ItemStack(Items.field_151131_as));
        registrar.addTartaricForge(ComponentTypes.REAGENT_LAVA.getStack(), 32.0, 10.0, Items.field_151129_at, "dustRedstone", "cobblestone", "blockCoal");
        registrar.addTartaricForge(ComponentTypes.REAGENT_VOID.getStack(), 64.0, 10.0, Items.field_151133_ar, "string", "string", "gunpowder");
        registrar.addTartaricForge(ComponentTypes.REAGENT_GROWTH.getStack(), 128.0, 20.0, "treeSapling", "treeSapling", "sugarcane", Items.field_151102_aT);
        registrar.addTartaricForge(ComponentTypes.REAGENT_AIR.getStack(), 128.0, 20.0, Items.field_151073_bk, "feather", "feather");
        registrar.addTartaricForge(ComponentTypes.REAGENT_SIGHT.getStack(), 64.0, 0.0, RegistrarBloodMagicItems.SIGIL_DIVINATION, "blockGlass", "blockGlass", "dustGlowstone");
        registrar.addTartaricForge(ComponentTypes.REAGENT_HOLDING.getStack(), 64.0, 20.0, "chestWood", "leather", "string", "string");
        registrar.addTartaricForge(ComponentTypes.REAGENT_FAST_MINER.getStack(), 128.0, 10.0, Items.field_151035_b, Items.field_151036_c, Items.field_151037_a, Items.field_151016_H);
        registrar.addTartaricForge(ComponentTypes.REAGENT_AFFINITY.getStack(), 300.0, 30.0, RegistrarBloodMagicItems.SIGIL_WATER, RegistrarBloodMagicItems.SIGIL_AIR, RegistrarBloodMagicItems.SIGIL_LAVA, Blocks.field_150343_Z);
        registrar.addTartaricForge(ComponentTypes.REAGENT_SUPPRESSION.getStack(), 500.0, 50.0, RegistrarBloodMagicBlocks.TELEPOSER, Items.field_151131_as, Items.field_151129_at, Items.field_151072_bj);
        registrar.addTartaricForge(ComponentTypes.REAGENT_BINDING.getStack(), 400.0, 10.0, "dustGlowstone", "dustRedstone", "nuggetGold", Items.field_151016_H);
        registrar.addTartaricForge(ComponentTypes.REAGENT_BLOOD_LIGHT.getStack(), 300.0, 10.0, "glowstone", Blocks.field_150478_aa, "dustRedstone", "dustRedstone");
        registrar.addTartaricForge(ComponentTypes.REAGENT_MAGNETISM.getStack(), 600.0, 10.0, "string", "ingotGold", "blockIron", "ingotGold");
        registrar.addTartaricForge(ComponentTypes.REAGENT_HASTE.getStack(), 1400.0, 100.0, Items.field_151106_aX, Items.field_151102_aT, Items.field_151106_aX, "stone");
        registrar.addTartaricForge(ComponentTypes.REAGENT_BRIDGE.getStack(), 600.0, 50.0, Blocks.field_150425_aM, Blocks.field_150425_aM, "stone", Blocks.field_150343_Z);
        registrar.addTartaricForge(ComponentTypes.REAGENT_SEVERANCE.getStack(), 800.0, 70.0, Items.field_151061_bv, Items.field_151079_bi, "ingotGold", "ingotGold");
        registrar.addTartaricForge(ComponentTypes.REAGENT_COMPRESSION.getStack(), 2000.0, 200.0, "blockIron", "blockGold", Blocks.field_150343_Z, "cobblestone");
        registrar.addTartaricForge(ComponentTypes.REAGENT_TELEPOSITION.getStack(), 1500.0, 200.0, RegistrarBloodMagicBlocks.TELEPOSER, "glowstone", "blockRedstone", "ingotGold");
        registrar.addTartaricForge(ComponentTypes.REAGENT_TRANSPOSITION.getStack(), 1500.0, 200.0, RegistrarBloodMagicBlocks.TELEPOSER, "gemDiamond", Items.field_151079_bi, Blocks.field_150343_Z);
        registrar.addTartaricForge(ComponentTypes.REAGENT_CLAW.getStack(), 800.0, 120.0, Items.field_151145_ak, Items.field_151145_ak, ItemCuttingFluid.FluidType.BASIC.getStack());
        registrar.addTartaricForge(ComponentTypes.REAGENT_BOUNCE.getStack(), 200.0, 20.0, Blocks.field_180399_cE, Blocks.field_180399_cE, Items.field_151116_aA, "string");
        registrar.addTartaricForge(ComponentTypes.REAGENT_FROST.getStack(), 80.0, 10.0, Blocks.field_150432_aD, Items.field_151126_ay, Items.field_151126_ay, "dustRedstone");
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.SENTIENT_ARMOUR_GEM), 240.0, 150.0, Items.field_151163_ad, new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 1), Blocks.field_150339_S, Blocks.field_150343_Z);
        registrar.addTartaricForge(ComponentTypes.FRAME_PART.getStack(), 400.0, 10.0, "blockGlass", "stone", ItemSlate.SlateType.BLANK.getStack());
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.NODE_ROUTER), 400.0, 5.0, "stickWood", ItemSlate.SlateType.REINFORCED.getStack(), "gemLapis", "gemLapis");
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicBlocks.ITEM_ROUTING_NODE), 400.0, 5.0, "dustGlowstone", "dustRedstone", "blockGlass", "stone");
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicBlocks.OUTPUT_ROUTING_NODE), 400.0, 25.0, "dustGlowstone", "dustRedstone", "ingotIron", new ItemStack(RegistrarBloodMagicBlocks.ITEM_ROUTING_NODE));
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicBlocks.INPUT_ROUTING_NODE), 400.0, 25.0, "dustGlowstone", "dustRedstone", "ingotGold", new ItemStack(RegistrarBloodMagicBlocks.ITEM_ROUTING_NODE));
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicBlocks.MASTER_ROUTING_NODE), 400.0, 200.0, "blockIron", "gemDiamond", ItemSlate.SlateType.IMBUED.getStack());
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicBlocks.DEMON_CRYSTAL, 1, 0), 1200.0, 100.0, EnumDemonWillType.DEFAULT.getStack(), EnumDemonWillType.DEFAULT.getStack(), EnumDemonWillType.DEFAULT.getStack(), EnumDemonWillType.DEFAULT.getStack());
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicBlocks.DEMON_CRYSTAL, 1, 1), 1200.0, 100.0, EnumDemonWillType.CORROSIVE.getStack(), EnumDemonWillType.CORROSIVE.getStack(), EnumDemonWillType.CORROSIVE.getStack(), EnumDemonWillType.CORROSIVE.getStack());
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicBlocks.DEMON_CRYSTAL, 1, 2), 1200.0, 100.0, EnumDemonWillType.DESTRUCTIVE.getStack(), EnumDemonWillType.DESTRUCTIVE.getStack(), EnumDemonWillType.DESTRUCTIVE.getStack(), EnumDemonWillType.DESTRUCTIVE.getStack());
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicBlocks.DEMON_CRYSTAL, 1, 3), 1200.0, 100.0, EnumDemonWillType.VENGEFUL.getStack(), EnumDemonWillType.VENGEFUL.getStack(), EnumDemonWillType.VENGEFUL.getStack(), EnumDemonWillType.VENGEFUL.getStack());
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicBlocks.DEMON_CRYSTAL, 1, 4), 1200.0, 100.0, EnumDemonWillType.STEADFAST.getStack(), EnumDemonWillType.STEADFAST.getStack(), EnumDemonWillType.STEADFAST.getStack(), EnumDemonWillType.STEADFAST.getStack());
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicBlocks.DEMON_CRUCIBLE), 400.0, 100.0, Items.field_151066_bu, "stone", "gemLapis", "gemDiamond");
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicBlocks.DEMON_PYLON), 400.0, 50.0, "blockIron", "stone", "gemLapis", RegistrarBloodMagicItems.ITEM_DEMON_CRYSTAL);
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicBlocks.DEMON_CRYSTALLIZER), 500.0, 100.0, RegistrarBloodMagicBlocks.SOUL_FORGE, "stone", "gemLapis", "blockGlass");
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.DEMON_WILL_GAUGE), 400.0, 50.0, "ingotGold", "dustRedstone", "blockGlass", RegistrarBloodMagicItems.ITEM_DEMON_CRYSTAL);
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.RITUAL_DISMANTLER), 500.0, 100.0, new ItemStack(RegistrarBloodMagicItems.ITEM_DEMON_CRYSTAL, 1, 2), new ItemStack(RegistrarBloodMagicItems.ITEM_DEMON_CRYSTAL, 1, 2), new ItemStack(RegistrarBloodMagicItems.RITUAL_DIVINER), new ItemStack(RegistrarBloodMagicItems.BLOOD_SHARD));
    }

    public static void registerAlchemyArrayRecipes(BloodMagicRecipeRegistrar registrar) {
        registrar.addAlchemyArray(new ItemStack(Items.field_151137_ax), ItemSlate.SlateType.BLANK.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_DIVINATION), new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/DivinationSigil.png"));
        registrar.addAlchemyArray(ComponentTypes.REAGENT_WATER.getStack(), ItemSlate.SlateType.BLANK.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_WATER), new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/WaterSigil.png"));
        registrar.addAlchemyArray(ComponentTypes.REAGENT_LAVA.getStack(), ItemSlate.SlateType.BLANK.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_LAVA), new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/LavaSigil.png"));
        registrar.addAlchemyArray(ComponentTypes.REAGENT_AIR.getStack(), ItemSlate.SlateType.REINFORCED.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_AIR), new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/AirSigil.png"));
        registrar.addAlchemyArray(ComponentTypes.REAGENT_FAST_MINER.getStack(), ItemSlate.SlateType.REINFORCED.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_FAST_MINER), new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/FastMinerSigil.png"));
        registrar.addAlchemyArray(ComponentTypes.REAGENT_VOID.getStack(), ItemSlate.SlateType.REINFORCED.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_VOID), new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/VoidSigil.png"));
        registrar.addAlchemyArray(ComponentTypes.REAGENT_GROWTH.getStack(), ItemSlate.SlateType.REINFORCED.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_GREEN_GROVE), new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/GrowthSigil.png"));
        registrar.addAlchemyArray(ComponentTypes.REAGENT_AFFINITY.getStack(), ItemSlate.SlateType.IMBUED.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_ELEMENTAL_AFFINITY), new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/ElementalAffinitySigil.png"));
        registrar.addAlchemyArray(ComponentTypes.REAGENT_SIGHT.getStack(), ItemSlate.SlateType.REINFORCED.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_SEER), new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/SightSigil.png"));
        registrar.addAlchemyArray(ComponentTypes.REAGENT_HOLDING.getStack(), ItemSlate.SlateType.IMBUED.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_HOLDING), null);
        registrar.addAlchemyArray(ComponentTypes.REAGENT_BLOOD_LIGHT.getStack(), ItemSlate.SlateType.IMBUED.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_BLOOD_LIGHT), new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/LightSigil.png"));
        registrar.addAlchemyArray(ComponentTypes.REAGENT_MAGNETISM.getStack(), ItemSlate.SlateType.IMBUED.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_MAGNETISM), new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/MagnetismSigil.png"));
        registrar.addAlchemyArray(ComponentTypes.REAGENT_SUPPRESSION.getStack(), ItemSlate.SlateType.DEMONIC.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_SUPPRESSION), new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/SuppressionSigil.png"));
        registrar.addAlchemyArray(ComponentTypes.REAGENT_HASTE.getStack(), ItemSlate.SlateType.DEMONIC.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_HASTE), null);
        registrar.addAlchemyArray(ComponentTypes.REAGENT_BRIDGE.getStack(), ItemSlate.SlateType.DEMONIC.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_PHANTOM_BRIDGE), null);
        registrar.addAlchemyArray(ComponentTypes.REAGENT_COMPRESSION.getStack(), ItemSlate.SlateType.DEMONIC.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_COMPRESSION), null);
        registrar.addAlchemyArray(ComponentTypes.REAGENT_SEVERANCE.getStack(), ItemSlate.SlateType.DEMONIC.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_ENDER_SEVERANCE), null);
        registrar.addAlchemyArray(ComponentTypes.REAGENT_TELEPOSITION.getStack(), ItemSlate.SlateType.DEMONIC.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_TELEPOSITION), null);
        registrar.addAlchemyArray(ComponentTypes.REAGENT_TRANSPOSITION.getStack(), ItemSlate.SlateType.DEMONIC.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_TRANSPOSITION), null);
        registrar.addAlchemyArray(ComponentTypes.REAGENT_CLAW.getStack(), ItemSlate.SlateType.IMBUED.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_CLAW), null);
        registrar.addAlchemyArray(ComponentTypes.REAGENT_BOUNCE.getStack(), ItemSlate.SlateType.REINFORCED.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_BOUNCE), null);
        registrar.addAlchemyArray(ComponentTypes.REAGENT_FROST.getStack(), ItemSlate.SlateType.REINFORCED.getStack(), new ItemStack(RegistrarBloodMagicItems.SIGIL_FROST), null);
    }

    public static void registerSacrificeCraftRecipes(BloodMagicRecipeRegistrar registrar) {
        registrar.addSacrificeCraft(new ItemStack(RegistrarBloodMagicBlocks.TELEPOSER), 10.0, Items.field_151137_ax);
    }
}

