/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.sigil;

import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.iface.ISigil;
import WayofTime.bloodmagic.item.sigil.ItemSigilBase;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.helper.PlayerHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSigilTransposition
extends ItemSigilBase {
    public ItemSigilTransposition() {
        super("transposition", 1000);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag.func_74764_b("stored")) {
            tooltip.add(" ");
            tooltip.add(tag.func_74775_l("stored").func_74779_i("display"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return super.func_77653_i(stack);
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag.func_74764_b("stored")) {
            return super.func_77653_i(stack) + " (" + tag.func_74775_l("stored").func_74779_i("display") + ")";
        }
        return super.func_77653_i(stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos blockPos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.func_77973_b()).getHeldItem(stack, player);
        }
        if (PlayerHelper.isFakePlayer(player)) {
            return EnumActionResult.FAIL;
        }
        IBlockState state = world.func_180495_p(blockPos);
        if (!world.field_72995_K) {
            if (BloodMagicAPI.INSTANCE.getBlacklist().getTransposition().contains(state)) {
                return EnumActionResult.FAIL;
            }
            if (player.func_70093_af() && stack.func_77942_o() && !stack.func_77978_p().func_74764_b("stored")) {
                if (state.func_185903_a(player, world, blockPos) >= 0.0f && state.func_185887_b(world, blockPos) >= 0.0f) {
                    TileEntity tile;
                    int cost = this.getLpUsed();
                    NBTTagCompound stored = new NBTTagCompound();
                    stored.func_74782_a("state", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)state));
                    stored.func_74778_a("display", state.func_177230_c().getPickBlock(state, null, world, blockPos, player).func_82833_r());
                    if (state.func_177230_c().hasTileEntity(state) && (tile = world.func_175625_s(blockPos)) != null) {
                        cost *= 5;
                        stored.func_74782_a("tileData", (NBTBase)tile.func_189515_b(new NBTTagCompound()));
                        if (world.func_175625_s(blockPos) instanceof TileEntityMobSpawner) {
                            cost *= 6;
                        }
                    }
                    stack.func_77978_p().func_74782_a("stored", (NBTBase)stored);
                    NetworkHelper.getSoulNetwork(this.getBinding(stack)).syphonAndDamage(player, SoulTicket.item(stack, world, (Entity)player, cost));
                    world.func_175713_t(blockPos);
                    world.func_175698_g(blockPos);
                    return EnumActionResult.SUCCESS;
                }
            } else if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("stored")) {
                NBTTagCompound tileData;
                IBlockState worldState = world.func_180495_p(blockPos);
                NBTTagCompound storedTag = stack.func_77978_p().func_74775_l("stored");
                IBlockState storedState = NBTUtil.func_190008_d((NBTTagCompound)storedTag.func_74775_l("state"));
                NBTTagCompound nBTTagCompound = tileData = storedTag.func_74764_b("tileData") ? storedTag.func_74775_l("tileData") : null;
                if (!worldState.func_177230_c().func_176200_f((IBlockAccess)world, blockPos)) {
                    blockPos = blockPos.func_177972_a(side);
                }
                if (!stack.func_190926_b() && player.func_175151_a(blockPos, side, stack) && world.func_190527_a(storedState.func_177230_c(), blockPos, false, side, (Entity)player) && world.func_180501_a(blockPos, storedState, 3)) {
                    storedState.func_177230_c().func_180633_a(world, blockPos, storedState, (EntityLivingBase)player, ItemStack.field_190927_a);
                    if (tileData != null) {
                        tileData.func_74768_a("x", blockPos.func_177958_n());
                        tileData.func_74768_a("y", blockPos.func_177956_o());
                        tileData.func_74768_a("z", blockPos.func_177952_p());
                        TileEntity worldTile = world.func_175625_s(blockPos);
                        if (worldTile != null) {
                            worldTile.func_145839_a(tileData);
                        }
                    }
                    world.func_184138_a(blockPos, state, state, 3);
                    stack.func_77978_p().func_82580_o("stored");
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.FAIL;
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("stored")) {
            return super.getNBTShareTag(stack);
        }
        NBTTagCompound shareTag = stack.func_77978_p().func_74737_b();
        NBTTagCompound storedTag = shareTag.func_74775_l("stored");
        storedTag.func_82580_o("state");
        storedTag.func_82580_o("stored");
        return shareTag;
    }
}

