/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.soulBreath;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.client.IMeshProvider;
import WayofTime.bloodmagic.client.mesh.CustomMeshDefinitionActivatable;
import WayofTime.bloodmagic.core.RegistrarBloodMagic;
import WayofTime.bloodmagic.iface.IActivatable;
import WayofTime.bloodmagic.item.soulBreath.ItemSoulBreathContainer;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.vecmath.Vector3d;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFlightScroll
extends ItemSoulBreathContainer
implements IMeshProvider,
IActivatable {
    public static Map<EntityPlayer, Map<EntityLivingBase, Vector3d>> floatMap = new HashMap<EntityPlayer, Map<EntityLivingBase, Vector3d>>();
    public static Map<EntityPlayer, EntityLivingBase> heldEntityMap = new HashMap<EntityPlayer, EntityLivingBase>();
    public static Map<EntityPlayer, Double> heldEntityOffsetMap = new HashMap<EntityPlayer, Double>();

    public ItemFlightScroll() {
        this.func_77655_b("bloodmagic.icarusScroll");
        this.func_77637_a(BloodMagic.TAB_BM);
    }

    @Override
    public boolean getActivated(ItemStack stack) {
        return !stack.func_190926_b() && NBTHelper.checkNBT(stack).func_77978_p().func_74767_n("activated");
    }

    @Override
    public ItemStack setActivatedState(ItemStack stack, boolean activated) {
        if (!stack.func_190926_b()) {
            NBTHelper.checkNBT(stack).func_77978_p().func_74757_a("activated", activated);
            return stack;
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_70093_af()) {
            if (!this.getActivated(stack)) {
                double drainNeeded = this.getBreathCostPerSecond(stack);
                if (this.drainBreath(stack, drainNeeded, false) >= drainNeeded) {
                    this.setActivatedState(stack, true);
                }
            } else {
                this.setActivatedState(stack, false);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        if (player.func_70093_af()) {
            ItemFlightScroll.removeEntity(player, entity);
        } else {
            EntityLivingBase heldEntity = ItemFlightScroll.getHeldEntity(player);
            if (heldEntity != null && heldEntity.equals((Object)entity)) {
                heldEntityMap.remove(player);
            } else {
                ItemFlightScroll.holdEntity(player, entity);
            }
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && entity instanceof EntityPlayerMP && this.getActivated(stack)) {
            if (entity.field_70173_aa % 20 == 0) {
                double drainNeeded = this.getBreathCostPerSecond(stack);
                if (this.drainBreath(stack, drainNeeded, false) >= drainNeeded) {
                    this.drainBreath(stack, drainNeeded, true);
                } else {
                    this.setActivatedState(stack, false);
                }
            }
            this.onEffectUpdate(stack, world, (EntityPlayer)entity, itemSlot, isSelected);
        }
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            ItemFlightScroll.updateHeldEntityPosition(player);
            if (floatMap.containsKey(player)) {
                Map<EntityLivingBase, Vector3d> entityMap = floatMap.get(player);
                if (entityMap == null) {
                    return;
                }
                ArrayList<EntityLivingBase> removalList = new ArrayList<EntityLivingBase>();
                for (Map.Entry<EntityLivingBase, Vector3d> entry : entityMap.entrySet()) {
                    EntityLivingBase floatingEntity = entry.getKey();
                    if (floatingEntity == null || floatingEntity.field_70128_L || floatingEntity.field_71093_bK != player.field_71093_bK) {
                        removalList.add(floatingEntity);
                    }
                    this.followOwner(player, floatingEntity, entry.getValue());
                }
                for (EntityLivingBase livingEntity : removalList) {
                    entityMap.remove(livingEntity);
                }
                if (entityMap.isEmpty()) {
                    floatMap.remove(player);
                }
            }
        }
    }

    public static boolean updateEntityOffset(EntityPlayer player, EntityLivingBase living, Vector3d updatedOffset) {
        if (floatMap.containsKey(player)) {
            Map<EntityLivingBase, Vector3d> entityMap = floatMap.get(player);
            entityMap.put(living, updatedOffset);
            return true;
        }
        HashMap<EntityLivingBase, Vector3d> entityMap = new HashMap<EntityLivingBase, Vector3d>();
        entityMap.put(living, updatedOffset);
        floatMap.put(player, entityMap);
        return true;
    }

    @Nullable
    public static EntityLivingBase getHeldEntity(EntityPlayer player) {
        if (heldEntityMap.containsKey(player)) {
            return heldEntityMap.get(player);
        }
        return null;
    }

    public static double getHeldEntityOffset(EntityPlayer player) {
        if (heldEntityMap.containsKey(player)) {
            return heldEntityOffsetMap.get(player);
        }
        return 1.0;
    }

    public static void holdEntity(EntityPlayer player, EntityLivingBase entityLiving) {
        float distance = player.func_70032_d((Entity)entityLiving);
        Vec3d lookVec = player.func_70040_Z();
        heldEntityMap.put(player, entityLiving);
        heldEntityOffsetMap.put(player, Double.valueOf(distance));
        ItemFlightScroll.updateEntityOffset(player, entityLiving, new Vector3d(lookVec.field_72450_a * (double)distance, lookVec.field_72448_b * (double)distance, lookVec.field_72449_c * (double)distance));
    }

    public static void updateHeldEntityPosition(EntityPlayer player) {
        EntityLivingBase entityLiving = ItemFlightScroll.getHeldEntity(player);
        if (entityLiving != null) {
            double offset = ItemFlightScroll.getHeldEntityOffset(player);
            Vec3d lookVec = player.func_70040_Z();
            ItemFlightScroll.updateEntityOffset(player, entityLiving, new Vector3d(lookVec.field_72450_a * offset, lookVec.field_72448_b * offset, lookVec.field_72449_c * offset));
        }
    }

    public static void removeEntity(EntityPlayer player, EntityLivingBase living) {
        if (living == null) {
            return;
        }
        if (floatMap.containsKey(player)) {
            Map<EntityLivingBase, Vector3d> entityMap = floatMap.get(player);
            if (entityMap.containsKey(living)) {
                entityMap.remove(living);
            }
            if (entityMap.isEmpty()) {
                floatMap.remove(player);
            }
        }
    }

    public void followOwner(EntityPlayer owner, EntityLivingBase livingEntity, Vector3d offset) {
        double offsetX = offset.x;
        double offsetY = offset.y;
        double offsetZ = offset.z;
        double ownerSpeed = Math.sqrt(owner.field_70159_w * owner.field_70159_w + owner.field_70181_x * owner.field_70181_x + owner.field_70179_y * owner.field_70179_y);
        double speed = Math.max(ownerSpeed * 20.0, 2.0);
        livingEntity.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 20, 0, false, true));
        double wantedX = owner.field_70165_t + offsetX;
        double wantedY = owner.field_70163_u + offsetY;
        double wantedZ = owner.field_70161_v + offsetZ;
        Vector3d vec = new Vector3d(wantedX - livingEntity.field_70165_t, wantedY - livingEntity.field_70163_u, wantedZ - livingEntity.field_70161_v);
        double vecDistance = Math.sqrt(vec.dot(vec));
        speed = Math.min(vecDistance, speed);
        vec.normalize();
        if (speed <= 1.0E-5) {
            return;
        }
        livingEntity.func_70016_h(vec.x * speed, vec.y * speed, vec.z * speed);
    }

    public void onEffectUpdate(ItemStack stack, World world, EntityPlayer player, int itemSlot, boolean isSelected) {
        player.func_70690_d(new PotionEffect(RegistrarBloodMagic.FLIGHT, 2, 0));
    }

    @Override
    public int getMaxBreath(ItemStack stack) {
        return 20;
    }

    public double getBreathCostPerSecond(ItemStack stack) {
        return 0.01;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getMeshDefinition() {
        return new CustomMeshDefinitionActivatable("icarus_scroll");
    }

    @Override
    public void gatherVariants(Consumer<String> variants) {
        variants.accept("active=false");
        variants.accept("active=true");
    }
}

