/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.soulBreath;

import WayofTime.bloodmagic.soul.ISoulBreathContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ItemSoulBreathContainer
extends Item
implements ISoulBreathContainer {
    @Override
    public double getBreath(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("breath");
    }

    @Override
    public void setBreath(ItemStack stack, double amount) {
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("breath", amount);
    }

    @Override
    public double drainBreath(ItemStack stack, double drainAmount, boolean doDrain) {
        double breath = this.getBreath(stack);
        double breathDrained = Math.min(drainAmount, breath);
        if (doDrain) {
            this.setBreath(stack, breath - breathDrained);
        }
        return breathDrained;
    }

    @Override
    public double fillBreath(ItemStack stack, double fillAmount, boolean doFill) {
        double current = this.getBreath(stack);
        double maxBreath = this.getMaxBreath(stack);
        double filled = Math.min(fillAmount, maxBreath - current);
        if (doFill) {
            this.setBreath(stack, filled + current);
        }
        return filled;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double maxWill = this.getMaxBreath(stack);
        if (maxWill <= 0.0) {
            return 1.0;
        }
        return 1.0 - this.getBreath(stack) / maxWill;
    }
}

