/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.tracker;

import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.livingArmour.StatTracker;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeNightSight;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class StatTrackerNightSight
extends StatTracker {
    public static HashMap<LivingArmour, Double> changeMap = new HashMap();
    public static int[] damageRequired = new int[]{0, 200, 800, 1300, 2500, 3800, 5000, 7000, 9200, 11500};
    public static int neededNightVision = 3600;
    public double totalDamageDealt = 0.0;
    public int totalNightVision = 0;

    @Override
    public String getUniqueIdentifier() {
        return "bloodmagic.tracker.nightSight";
    }

    @Override
    public void resetTracker() {
        this.totalDamageDealt = 0.0;
        this.totalNightVision = 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.totalDamageDealt = tag.func_74769_h("bloodmagic.tracker.nightSight");
        this.totalNightVision = tag.func_74762_e("bloodmagic.tracker.nightSightVision");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74780_a("bloodmagic.tracker.nightSight", this.totalDamageDealt);
        tag.func_74768_a("bloodmagic.tracker.nightSightVision", this.totalNightVision);
    }

    @Override
    public boolean onTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        double change;
        boolean test = false;
        if (changeMap.containsKey(livingArmour) && (change = Math.abs(changeMap.get(livingArmour))) > 0.0) {
            this.totalDamageDealt += Math.abs(changeMap.get(livingArmour));
            changeMap.put(livingArmour, 0.0);
            test = true;
        }
        if (world.func_175699_k(player.func_180425_c()) <= 9 && player.func_70644_a(MobEffects.field_76439_r)) {
            ++this.totalNightVision;
            test = true;
        }
        if (test) {
            this.markDirty();
        }
        return test;
    }

    @Override
    public void onDeactivatedTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        if (changeMap.containsKey(livingArmour)) {
            changeMap.remove(livingArmour);
        }
    }

    @Override
    public List<LivingArmourUpgrade> getUpgrades() {
        ArrayList<LivingArmourUpgrade> upgradeList = new ArrayList<LivingArmourUpgrade>();
        if (this.totalNightVision < neededNightVision) {
            return upgradeList;
        }
        for (int i = 0; i < 10; ++i) {
            if (!(this.totalDamageDealt >= (double)damageRequired[i])) continue;
            upgradeList.add(new LivingArmourUpgradeNightSight(i));
        }
        return upgradeList;
    }

    @Override
    public double getProgress(LivingArmour livingArmour, int currentLevel) {
        return Utils.calculateStandardProgress(this.totalDamageDealt, damageRequired, currentLevel);
    }

    @Override
    public boolean providesUpgrade(String key) {
        return key.equals("bloodmagic.upgrade.nightSight");
    }

    @Override
    public void onArmourUpgradeAdded(LivingArmourUpgrade upgrade) {
        int level;
        if (upgrade instanceof LivingArmourUpgradeNightSight && (level = upgrade.getUpgradeLevel()) < damageRequired.length) {
            this.totalDamageDealt = Math.max(this.totalDamageDealt, (double)damageRequired[level]);
            this.totalNightVision = neededNightVision;
            this.markDirty();
        }
    }

    public static void incrementCounter(LivingArmour armour, double damage) {
        changeMap.put(armour, changeMap.containsKey(armour) ? changeMap.get(armour) + damage : damage);
    }
}

