/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.registry;

import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffect;
import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectArrowTurret;
import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectAttractor;
import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectBinding;
import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectBounce;
import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectFurnaceFuel;
import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectLaputa;
import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectMobSacrifice;
import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectMovement;
import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectSigil;
import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectSkeletonTurret;
import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectSpike;
import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectTeleport;
import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectUpdraft;
import WayofTime.bloodmagic.alchemyArray.AlchemyCircleRenderer;
import WayofTime.bloodmagic.client.render.alchemyArray.AttractorAlchemyCircleRenderer;
import WayofTime.bloodmagic.client.render.alchemyArray.BindingAlchemyCircleRenderer;
import WayofTime.bloodmagic.client.render.alchemyArray.DualAlchemyCircleRenderer;
import WayofTime.bloodmagic.client.render.alchemyArray.LowAlchemyCircleRenderer;
import WayofTime.bloodmagic.client.render.alchemyArray.LowStaticAlchemyCircleRenderer;
import WayofTime.bloodmagic.client.render.alchemyArray.MobSacrificeAlchemyCircleRenderer;
import WayofTime.bloodmagic.client.render.alchemyArray.SingleAlchemyCircleRenderer;
import WayofTime.bloodmagic.client.render.alchemyArray.StaticAlchemyCircleRenderer;
import WayofTime.bloodmagic.client.render.alchemyArray.TurretAlchemyCircleRenderer;
import WayofTime.bloodmagic.compress.AdvancedCompressionHandler;
import WayofTime.bloodmagic.compress.BaseCompressionHandler;
import WayofTime.bloodmagic.compress.CompressionRegistry;
import WayofTime.bloodmagic.compress.StorageBlockCraftingManager;
import WayofTime.bloodmagic.core.RegistrarBloodMagic;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.core.registry.AlchemyArrayRecipeRegistry;
import WayofTime.bloodmagic.core.registry.AlchemyTableRecipeRegistry;
import WayofTime.bloodmagic.core.registry.LivingArmourDowngradeRecipeRegistry;
import WayofTime.bloodmagic.iface.ISigil;
import WayofTime.bloodmagic.item.types.ComponentTypes;
import WayofTime.bloodmagic.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.livingArmour.downgrade.LivingArmourUpgradeBattleHungry;
import WayofTime.bloodmagic.livingArmour.downgrade.LivingArmourUpgradeCrippledArm;
import WayofTime.bloodmagic.livingArmour.downgrade.LivingArmourUpgradeDigSlowdown;
import WayofTime.bloodmagic.livingArmour.downgrade.LivingArmourUpgradeDisoriented;
import WayofTime.bloodmagic.livingArmour.downgrade.LivingArmourUpgradeMeleeDecrease;
import WayofTime.bloodmagic.livingArmour.downgrade.LivingArmourUpgradeQuenched;
import WayofTime.bloodmagic.livingArmour.downgrade.LivingArmourUpgradeSlowHeal;
import WayofTime.bloodmagic.livingArmour.downgrade.LivingArmourUpgradeSlowness;
import WayofTime.bloodmagic.livingArmour.downgrade.LivingArmourUpgradeStormTrooper;
import WayofTime.bloodmagic.potion.BMPotionUtils;
import WayofTime.bloodmagic.recipe.alchemyTable.AlchemyTableDyeableRecipe;
import WayofTime.bloodmagic.recipe.alchemyTable.AlchemyTablePotionRecipe;
import WayofTime.bloodmagic.util.BMLog;
import WayofTime.bloodmagic.util.Utils;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class ModRecipes {
    static ItemStack mundaneLengtheningStack = ComponentTypes.CATALYST_LENGTH_1.getStack();
    static ItemStack mundanePowerStack = ComponentTypes.CATALYST_POWER_1.getStack();

    public static void init() {
        ModRecipes.initOreDict();
        ModRecipes.addFurnaceRecipes();
        ModRecipes.addAltarRecipes();
        ModRecipes.addAlchemyArrayRecipes();
        ModRecipes.addAlchemyTableRecipes();
        ModRecipes.addPotionRecipes();
        ModRecipes.addLivingArmourDowngradeRecipes();
        ModRecipes.addCompressionHandlers();
    }

    public static void initOreDict() {
        OreDictionary.registerOre((String)"dustIron", (ItemStack)ComponentTypes.SAND_IRON.getStack());
        OreDictionary.registerOre((String)"dustGold", (ItemStack)ComponentTypes.SAND_GOLD.getStack());
        OreDictionary.registerOre((String)"dustCoal", (ItemStack)ComponentTypes.SAND_COAL.getStack());
        OreDictionary.registerOre((String)"dustSulfur", (ItemStack)ComponentTypes.SULFUR.getStack());
        OreDictionary.registerOre((String)"dustSaltpeter", (ItemStack)ComponentTypes.SALTPETER.getStack());
    }

    public static void addFurnaceRecipes() {
        FurnaceRecipes.func_77602_a().func_151394_a(ComponentTypes.SAND_IRON.getStack(), new ItemStack(Items.field_151042_j), 0.15f);
        FurnaceRecipes.func_77602_a().func_151394_a(ComponentTypes.SAND_GOLD.getStack(), new ItemStack(Items.field_151043_k), 0.15f);
    }

    public static void addAltarRecipes() {
    }

    public static void addAlchemyArrayRecipes() {
        AlchemyArrayRecipeRegistry.registerRecipe(ComponentTypes.REAGENT_BINDING.getStack(), new ItemStack(Items.field_151048_u), (AlchemyArrayEffect)new AlchemyArrayEffectBinding("boundSword", Utils.setUnbreakable(new ItemStack(RegistrarBloodMagicItems.BOUND_SWORD))), (AlchemyCircleRenderer)new BindingAlchemyCircleRenderer());
        AlchemyArrayRecipeRegistry.registerRecipe(ComponentTypes.REAGENT_BINDING.getStack(), new ItemStack(Items.field_151056_x), (AlchemyArrayEffect)new AlchemyArrayEffectBinding("boundAxe", Utils.setUnbreakable(new ItemStack(RegistrarBloodMagicItems.BOUND_AXE))));
        AlchemyArrayRecipeRegistry.registerRecipe(ComponentTypes.REAGENT_BINDING.getStack(), new ItemStack(Items.field_151046_w), (AlchemyArrayEffect)new AlchemyArrayEffectBinding("boundPickaxe", Utils.setUnbreakable(new ItemStack(RegistrarBloodMagicItems.BOUND_PICKAXE))));
        AlchemyArrayRecipeRegistry.registerRecipe(ComponentTypes.REAGENT_BINDING.getStack(), new ItemStack(Items.field_151047_v), (AlchemyArrayEffect)new AlchemyArrayEffectBinding("boundShovel", Utils.setUnbreakable(new ItemStack(RegistrarBloodMagicItems.BOUND_SHOVEL))));
        AlchemyArrayRecipeRegistry.registerRecipe(ComponentTypes.REAGENT_BINDING.getStack(), new ItemStack((Item)Items.field_151028_Y), (AlchemyArrayEffect)new AlchemyArrayEffectBinding("livingHelmet", new ItemStack(RegistrarBloodMagicItems.LIVING_ARMOUR_HELMET)));
        AlchemyArrayRecipeRegistry.registerRecipe(ComponentTypes.REAGENT_BINDING.getStack(), new ItemStack((Item)Items.field_151030_Z), (AlchemyArrayEffect)new AlchemyArrayEffectBinding("livingChest", new ItemStack(RegistrarBloodMagicItems.LIVING_ARMOUR_CHEST)));
        AlchemyArrayRecipeRegistry.registerRecipe(ComponentTypes.REAGENT_BINDING.getStack(), new ItemStack((Item)Items.field_151165_aa), (AlchemyArrayEffect)new AlchemyArrayEffectBinding("livingLegs", new ItemStack(RegistrarBloodMagicItems.LIVING_ARMOUR_LEGGINGS)));
        AlchemyArrayRecipeRegistry.registerRecipe(ComponentTypes.REAGENT_BINDING.getStack(), new ItemStack((Item)Items.field_151167_ab), (AlchemyArrayEffect)new AlchemyArrayEffectBinding("livingBoots", new ItemStack(RegistrarBloodMagicItems.LIVING_ARMOUR_BOOTS)));
        AlchemyArrayRecipeRegistry.registerRecipe(new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151078_bh), (AlchemyArrayEffect)new AlchemyArrayEffectAttractor("attractor"), (AlchemyCircleRenderer)new AttractorAlchemyCircleRenderer());
        AlchemyArrayRecipeRegistry.registerRecipe(new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151137_ax), (AlchemyArrayEffect)new AlchemyArrayEffectMovement("movement"), (AlchemyCircleRenderer)new StaticAlchemyCircleRenderer(new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/MovementArray.png")));
        AlchemyArrayRecipeRegistry.registerRecipe(new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151114_aO), (AlchemyArrayEffect)new AlchemyArrayEffectUpdraft("updraft"), (AlchemyCircleRenderer)new AttractorAlchemyCircleRenderer(new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/UpdraftArray.png")));
        AlchemyArrayRecipeRegistry.registerRecipe(new ItemStack(Items.field_151123_aH), new ItemStack(Items.field_151137_ax), (AlchemyArrayEffect)new AlchemyArrayEffectBounce("bounce"), (AlchemyCircleRenderer)new SingleAlchemyCircleRenderer(new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/BounceArray.png")));
        AlchemyArrayRecipeRegistry.registerRecipe(new ItemStack(Items.field_151044_h), new ItemStack(Items.field_151137_ax), (AlchemyArrayEffect)new AlchemyArrayEffectFurnaceFuel("furnace"), (AlchemyCircleRenderer)new LowAlchemyCircleRenderer(new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/FurnaceArray.png")));
        AlchemyArrayRecipeRegistry.registerRecipe(new ItemStack(Items.field_151032_g), new ItemStack(Items.field_151008_G), (AlchemyArrayEffect)new AlchemyArrayEffectSkeletonTurret("skeletonTurret"), (AlchemyCircleRenderer)new DualAlchemyCircleRenderer(new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/SkeletonTurret1.png"), new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/SkeletonTurret2.png")));
        AlchemyArrayRecipeRegistry.registerRecipe(new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151137_ax), (AlchemyArrayEffect)new AlchemyArrayEffectTeleport("teleport"), (AlchemyCircleRenderer)new StaticAlchemyCircleRenderer(new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/teleportation.png")));
        AlchemyArrayRecipeRegistry.registerRecipe(new ItemStack((Item)Items.field_151031_f), new ItemStack(Items.field_151032_g), (AlchemyArrayEffect)new AlchemyArrayEffectArrowTurret("turret"), (AlchemyCircleRenderer)new TurretAlchemyCircleRenderer(new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/SkeletonTurret1.png")));
        AlchemyArrayRecipeRegistry.registerRecipe(new ItemStack(Items.field_151137_ax), new ItemStack(Blocks.field_150368_y), (AlchemyArrayEffect)new AlchemyArrayEffectLaputa("laputa"), (AlchemyCircleRenderer)new AttractorAlchemyCircleRenderer(new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/shardoflaputa.png")));
        AlchemyArrayRecipeRegistry.registerRecipe(new ItemStack(Blocks.field_150347_e), new ItemStack(Items.field_151042_j), (AlchemyArrayEffect)new AlchemyArrayEffectSpike("spike"), (AlchemyCircleRenderer)new LowStaticAlchemyCircleRenderer(new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/spikearray.png")));
        AlchemyArrayRecipeRegistry.registerRecipe(new ItemStack(Blocks.field_150451_bX), new ItemStack(Items.field_151137_ax), (AlchemyArrayEffect)new AlchemyArrayEffectMobSacrifice("mobSacrifice"), (AlchemyCircleRenderer)new MobSacrificeAlchemyCircleRenderer());
        AlchemyArrayRecipeRegistry.registerRecipe(ComponentTypes.REAGENT_FAST_MINER.getStack(), new ItemStack(Items.field_151035_b), (AlchemyArrayEffect)new AlchemyArrayEffectSigil("fastMiner", (ISigil)RegistrarBloodMagicItems.SIGIL_FAST_MINER), (AlchemyCircleRenderer)new SingleAlchemyCircleRenderer(new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/FastMinerSigil.png")));
    }

    public static void addCompressionHandlers() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        StorageBlockCraftingManager.getInstance().addStorageBlockRecipes();
        CompressionRegistry.registerHandler(new BaseCompressionHandler(new ItemStack(Items.field_151114_aO, 4, 0), new ItemStack(Blocks.field_150426_aN), 64));
        CompressionRegistry.registerHandler(new BaseCompressionHandler(new ItemStack(Items.field_151126_ay, 4, 0), new ItemStack(Blocks.field_150433_aE), 8));
        CompressionRegistry.registerHandler(new AdvancedCompressionHandler());
        stopwatch.stop();
        BMLog.DEBUG.info("Added compression recipes in {}", stopwatch);
    }

    public static void addAlchemyTableRecipes() {
        AlchemyTableRecipeRegistry.registerRecipe(new AlchemyTableDyeableRecipe(0, 100, 0, new ItemStack(RegistrarBloodMagicItems.SIGIL_HOLDING)));
    }

    public static void addPotionRecipes() {
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_151073_bk), new PotionEffect(MobEffects.field_76428_l, 450));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_151150_bK), new PotionEffect(MobEffects.field_76439_r, 2400));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_151064_bs), new PotionEffect(MobEffects.field_76426_n, 2400));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_151131_as), new PotionEffect(MobEffects.field_76427_o, 2400));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_151102_aT), new PotionEffect(MobEffects.field_76424_c, 2400));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_151060_bw), new PotionEffect(MobEffects.field_76432_h, 1));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_151070_bp), new PotionEffect(MobEffects.field_76436_u, 450));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_151100_aR, 1, 0), new PotionEffect(MobEffects.field_76440_q, 450));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_151071_bq), new PotionEffect(MobEffects.field_76437_t, 450));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_151065_br), new PotionEffect(MobEffects.field_76420_g, 2400));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_151008_G), new PotionEffect(MobEffects.field_76430_j, 2400));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_151119_aD), new PotionEffect(MobEffects.field_76421_d, 450));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_151137_ax), new PotionEffect(MobEffects.field_76422_e, 2400));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_151069_bo), new PotionEffect(MobEffects.field_76441_p, 2400));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_151170_bI), new PotionEffect(MobEffects.field_76443_y, 1));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(RegistrarBloodMagicItems.BLOOD_SHARD, 1, 0), new PotionEffect(MobEffects.field_180152_w, 2400));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Blocks.field_180399_cE), new PotionEffect(RegistrarBloodMagic.BOUNCE, 2400));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_151007_F), new PotionEffect(RegistrarBloodMagic.CLING, 2400));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_151105_aU), new PotionEffect(RegistrarBloodMagic.FLIGHT, 2400));
        ModRecipes.addPotionRecipe(1000, 1, new ItemStack(Items.field_185164_cV), new PotionEffect(RegistrarBloodMagic.DEAFNESS, 450));
    }

    public static void addPotionRecipe(int lpDrained, int tier, ItemStack inputStack, PotionEffect baseEffect) {
        AlchemyTableRecipeRegistry.registerRecipe(new AlchemyTablePotionRecipe(lpDrained, 100, tier, inputStack, baseEffect));
        ArrayList<ItemStack> lengtheningList = new ArrayList<ItemStack>();
        lengtheningList.add(inputStack);
        lengtheningList.add(mundaneLengtheningStack);
        AlchemyTableRecipeRegistry.registerRecipe(BMPotionUtils.getLengthAugmentRecipe(lpDrained, 100, tier, lengtheningList, baseEffect, 1.0));
        ArrayList<ItemStack> powerList = new ArrayList<ItemStack>();
        powerList.add(inputStack);
        powerList.add(mundanePowerStack);
        AlchemyTableRecipeRegistry.registerRecipe(BMPotionUtils.getPowerAugmentRecipe(lpDrained, 100, tier, powerList, baseEffect, 1));
    }

    public static void addLivingArmourDowngradeRecipes() {
        String messageBase = "ritual.bloodmagic.downgradeRitual.dialogue.";
        ItemStack bowStack = new ItemStack((Item)Items.field_151031_f);
        ItemStack bottleStack = new ItemStack((Item)Items.field_151068_bn, 1, 0);
        ItemStack swordStack = new ItemStack(Items.field_151052_q);
        ItemStack goldenAppleStack = new ItemStack(Items.field_151153_ao);
        ItemStack fleshStack = new ItemStack(Items.field_151078_bh);
        ItemStack shieldStack = new ItemStack(Items.field_185159_cQ);
        ItemStack pickStack = new ItemStack(Items.field_151050_s);
        ItemStack minecartStack = new ItemStack(Items.field_151143_au);
        ItemStack stringStack = new ItemStack(Items.field_151007_F);
        HashMap<ItemStack, Pair> dialogueMap = new HashMap<ItemStack, Pair>();
        dialogueMap.put(bowStack, Pair.of((Object)"bow", (Object)new int[]{1, 100, 300, 500}));
        dialogueMap.put(bottleStack, Pair.of((Object)"quenched", (Object)new int[]{1, 100, 300, 500}));
        dialogueMap.put(swordStack, Pair.of((Object)"dulledBlade", (Object)new int[]{1, 100, 300, 500, 700}));
        dialogueMap.put(goldenAppleStack, Pair.of((Object)"slowHeal", (Object)new int[]{1, 100, 300, 500, 700}));
        for (Map.Entry entry : dialogueMap.entrySet()) {
            ItemStack keyStack = (ItemStack)entry.getKey();
            String str = (String)((Pair)entry.getValue()).getKey();
            HashMap<Integer, List<ITextComponent>> textMap = new HashMap<Integer, List<ITextComponent>>();
            for (int tick : (int[])((Pair)entry.getValue()).getValue()) {
                ArrayList<TextComponentTranslation> textList = new ArrayList<TextComponentTranslation>();
                textList.add(new TextComponentTranslation("\u00a74%s", new Object[]{new TextComponentTranslation(messageBase + str + "." + tick, new Object[0])}));
                textMap.put(tick, textList);
            }
            LivingArmourDowngradeRecipeRegistry.registerDialog(keyStack, textMap);
        }
        LivingArmourDowngradeRecipeRegistry.registerRecipe(new LivingArmourUpgradeStormTrooper(0), bowStack, Items.field_151032_g, "string", "ingotIron", "ingotIron");
        LivingArmourDowngradeRecipeRegistry.registerRecipe(new LivingArmourUpgradeStormTrooper(1), bowStack, Items.field_185166_h, "ingotGold", "dustRedstone", "dustGlowstone", "gemLapis");
        LivingArmourDowngradeRecipeRegistry.registerRecipe(new LivingArmourUpgradeStormTrooper(2), bowStack, "gemDiamond", Items.field_151059_bz, Items.field_151072_bj, "feather");
        LivingArmourDowngradeRecipeRegistry.registerRecipe(new LivingArmourUpgradeStormTrooper(3), bowStack, Items.field_179562_cC, Items.field_151072_bj, "feather", "feather");
        LivingArmourDowngradeRecipeRegistry.registerRecipe(new LivingArmourUpgradeStormTrooper(4), bowStack, new ItemStack(Items.field_185167_i, 1, Short.MAX_VALUE), new ItemStack(Items.field_185167_i, 1, Short.MAX_VALUE), new ItemStack(Items.field_185167_i, 1, Short.MAX_VALUE));
        LivingArmourDowngradeRecipeRegistry.registerRecipe(new LivingArmourUpgradeQuenched(0), bottleStack, Items.field_185157_bK);
        LivingArmourDowngradeRecipeRegistry.registerRecipe(new LivingArmourUpgradeCrippledArm(0), shieldStack, "gemDiamond");
        for (int i = 0; i < 10; ++i) {
            ModRecipes.addRecipeForTieredDowngrade(new LivingArmourUpgradeMeleeDecrease(i), swordStack, i);
            ModRecipes.addRecipeForTieredDowngrade(new LivingArmourUpgradeSlowHeal(i), goldenAppleStack, i);
            ModRecipes.addRecipeForTieredDowngrade(new LivingArmourUpgradeBattleHungry(i), fleshStack, i);
            ModRecipes.addRecipeForTieredDowngrade(new LivingArmourUpgradeDigSlowdown(i), pickStack, i);
            ModRecipes.addRecipeForTieredDowngrade(new LivingArmourUpgradeDisoriented(i), minecartStack, i);
            ModRecipes.addRecipeForTieredDowngrade(new LivingArmourUpgradeSlowness(i), stringStack, i);
        }
    }

    public static void addRecipeForTieredDowngrade(LivingArmourUpgrade upgrade, ItemStack stack, int tier) {
        switch (tier) {
            case 0: {
                LivingArmourDowngradeRecipeRegistry.registerRecipe(upgrade, stack, "ingotIron", new ItemStack(RegistrarBloodMagicItems.SLATE, 1, 0));
                break;
            }
            case 1: {
                LivingArmourDowngradeRecipeRegistry.registerRecipe(upgrade, stack, "dustRedstone", "dustRedstone", "ingotIron", new ItemStack(RegistrarBloodMagicItems.SLATE, 1, 0));
                break;
            }
            case 2: {
                LivingArmourDowngradeRecipeRegistry.registerRecipe(upgrade, stack, "ingotGold", "gemLapis", "gemLapis", new ItemStack(RegistrarBloodMagicItems.SLATE, 1, 1));
                break;
            }
            case 3: {
                LivingArmourDowngradeRecipeRegistry.registerRecipe(upgrade, stack, Blocks.field_150395_bd, "dyeRed", Items.field_151150_bK, new ItemStack(RegistrarBloodMagicItems.SLATE, 1, 1));
                break;
            }
            case 4: {
                LivingArmourDowngradeRecipeRegistry.registerRecipe(upgrade, stack, Items.field_151153_ao, "treeSapling", "treeSapling", new ItemStack(RegistrarBloodMagicItems.SLATE, 1, 2));
                break;
            }
            case 5: {
                LivingArmourDowngradeRecipeRegistry.registerRecipe(upgrade, stack, Blocks.field_150339_S, Blocks.field_150451_bX, new ItemStack(RegistrarBloodMagicItems.SLATE, 1, 2));
                break;
            }
            case 6: {
                LivingArmourDowngradeRecipeRegistry.registerRecipe(upgrade, stack, Blocks.field_150339_S, Blocks.field_150426_aN, "ingotGold", "ingotGold", new ItemStack(RegistrarBloodMagicItems.SLATE, 1, 3));
                break;
            }
            case 7: {
                LivingArmourDowngradeRecipeRegistry.registerRecipe(upgrade, stack, Blocks.field_150340_R, Blocks.field_150368_y, "gemDiamond", new ItemStack(RegistrarBloodMagicItems.SLATE, 1, 3));
                break;
            }
            case 8: {
                LivingArmourDowngradeRecipeRegistry.registerRecipe(upgrade, stack, Items.field_185157_bK, "gemDiamond", new ItemStack(RegistrarBloodMagicItems.SLATE, 1, 4));
                break;
            }
            case 9: {
                LivingArmourDowngradeRecipeRegistry.registerRecipe(upgrade, stack, Items.field_151156_bN, "gemDiamond", "gemDiamond", new ItemStack(RegistrarBloodMagicItems.SLATE, 1, 4));
            }
        }
    }
}

