/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.util;

import WayofTime.bloodmagic.item.sigil.ItemSigilFluidBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class SigilFluidWrapper
implements ICapabilityProvider {
    final ItemStack stack;
    final ItemSigilFluidBase sigil;
    final boolean canFill;
    final boolean canDrain;

    public SigilFluidWrapper(ItemStack stackIn, ItemSigilFluidBase fluidSigil) {
        this.stack = stackIn;
        this.sigil = fluidSigil;
        this.canFill = true;
        this.canDrain = true;
    }

    public SigilFluidWrapper(ItemStack stackIn, ItemSigilFluidBase fluidSigil, boolean canFillIn, boolean canDrainIn) {
        this.stack = stackIn;
        this.sigil = fluidSigil;
        this.canFill = canFillIn;
        this.canDrain = canDrainIn;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing from) {
        if (!this.hasCapability(capability, from)) {
            return null;
        }
        return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)new IFluidHandlerItem(){

            public IFluidTankProperties[] getTankProperties() {
                return new IFluidTankProperties[]{new FluidTankProperties(SigilFluidWrapper.this.sigil.getFluid(SigilFluidWrapper.this.stack), SigilFluidWrapper.this.sigil.getCapacity(SigilFluidWrapper.this.stack), SigilFluidWrapper.this.canFill, SigilFluidWrapper.this.canDrain)};
            }

            public int fill(FluidStack resource, boolean doFill) {
                return 0;
            }

            @Nullable
            public FluidStack drain(FluidStack resource, boolean doDrain) {
                return SigilFluidWrapper.this.sigil.drain(SigilFluidWrapper.this.stack, resource.amount, doDrain);
            }

            @Nullable
            public FluidStack drain(int maxDrain, boolean doDrain) {
                return SigilFluidWrapper.this.sigil.drain(SigilFluidWrapper.this.stack, maxDrain, doDrain);
            }

            @Nonnull
            public ItemStack getContainer() {
                return SigilFluidWrapper.this.stack;
            }
        });
    }
}

