/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.common.affix.affix;

import c4.champions.common.affix.core.AffixBase;
import c4.champions.common.affix.core.AffixCategory;
import c4.champions.common.affix.core.AffixNBT;
import c4.champions.common.capability.IChampionship;
import c4.champions.common.config.ConfigHandler;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;

public class AffixAdaptable
extends AffixBase {
    public AffixAdaptable() {
        super("adaptable", AffixCategory.DEFENSE);
    }

    @Override
    public float onHurt(EntityLiving entity, IChampionship cap, DamageSource source, float amount, float newAmount) {
        String type = source.func_76355_l();
        DamageType damageType = AffixNBT.getData(cap, this.getIdentifier(), DamageType.class);
        if (damageType.name.equalsIgnoreCase(type)) {
            newAmount = (float)((double)newAmount - (double)amount * ConfigHandler.affix.adaptable.damageReductionIncrement * (double)damageType.count);
            ++damageType.count;
        } else {
            damageType.name = type;
            damageType.count = 0;
        }
        damageType.saveData(entity);
        return Math.max(amount * (float)(1.0 - ConfigHandler.affix.adaptable.maxDamageReduction), newAmount);
    }

    public static class DamageType
    extends AffixNBT {
        String name;
        int count;

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            this.name = tag.func_74779_i("name");
            this.count = tag.func_74762_e("count");
        }

        @Override
        public NBTTagCompound writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("name", this.name);
            compound.func_74768_a("count", this.count);
            return compound;
        }
    }
}

