/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.common.rank;

import c4.champions.Champions;
import c4.champions.common.rank.Rank;
import c4.champions.common.util.JsonUtil;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.potion.Potion;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Level;

public class RankManager {
    private static final Rank[] DEFAULT_RANKS = new Rank[]{new Rank(1, 1, 1, 0.05f, 0xFFFF00, new String[0]), new Rank(2, 2, 4, 0.2f, 0xFF9900, new String[0]), new Rank(3, 3, 9, 0.2f, 0x66FFFF, new String[0]), new Rank(4, 4, 16, 0.2f, 0xCC33FF, new String[0])};
    private static final Rank EMPTY_RANK = new Rank();
    private static final TreeMap<Integer, Rank> RANKS = Maps.newTreeMap();
    private static final TreeMap<Integer, List<Tuple<Potion, Integer>>> RANK_POTIONS = Maps.newTreeMap();

    public static ImmutableSortedMap<Integer, Rank> getRanks() {
        return ImmutableSortedMap.copyOf(RANKS);
    }

    @Nonnull
    public static Rank getRankForTier(int tier) {
        Rank rank;
        Rank rank2 = rank = tier > 0 ? RANKS.get(tier) : EMPTY_RANK;
        if (rank == null) {
            Champions.logger.log(Level.ERROR, "Tried getting rank from tier " + tier + " but rank does not exist! Returning empty rank.");
            return EMPTY_RANK;
        }
        return rank;
    }

    @Nullable
    public static List<Tuple<Potion, Integer>> getPotionsForTier(int tier) {
        List<Tuple<Potion, Integer>> potions = RANK_POTIONS.get(tier);
        return potions == null ? null : Collections.unmodifiableList(potions);
    }

    public static Rank getEmptyRank() {
        return EMPTY_RANK;
    }

    public static void readRanksFromJson() {
        Rank[] ranks;
        for (Rank rank : ranks = JsonUtil.fromJson((TypeToken<T[]>)TypeToken.get(Rank[].class), new File(Loader.instance().getConfigDir(), "champions/ranks.json"), DEFAULT_RANKS)) {
            RANKS.put(rank.getTier(), rank);
            if (rank.getPotions().length <= 0) continue;
            ArrayList<Tuple> potions = new ArrayList<Tuple>();
            for (String s : rank.getPotions()) {
                String[] args = s.split(";");
                int amplifier = args.length > 1 ? Math.max(Integer.parseInt(args[1]), 0) : 0;
                Potion potion = Potion.func_180142_b((String)args[0]);
                if (potion == null) continue;
                potions.add(new Tuple((Object)potion, (Object)amplifier));
            }
            if (potions.isEmpty()) continue;
            RANK_POTIONS.put(rank.getTier(), potions);
        }
    }
}

