/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.event;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.oblivioussp.spartanshields.item.ItemShieldBase;
import com.oblivioussp.spartanshields.network.NetworkHandler;
import com.oblivioussp.spartanshields.network.PacketShieldBash;
import com.oblivioussp.spartanshields.util.ConfigHandler;
import com.oblivioussp.spartanshields.util.LogHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class EventHandlerClient {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onInputEvent(InputEvent ev) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack mainHand = player.func_184614_ca();
        ItemStack offHand = player.func_184592_cb();
        ItemStack shieldStack = ItemStack.field_190927_a;
        if (!ConfigHandler.disableShieldBash && player.func_184585_cz() && mc.field_71474_y.field_74312_F.func_151468_f()) {
            EnumHand shieldHand = null;
            if (mainHand.func_77973_b() instanceof ItemShieldBase) {
                shieldStack = mainHand;
                shieldHand = EnumHand.MAIN_HAND;
            } else if (offHand.func_77973_b() instanceof ItemShieldBase) {
                shieldStack = offHand;
                shieldHand = EnumHand.OFF_HAND;
            }
            if (shieldStack.func_190926_b() || shieldHand == null) {
                return;
            }
            if (player.func_184811_cZ().func_185141_a(shieldStack.func_77973_b())) {
                return;
            }
            RayTraceResult result = EventHandlerClient.getMouseOverExtended(4.0f);
            if (result != null) {
                int entId = -1;
                boolean attackEntity = true;
                if (result.field_72308_g != null && result.field_72308_g != player) {
                    LogHelper.debug("Hit Entity with Shield Bash! - " + result.field_72308_g.toString());
                    entId = result.field_72308_g.func_145782_y();
                }
                if (entId == -1) {
                    entId = 0;
                    attackEntity = false;
                }
                player.func_184609_a(shieldHand);
                NetworkHandler.sendPacketToServer(new PacketShieldBash(shieldHand, entId, attackEntity));
            }
        }
    }

    protected static RayTraceResult getMouseOverExtended(float distance) {
        RayTraceResult result = null;
        Minecraft mc = Minecraft.func_71410_x();
        Entity renderViewEntity = mc.func_175606_aa();
        if (renderViewEntity != null && mc.field_71441_e != null) {
            double d0 = distance;
            result = renderViewEntity.func_174822_a(d0, 0.0f);
            Vec3d eyePos = renderViewEntity.func_174824_e(0.0f);
            boolean flag = false;
            double d1 = d0;
            if (mc.field_71442_b.func_78749_i() && d1 < 6.0) {
                d0 = d1 = 6.0;
            } else if (d0 > (double)distance) {
                flag = true;
            }
            if (result != null) {
                d1 = result.field_72307_f.func_72438_d(eyePos);
            }
            Vec3d lookVec = renderViewEntity.func_70676_i(0.0f);
            Vec3d vec3d2 = eyePos.func_72441_c(lookVec.field_72450_a * d0, lookVec.field_72448_b * d0, lookVec.field_72449_c * d0);
            Entity pointedEntity = null;
            Vec3d vec3d3 = null;
            List list = mc.field_71441_e.func_175674_a(renderViewEntity, renderViewEntity.func_174813_aQ().func_72321_a(lookVec.field_72450_a * d0, lookVec.field_72448_b * d0, lookVec.field_72449_c * d0).func_72321_a(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    return p_apply_1_ != null && p_apply_1_.func_70067_L();
                }
            }));
            double d2 = d1;
            for (int j = 0; j < list.size(); ++j) {
                double d3;
                Entity entity1 = (Entity)list.get(j);
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
                RayTraceResult result0 = axisalignedbb.func_72327_a(eyePos, vec3d2);
                if (axisalignedbb.func_72318_a(eyePos)) {
                    if (!(d2 >= 0.0)) continue;
                    pointedEntity = entity1;
                    vec3d3 = result0 == null ? eyePos : result0.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (result0 == null || !((d3 = eyePos.func_72438_d(result0.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity1.func_184208_bv() == renderViewEntity.func_184208_bv() && !renderViewEntity.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    pointedEntity = entity1;
                    vec3d3 = result0.field_72307_f;
                    continue;
                }
                pointedEntity = entity1;
                vec3d3 = result0.field_72307_f;
                d2 = d3;
            }
            if (pointedEntity != null && flag && eyePos.func_72438_d(vec3d3) > (double)distance) {
                pointedEntity = null;
                result = new RayTraceResult(RayTraceResult.Type.MISS, vec3d3, (EnumFacing)null, new BlockPos(vec3d3));
                LogHelper.debug("Ray Trace for extended reach has missed!");
            }
            if (pointedEntity != null && (d2 < d1 || result == null)) {
                result = new RayTraceResult(pointedEntity, vec3d3);
                LogHelper.debug("Ray Trace for extended reach has hit a " + pointedEntity.toString() + " d1 = " + d1 + " - d2 = " + d2);
                if (pointedEntity instanceof EntityLivingBase || pointedEntity instanceof EntityItemFrame) {
                    // empty if block
                }
            }
        }
        return result;
    }
}

