/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.util;

import net.minecraft.util.text.translation.I18n;

public class StringHelper {
    public static String getItemUnlocalizedName(String locName) {
        return StringHelper.getItemUnlocalizedName(locName, "spartanshields");
    }

    public static String getItemUnlocalizedName(String locName, String modId) {
        return String.format("item.%s:%s", modId.toLowerCase(), StringHelper.stripUnlocalizedName(locName));
    }

    public static String getBlockUnlocalizedName(String locName) {
        return StringHelper.getBlockUnlocalizedName(locName, "spartanshields");
    }

    public static String getBlockUnlocalizedName(String locName, String modId) {
        return String.format("tile.%s:%s", modId.toLowerCase(), StringHelper.stripUnlocalizedName(locName));
    }

    public static String stripUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    public static String translateString(String unlocalizedStr, String type) {
        return StringHelper.translateString(unlocalizedStr, type, "spartanshields");
    }

    public static String translateString(String unlocalizedStr, String type, String modIdStr) {
        String modId = modIdStr;
        if (modId == null || modId == "") {
            modId = "spartanshields";
        }
        if (type == null || type == "") {
            return I18n.func_74837_a((String)(modId.toLowerCase() + ":" + unlocalizedStr), (Object[])new Object[0]);
        }
        return I18n.func_74837_a((String)String.format("%s.%s:%s", type, modId.toLowerCase(), unlocalizedStr), (Object[])new Object[0]);
    }

    public static String translateFormattedString(String unlocalizedStr, String type, Object ... parameters) {
        return StringHelper.translateFormattedString(unlocalizedStr, type, "spartanshields", parameters);
    }

    public static String translateFormattedString(String unlocalizedStr, String type, String modIdStr, Object ... parameters) {
        String modId = modIdStr;
        if (modId == null || modId == "") {
            modId = "spartanshields";
        }
        if (type == null || type == "") {
            return I18n.func_74837_a((String)(modId.toLowerCase() + ":" + unlocalizedStr), (Object[])parameters);
        }
        return I18n.func_74837_a((String)String.format("%s.%s:%s", type, modId.toLowerCase(), unlocalizedStr), (Object[])parameters);
    }

    public static boolean hasTranslateKey(String key, String type) {
        return StringHelper.hasTranslateKey(key, type, "spartanshields");
    }

    public static boolean hasTranslateKey(String key, String type, String modId) {
        if (type == null || type == "") {
            return I18n.func_94522_b((String)("spartanshields".toLowerCase() + ":" + key));
        }
        return I18n.func_94522_b((String)String.format("%s.%s:%s", type, modId.toLowerCase(), key));
    }
}

