/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.api.tile;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.UsernameCache;
import omtteam.omlib.api.permission.GlobalTrustRegister;
import omtteam.omlib.api.permission.IHasOwner;
import omtteam.omlib.api.permission.ITrustedPlayersManager;
import omtteam.omlib.api.permission.TrustedPlayer;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.DebugHandler;
import omtteam.omlib.util.GeneralUtil;
import omtteam.omlib.util.player.Player;
import omtteam.omlib.util.player.PlayerUtil;

public class TrustedPlayersManagerTile
implements ITrustedPlayersManager {
    protected final TileEntityOwnedBlock ownedBlock;
    protected List<TrustedPlayer> trustedPlayers = new ArrayList<TrustedPlayer>();
    protected boolean useGlobal = false;

    public TrustedPlayersManagerTile(TileEntityOwnedBlock ownedBlock) {
        this.ownedBlock = ownedBlock;
    }

    @Override
    public Player getOwner() {
        return this.ownedBlock.getOwner();
    }

    @Override
    @ParametersAreNonnullByDefault
    public boolean addTrustedPlayer(String name) {
        TrustedPlayer trustedPlayer = new TrustedPlayer(name);
        trustedPlayer.setUuid(PlayerUtil.getPlayerUUID(name));
        if (!this.ownedBlock.func_145831_w().field_72995_K) {
            Player player = null;
            boolean foundPlayer = false;
            for (Map.Entry serverName : UsernameCache.getMap().entrySet()) {
                if (!name.equals(serverName.getValue())) continue;
                player = new Player((UUID)serverName.getKey(), (String)serverName.getValue());
                foundPlayer = true;
                break;
            }
            if (!foundPlayer) {
                player = new Player(null, name);
            }
            if (!foundPlayer && GeneralUtil.isServerInOnlineMode()) {
                DebugHandler.getInstance().sendMessageToDebugChat("Did not find player named " + name + "in the username cache.");
                return false;
            }
            if (!GeneralUtil.isServerInOnlineMode()) {
                if (PlayerUtil.isPlayerOwner(player, (IHasOwner)this.ownedBlock)) {
                    DebugHandler.getInstance().sendMessageToDebugChat("You cannot add an owner!");
                    return false;
                }
            } else if (trustedPlayer.getUuid() == null || PlayerUtil.isPlayerOwner(player, (IHasOwner)this.ownedBlock)) {
                DebugHandler.getInstance().sendMessageToDebugChat("You cannot add an owner!");
                return false;
            }
            if (trustedPlayer.getUuid() != null || !GeneralUtil.isServerInOnlineMode()) {
                for (TrustedPlayer existPlayer : this.trustedPlayers) {
                    if (!GeneralUtil.isServerInOnlineMode()) {
                        if (!existPlayer.getName().equalsIgnoreCase(name)) continue;
                        DebugHandler.getInstance().sendMessageToDebugChat("Already on trust list!");
                        return false;
                    }
                    if (!existPlayer.getName().equalsIgnoreCase(name) && !trustedPlayer.getUuid().equals(existPlayer.getUuid())) continue;
                    return false;
                }
                DebugHandler.getInstance().sendMessageToDebugChat("Sucessfully added " + name + ".");
                this.trustedPlayers.add(trustedPlayer);
                return true;
            }
        }
        return false;
    }

    @Override
    public TrustedPlayer getTrustedPlayer(String name) {
        if (this.useGlobal) {
            return GlobalTrustRegister.instance.getTrustedPlayer(this.ownedBlock.getOwner(), name);
        }
        return ITrustedPlayersManager.super.getTrustedPlayer(name);
    }

    @Override
    public TrustedPlayer getTrustedPlayer(UUID uuid) {
        if (this.useGlobal) {
            return GlobalTrustRegister.instance.getTrustedPlayer(this.ownedBlock.getOwner(), uuid);
        }
        return ITrustedPlayersManager.super.getTrustedPlayer(uuid);
    }

    @Override
    public TrustedPlayer getTrustedPlayer(Player player) {
        if (this.useGlobal) {
            return GlobalTrustRegister.instance.getTrustedPlayer(this.ownedBlock.getOwner(), player);
        }
        return ITrustedPlayersManager.super.getTrustedPlayer(player);
    }

    @Override
    public boolean useGlobal() {
        return this.useGlobal;
    }

    @Override
    public void setUseGlobal(boolean useGlobal) {
        this.useGlobal = useGlobal;
    }

    @Override
    public List<TrustedPlayer> getTrustedPlayers() {
        return this.trustedPlayers;
    }

    @Override
    public void setTrustedPlayers(List<TrustedPlayer> trustedPlayers) {
        this.trustedPlayers = trustedPlayers;
    }

    @Override
    public boolean hasTile() {
        return true;
    }

    @Override
    public TileEntity getTile() {
        return this.ownedBlock;
    }
}

