/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBrownLargeMushroom
extends Block {
    private static final EnumShape[] SHAPES = EnumShape.values();
    public static final PropertyEnum<EnumShape> SHAPE = PropertyEnum.func_177709_a((String)"shape", EnumShape.class);
    private static final AxisAlignedBB BOTTOM_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB TOP_CENTER_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB TOP_SIDE_AABB = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);

    public BlockBrownLargeMushroom() {
        super(Material.field_151575_d, MapColor.field_193573_Y);
        this.setRegistryName("brown_large_mushroom");
        this.func_149663_c("brown_large_mushroom");
        this.func_149711_c(0.25f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SHAPE, (Comparable)((Object)EnumShape.BOTTOM)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SHAPE, (Comparable)((Object)SHAPES[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumShape)((Object)state.func_177229_b(SHAPE))).getIndex();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SHAPE});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(SHAPE) == EnumShape.TOP) {
            return TOP_CENTER_AABB;
        }
        if (((EnumShape)((Object)state.func_177229_b(SHAPE))).name.contains("side") || ((EnumShape)((Object)state.func_177229_b(SHAPE))).name.contains("corner")) {
            return TOP_SIDE_AABB;
        }
        return BOTTOM_AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (state.func_177229_b(SHAPE) == EnumShape.TOP || ((EnumShape)((Object)state.func_177229_b(SHAPE))).name.contains("side") || ((EnumShape)((Object)state.func_177229_b(SHAPE))).name.contains("corner")) {
            if (face == EnumFacing.UP) {
                return BlockFaceShape.SOLID;
            }
            return BlockFaceShape.UNDEFINED;
        }
        if (face == EnumFacing.DOWN || face == EnumFacing.UP) {
            return BlockFaceShape.MIDDLE_POLE;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150338_P);
    }

    public int func_149745_a(Random random) {
        return random.nextInt(3);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)Blocks.field_150338_P);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public static enum EnumShape implements IStringSerializable
    {
        TOP("top"),
        SIDE_N("side_n"),
        SIDE_S("side_s"),
        SIDE_E("side_e"),
        SIDE_W("side_w"),
        CORNER_N("corner_n"),
        CORNER_S("corner_s"),
        CORNER_E("corner_e"),
        CORNER_W("corner_w"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;
        private final int index;

        private EnumShape(String name) {
            this.name = name;
            this.index = this.ordinal();
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

