/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.commands;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import paulevs.betternether.world.BNWorldGenerator;

public class CommandFindCity
extends CommandBase {
    public String func_71517_b() {
        return "findNetherCity";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/findNetherCity or /findNetherCity x y z";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        BlockPos pos = null;
        if (args.length == 0) {
            if (!(sender instanceof EntityPlayer)) {
                this.sendMessage("commands.findnethercity.usage.console", sender);
                return;
            }
            pos = BNWorldGenerator.getNearestCity(sender.func_130014_f_(), sender.func_180425_c().func_177958_n() >> 4, sender.func_180425_c().func_177952_p() >> 4);
        } else {
            if (args.length != 3) {
                this.sendMessage("commands.findnethercity.usage", sender);
                return;
            }
            try {
                double posX = Double.parseDouble(args[0]);
                double posZ = Double.parseDouble(args[2]);
                pos = BNWorldGenerator.getNearestCity(sender.func_130014_f_(), (int)posX >> 4, (int)posZ >> 4);
            }
            catch (NumberFormatException e) {
                this.sendMessage("commands.findnethercity.usage.coordinates", sender);
                return;
            }
        }
        this.sendResult(String.format("%d %d %d", pos.func_177958_n() << 4, 40, pos.func_177952_p() << 4), sender);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        ArrayList<String> tabs = new ArrayList<String>();
        if (sender instanceof EntityPlayer) {
            if (args.length == 1) {
                tabs.add(Double.toString(sender.func_180425_c().func_177958_n()));
            } else if (args.length == 2) {
                tabs.add(Double.toString(sender.func_180425_c().func_177956_o()));
            } else if (args.length == 3) {
                tabs.add(Double.toString(sender.func_180425_c().func_177952_p()));
            }
        }
        return tabs;
    }

    private void sendMessage(String message, ICommandSender sender) {
        TextComponentTranslation text = new TextComponentTranslation(message, new Object[0]);
        text.func_150256_b().func_150238_a(TextFormatting.RED);
        sender.func_145747_a((ITextComponent)text);
    }

    private void sendResult(String message, ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(message));
    }
}

