/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.big;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import paulevs.betternether.structures.big.BigStructure;

public abstract class StructureManager {
    private static final long RANDOM_D = 132897987541L;
    private static final long RANDOM_C = 341873128712L;
    private static final long RANDOM_B = 132897987541L;
    private static final long RANDOM_A = 341873128712L;
    protected ArrayList<BigStructure> structures = new ArrayList();
    protected ArrayList<BigStructure> toRemove = new ArrayList();
    protected Random random = new Random();
    protected int distance;
    protected int variance;
    protected long seed;
    protected String name;

    public StructureManager(String name, int distance, long seed) {
        this.seed = seed;
        this.name = name;
        this.setDistance(distance);
    }

    public void setDistance(int distance) {
        this.distance = distance;
        this.variance = distance / 3;
    }

    protected void makeStructure(World world, int cx, int cz) {
        BlockPos nearest = this.getNearestStructure(world, cx, cz);
        if (!this.hasStructure(world, nearest.func_177958_n(), nearest.func_177952_p(), cx, cz)) {
            this.setSeed(nearest.func_177958_n(), nearest.func_177952_p(), world.func_72905_C());
            this.structures.add(this.makeStructure(nearest.func_177958_n(), nearest.func_177952_p()));
        }
    }

    protected abstract BigStructure makeStructure(int var1, int var2);

    protected boolean hasStructure(World world, int cx, int cz, int sourceX, int sourceZ) {
        for (BigStructure s : this.structures) {
            if (s.cx != cx || s.cz != cz) continue;
            return true;
        }
        if (sourceX == cx && sourceZ == cz) {
            return false;
        }
        return world.func_190526_b(cx, cz);
    }

    public BlockPos getNearestStructure(World world, int cx, int cz) {
        int fx = cx / this.distance;
        int fz = cz / this.distance;
        this.setSeed(fx, fz, world.func_72905_C());
        return new BlockPos(fx * this.distance + this.random.nextInt(this.variance) + this.variance, 0, fz * this.distance + this.random.nextInt(this.variance) + this.variance);
    }

    protected void placeStructures(World world, int cx, int cz) {
        for (BigStructure structure : this.structures) {
            if (structure.generationComplete() && !this.toRemove.contains(this.toRemove)) {
                this.toRemove.add(structure);
                continue;
            }
            structure.setChunk(world, cx, cz);
        }
        this.structures.removeAll(this.toRemove);
        this.toRemove.clear();
    }

    private void setSeed(int cx, int cz, long worldSeed) {
        long rseed = (long)cx * 341873128712L + (long)cz * 132897987541L + worldSeed + this.seed;
        this.random.setSeed(rseed);
    }

    protected void setSeed(int cx, int cz) {
        this.random.setSeed((long)cx * 341873128712L + (long)cz * 132897987541L);
    }

    protected NBTTagCompound toNBT() {
        NBTTagCompound root = new NBTTagCompound();
        NBTTagList structureData = new NBTTagList();
        root.func_74782_a("structures", (NBTBase)structureData);
        for (BigStructure s : this.structures) {
            structureData.func_74742_a((NBTBase)s.toNBT());
        }
        return root;
    }

    public void save(World world) {
        String path = world.func_72860_G().func_75765_b().getAbsolutePath() + "/data/bn_" + this.name + ".nbt";
        try {
            FileOutputStream fs = new FileOutputStream(new File(path));
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.toNBT(), (OutputStream)fs);
            fs.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load(World world) {
        String path = world.func_72860_G().func_75765_b().getAbsolutePath() + "/data/bn_" + this.name + ".nbt";
        File file = new File(path);
        if (file.exists()) {
            try {
                FileInputStream fs = new FileInputStream(file);
                NBTTagCompound root = CompressedStreamTools.func_74796_a((InputStream)fs);
                fs.close();
                NBTTagList structureData = root.func_150295_c("structures", 10);
                for (int i = 0; i < structureData.func_74745_c(); ++i) {
                    this.structures.add(new BigStructure(structureData.func_150305_b(i)));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void generate(World world, int cx, int cz) {
        this.makeStructure(world, cx, cz);
        this.placeStructures(world, cx, cz);
    }
}

