/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.city;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import paulevs.betternether.structures.city.StructureCityBuilding;

public class BuildingInfo {
    public StructureCityBuilding building;
    public BlockPos pos;

    public BuildingInfo(StructureCityBuilding building, BlockPos pos) {
        this.building = building;
        this.pos = pos;
    }

    public BuildingInfo(NBTTagCompound root, List<StructureCityBuilding> buildings) {
        int[] prePos = root.func_74759_k("pos");
        int preRot = root.func_74762_e("rotation");
        String name = root.func_74779_i("name");
        this.pos = new BlockPos(prePos[0], prePos[1], prePos[2]);
        Rotation rot = Rotation.values()[preRot];
        for (StructureCityBuilding b : buildings) {
            if (b.getName() != name || b.getRotation() != rot) continue;
            this.building = b;
            return;
        }
        if (this.building == null) {
            this.building = new StructureCityBuilding(name).getRotated(rot);
        }
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound root = new NBTTagCompound();
        root.func_74783_a("pos", new int[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()});
        root.func_74778_a("name", this.building.getName());
        root.func_74768_a("rotation", this.building.getRotation().ordinal());
        return root;
    }
}

