/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.armorunder;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.jwaresoftware.mcmods.armorunder.ModInfo;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.api.mod.IModInfo;
import org.jwaresoftware.mcmods.lib.impl.ModConfigBase;

public final class ModConfig
extends ModConfigBase {
    static final String _GENERAL = "General";
    static final String _INTEGRATION = "Integration";
    private static ModConfig _sharedINSTANCE = new ModConfig();
    private CreativeTabs _ourTab;

    public ModConfig() {
    }

    public ModConfig(FMLPreInitializationEvent event) {
        super((IModInfo)ModInfo.getInstance(), event);
    }

    public ModConfig setInstance() {
        _sharedINSTANCE = this;
        return this;
    }

    public static final ModConfig getInstance() {
        return _sharedINSTANCE;
    }

    public boolean useModTab() {
        String PROPERTY = "use_custom_tab";
        Boolean b = (Boolean)this._cache.get("Generaluse_custom_tab");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "use_custom_tab", true, "Set to true to force all mod items and blocks to a single custom tab in creative views. Enabled by default.");
        p.setLanguageKey("armorunder.configui.use_custom_tab");
        b = p.getBoolean();
        this._cache.put("Generaluse_custom_tab", b);
        return b;
    }

    public CreativeTabs getTab() {
        return this._ourTab;
    }

    public void setTab(CreativeTabs tab) {
        this._ourTab = tab;
        this._cache.put("pinklyTab", tab);
    }

    public final boolean isAllowed(@Nonnull String option, boolean defaultValue) {
        if ("special_sets".equals(option)) {
            return this.includeSpecialLiners();
        }
        if ("craft_smart_lining".equals(option)) {
            return this.allowSpecialLinerCrafting(defaultValue) && this.includeSpecialLiners();
        }
        if ("loot_tables".equals(option)) {
            return this.allowLootTableEnrichment();
        }
        if ("portable_paks".equals(option)) {
            return this.includePortablePaks();
        }
        return super.isAllowed(option, defaultValue);
    }

    public final boolean isDebugMode() {
        String PROPERTY = "debug_mode";
        Boolean b = (Boolean)this._cache.get("Generaldebug_mode");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "debug_mode", false, "INTERNAL. Development messages enabled.");
        p.setLanguageKey("armorunder.configui.debug_mode");
        b = p.getBoolean();
        this._cache.put("Generaldebug_mode", b);
        return b;
    }

    public boolean isSuperCompatibilityMode() {
        String PROPERTY = "super_compatibility_mode";
        Boolean b = (Boolean)this._cache.get("Generalsuper_compatibility_mode");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "super_compatibility_mode", true, "Set to true to force all the basic recipes to use a mod-specific element to ensure no collisions with other mod recipes. If turned ON you cannot use TAN armor as liners directly. Off by default; requires restart if changed in-game.");
        p.setLanguageKey("armorunder.configui.super_compatibility_mode");
        b = p.getBoolean();
        this._cache.put("Generalsuper_compatibility_mode", b);
        return b;
    }

    public boolean allowLootTableEnrichment() {
        String PROPERTY = "enrich_loot_tables";
        Boolean b = (Boolean)this._cache.get("Generalenrich_loot_tables");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "enrich_loot_tables", true, "Set to false to disable all mod-specific additions to vanilla structure and activity loot tables. Loot is the only way to obtain the custom liners like the Ozzys and Ollies. Enabled by default; requires restart if changed in-game.");
        p.setLanguageKey("armorunder.configui.enrich_loot_tables");
        b = p.getBoolean();
        this._cache.put("Generalenrich_loot_tables", b);
        return b;
    }

    public boolean includePortablePaks() {
        String PROPERTY = "include_goopaks";
        Boolean b = (Boolean)this._cache.get("Generalinclude_goopaks");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "include_goopaks", true, "Set to false to disable the portable 'goo paks' that you carry in your hotbar. Paks are a useful supplement to regular armor liners in extreme environments. Included by default; requires restart if changed in-game.");
        p.setLanguageKey("armorunder.configui.include_goopaks");
        b = p.getBoolean();
        this._cache.put("Generalinclude_goopaks", b);
        return b;
    }

    public boolean includeSpecialLiners() {
        String PROPERTY = "include_special_liners";
        Boolean b = (Boolean)this._cache.get("Generalinclude_special_liners");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "include_special_liners", false, "Set to true to enable special liners including their damage mitigation features. These items are available only as loot rewards in the standalone mod. Disabled by default; requires restart if changed in-game.");
        p.setLanguageKey("armorunder.configui.include_special_liners");
        b = p.getBoolean();
        this._cache.put("Generalinclude_special_liners", b);
        return b;
    }

    public boolean allowSpecialLinerCrafting(boolean default_value) {
        return ModConfig._getBooleanOrDefault((String)this._allowSpecialLinerCrafting(), (boolean)default_value);
    }

    private String _allowSpecialLinerCrafting() {
        String PROPERTY = "special_liners_craftable";
        String s = (String)this._cache.get("Generalspecial_liners_craftable");
        if (s != null) {
            return s;
        }
        s = this.forgeConfig().getString("special_liners_craftable", _GENERAL, "*DEFAULT*", "Set to true to include crafting recipes for items that are normally obtained through other mechanisms like looting or advancements. By default, only the ToughAsNails temperature-related 'Ozzy' liners are craftable.", Strings.__DEFAULT_VAL_SETTINGS(), "armorunder.configui.special_liners_craftable");
        this._cache.put("Generalspecial_liners_craftable", s);
        return s;
    }

    @Nonnull
    public Map<String, Item[]> getUnderwearReadyArmorAll() {
        String PROPERTY = "armor";
        HashMap<String, Item[]> values = (HashMap<String, Item[]>)this._cache.get("Integrationarmor");
        if (values != null) {
            return values;
        }
        values = new HashMap<String, Item[]>();
        values.put("itemBoots", this.getLiningCapableArmor(false, "boots", "boots", new String[0]));
        values.put("itemChestplate", this.getLiningCapableArmor(false, "chestplate", "chestplates", new String[0]));
        values.put("itemHelmet", this.getLiningCapableArmor(false, "helmet", "helmets", new String[0]));
        values.put("itemLeggings", this.getLiningCapableArmor(false, "leggings", "leggings", new String[0]));
        this._cache.put("Integrationarmor", values);
        return values;
    }

    private void defineUnderwearReadyArmorSection() {
        String armorCategory = _INTEGRATION.toLowerCase(Locale.US);
        ConfigCategory c = this.forgeConfig().getCategory(armorCategory);
        c.setComment("Armor that can be lined in addition to vanilla armor pieces. Requires restart if changed.");
        c.setLanguageKey("armorunder.configui.armor");
        this.getLiningCapableArmor(true, "boots", "boots", new String[]{"basemetals:coldiron_boots", "cyclicmagic:purple_boots"});
        this.getLiningCapableArmor(true, "chestplate", "chestplates", new String[]{"basemetals:coldiron_chestplate", "cyclicmagic:purple_chestplate"});
        this.getLiningCapableArmor(true, "helmet", "helmets", new String[]{"basemetals:coldiron_helmet", "cyclicmagic:purple_helmet"});
        this.getLiningCapableArmor(true, "leggings", "leggings", new String[]{"basemetals:coldiron_leggings", "cyclicmagic:purple_leggings"});
    }

    private Item[] getLiningCapableArmor(boolean define_only, String sub_category, String description, String[] defaults) {
        String PROPERTY = sub_category;
        Item[] values = (Item[])this._cache.get(_INTEGRATION + PROPERTY);
        if (!define_only && values != null) {
            return values;
        }
        String[] ids = this.forgeConfig().getStringList(PROPERTY, _INTEGRATION, defaults, "Set to the full IDs of all modded " + description + " that can be worn over lining up to 3 layers thick (actual max thickness depends on armor piece). Some examples shown. Requires a restart if changed in-game.", (String[])null, "armorunder.configui." + PROPERTY);
        if (define_only) {
            return null;
        }
        values = new Item[ids.length];
        int i = 0;
        for (String id : ids) {
            values[i] = null;
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(id));
            if (item instanceof ItemArmor) {
                values[i] = item;
            }
            ++i;
        }
        this._cache.put(_INTEGRATION + PROPERTY, values);
        return values;
    }

    public int getLiningThicknessLimit() {
        String PROPERTY = "thickness_limit";
        Integer n = (Integer)this._cache.get("Generalthickness_limit");
        if (n != null) {
            return n;
        }
        Property p = this.forgeConfig().get(_GENERAL, "thickness_limit", 3, "Set to the maximum number of plain liners a single piece of armor can have. Applies to all types of armor pieces (helmets, chestplates, leggings, boots). Does not apply to special types of liners.", 1, 3);
        p.setLanguageKey("armorunder.configui.thickness_limit");
        n = MathHelper.func_76125_a((int)p.getInt(), (int)1, (int)3);
        this._cache.put("Generalthickness_limit", n);
        return n;
    }

    protected void fullyDefine() {
        this.useModTab();
        this.isDebugMode();
        this.isSuperCompatibilityMode();
        this.allowLootTableEnrichment();
        this.getLiningThicknessLimit();
        this.defineUnderwearReadyArmorSection();
        this.includePortablePaks();
        this.includeSpecialLiners();
        this._allowSpecialLinerCrafting();
    }
}

