/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.magistuarmory.event.ClientEvent;
import com.magistuarmory.item.MedievalWeaponItem;
import com.magistuarmory.network.PacketHandler;
import com.magistuarmory.network.PacketLanceCollision;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LanceItem
extends MedievalWeaponItem {
    public boolean attacking = false;
    public double velocityProjection = 0.0;
    private int ticksLastUpdtate = 20;
    public int strength = 0;
    private int clickedTicks = 0;

    public LanceItem(String unlocName, Item.ToolMaterial material, float baseAttackDamage, float materialFactor, float baseAttackSpeed, int armorPiercing, float reachDistance) {
        super(unlocName, material, baseAttackDamage, materialFactor, baseAttackSpeed, armorPiercing, reachDistance);
        this.func_185043_a(new ResourceLocation("magistuarmory", "raised"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return LanceItem.this.isRaised(entityIn) ? 1.0f : 0.0f;
            }
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return false;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        this.setRaised((EntityLivingBase)playerIn, !this.isRaised((EntityLivingBase)playerIn));
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    @Override
    public void func_77663_a(ItemStack par1ItemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity != null && entity instanceof EntityPlayer) {
            RayTraceResult result;
            EntityPlayer player = (EntityPlayer)entity;
            if (FMLLaunchHandler.side() == Side.CLIENT && player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof LanceItem && (result = ClientEvent.getMouseOver(this.getReachDistance())) != null && result.field_72308_g != null) {
                Entity aim = result.field_72308_g;
                if (player.func_184218_aH() && aim instanceof EntityLivingBase && !aim.field_70128_L && aim.func_145782_y() != player.func_184187_bx().func_145782_y()) {
                    this.collide((EntityLivingBase)aim, player, world);
                }
            }
            if (this.clickedTicks > 0) {
                --this.clickedTicks;
            }
            if (!this.isRaised((EntityLivingBase)player) && player.func_184811_cZ().func_185141_a((Item)this)) {
                this.setRaised((EntityLivingBase)player, true);
            }
        }
        super.func_77663_a(par1ItemStack, world, entity, par4, par5);
    }

    public void collide(EntityLivingBase victim, EntityPlayer player, World world) {
        if (player == null) {
            return;
        }
        if (world == null) {
            return;
        }
        if (!this.isRaised((EntityLivingBase)player) && !player.func_184811_cZ().func_185141_a((Item)this)) {
            int bonusDamage = (int)this.calcBonusDamage((Entity)player, this.velocityProjection);
            if (player.func_184218_aH()) {
                this.velocityProjection = this.getVelocityProjection((Entity)player, (Entity)victim);
                if (this.velocityProjection > 0.233) {
                    PacketHandler.sendPacketToServer(new PacketLanceCollision(victim.func_145782_y(), bonusDamage));
                }
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (this.attacking) {
            Vec3d vec = player.func_70676_i(1.0f);
            double b = Math.sqrt(Math.max(0.0, this.velocityProjection) / Math.max(0.5, vec.func_72433_c() * this.getSummaryMass(entity))) / 5.0;
            if (entity.func_184218_aH()) {
                entity.func_184187_bx().field_70159_w += vec.field_72450_a * b;
                entity.func_184187_bx().field_70181_x += vec.field_72448_b * b;
                entity.func_184187_bx().field_70179_y += vec.field_72449_c * b;
                double d = this.clickedTicks > 0 ? 0.3 : 0.0;
                if ((d + 0.6 + 0.2 * entity.func_174813_aQ().func_189972_c().func_178788_d(player.func_174824_e(1.0f).func_178787_e(player.func_70676_i(this.getReachDistance()))).func_72430_b(vec) / vec.func_72433_c()) * Math.random() > 1.0) {
                    entity.func_184210_p();
                }
            } else {
                entity.field_70159_w += vec.field_72450_a * b;
                entity.field_70181_x += vec.field_72448_b * b;
                entity.field_70179_y += vec.field_72449_c * b;
            }
            return false;
        }
        if (!this.isRaised((EntityLivingBase)player) && !player.func_184811_cZ().func_185141_a((Item)this)) {
            this.clickedTicks = 15;
        }
        return true;
    }

    @Override
    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return true;
    }

    public double calcBonusDamage(Entity player, double velocityProjection) {
        double bonusDamage = 0.0;
        bonusDamage = 5.0 * this.getSummaryMass(player) * velocityProjection;
        return Math.max(0.0, bonusDamage);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Rider only");
        tooltip.add("Left-click before hitting to dismount target");
        tooltip.add("+bonus damage based on mass and speed");
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    double getVelocityProjection(Entity entity1, Entity entity2) {
        Vec3d velocity = entity1.func_184218_aH() ? new Vec3d(entity1.func_184187_bx().field_70159_w, entity1.func_184187_bx().field_70181_x, entity1.func_184187_bx().field_70179_y) : new Vec3d(entity1.field_70159_w, entity1.field_70181_x, entity1.field_70179_y);
        Vec3d vec = entity1.func_70676_i(1.0f);
        if (vec.func_189985_c() == 0.0) {
            return 0.0;
        }
        return velocity.func_72430_b(vec) / vec.func_72433_c();
    }

    public double getSummaryMass(Entity entityIn) {
        Entity entity = entityIn;
        double summaryMass = this.getMass(entity);
        while (entity.func_184218_aH()) {
            entity = entity.func_184187_bx();
            summaryMass += this.getMass(entity);
        }
        entity = entityIn;
        while (entity.func_184179_bs() != null) {
            entity = entity.func_184179_bs();
            summaryMass += this.getMass(entity);
        }
        return summaryMass;
    }

    public double getMass(Entity entity) {
        double mass = 0.0;
        AxisAlignedBB box = entity.func_174813_aQ();
        if (box != null) {
            mass += (box.field_72336_d - box.field_72340_a) * (box.field_72337_e - box.field_72338_b) * (box.field_72334_f - box.field_72339_c);
        }
        for (ItemStack armorPiece : entity.func_184193_aE()) {
            if (armorPiece.func_190926_b() || !(armorPiece.func_77973_b() instanceof ItemArmor)) continue;
            mass += (double)((float)((ItemArmor)armorPiece.func_77973_b()).field_77879_b + ((ItemArmor)armorPiece.func_77973_b()).field_189415_e) / 20.0;
        }
        return mass;
    }

    public void onBroken(EntityPlayer player) {
        if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == this) {
            player.func_71019_a(new ItemStack(Items.field_151055_y), true);
        }
    }

    public boolean isRaised(@Nullable EntityLivingBase entityIn) {
        if (entityIn == null) {
            return false;
        }
        ItemStack stack = entityIn.func_184614_ca();
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            return nbt.func_74764_b("raised") && nbt.func_74763_f("raised") == 1L;
        }
        return false;
    }

    public void setRaised(EntityLivingBase entityIn, boolean raisedIn) {
        ItemStack stack = entityIn.func_184614_ca();
        NBTTagCompound nbt = !stack.func_77942_o() ? new NBTTagCompound() : this.getNBTShareTag(stack);
        nbt.func_74772_a("raised", raisedIn ? 1L : 0L);
        stack.func_77982_d(nbt);
    }

    public void setAttackDamage(float attackDamageIn) {
        this.field_150934_a = attackDamageIn;
    }
}

