/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.magistuarmory.KnightlyArmory;
import com.magistuarmory.client.renderer.model.item.AbstractModelBase;
import com.magistuarmory.item.MedievalWeaponItem;
import com.magistuarmory.util.IHasModel;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MedievalShieldItem
extends ItemShield
implements IHasModel {
    private int durability;
    private Item repairItem = Item.func_150898_a((Block)Blocks.field_150344_f);
    private boolean paintable;
    private String shieldName;
    private AbstractModelBase model;
    private String materialName;
    private float maxBlockDamage;
    private float weight;

    public MedievalShieldItem(String shieldName, String materialName, Item.ToolMaterial material, int durability, float weigth, float maxBlockDamage, boolean paintable) {
        this.setRegistryName(materialName + '_' + shieldName);
        this.func_77655_b(materialName + '_' + shieldName);
        this.durability = durability;
        this.func_77656_e(durability);
        this.paintable = paintable;
        this.shieldName = shieldName;
        this.materialName = materialName;
        this.maxBlockDamage = maxBlockDamage + material.func_78000_c();
        this.weight = weigth + material.func_78000_c();
    }

    public String getShieldName() {
        return this.shieldName;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(this.getMaxBlockDamage() + " max damage block");
        tooltip.add(this.getWeight() + "kg weight");
        if (this.weight >= 10.0f) {
            tooltip.add("Slow movement speed");
        }
        ItemBanner.func_185054_a((ItemStack)stack, tooltip);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.getWeight() < 10.0f || !(entityIn instanceof EntityLivingBase) || ((EntityLivingBase)entityIn).func_184614_ca() != stack && ((EntityLivingBase)entityIn).func_184592_cb() != stack) {
            return;
        }
        ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(Potion.func_188412_a((int)2), 40, 1, false, false));
    }

    private float getWeight() {
        return this.weight;
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)("item." + this.materialName + '_' + this.shieldName + ".name"));
    }

    public int func_77626_a(ItemStack stack) {
        return (int)(12000.0f * this.weight);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == this.repairItem;
    }

    @Override
    public void registerModels() {
        KnightlyArmory.PROXY.registerItemRenderer((Item)this, 0, "inventory");
    }

    public boolean isPaintable() {
        return this.paintable;
    }

    public MedievalShieldItem setModel(AbstractModelBase model) {
        this.model = model;
        return this;
    }

    public AbstractModelBase getModel() {
        return this.model;
    }

    public float getMaxBlockDamage() {
        return this.maxBlockDamage;
    }

    public MedievalShieldItem setRepairItem(Item repairItem) {
        this.repairItem = repairItem;
        return this;
    }

    public void onBlocked(ItemStack stack, float damage, EntityPlayer player, DamageSource source) {
        EntityLivingBase attacker;
        float armorPiercingFactor = 1.0f;
        if (source.func_76346_g() instanceof EntityLivingBase && (attacker = (EntityLivingBase)source.func_76346_g()).func_184614_ca().func_77973_b() instanceof MedievalWeaponItem) {
            armorPiercingFactor += (float)((MedievalWeaponItem)attacker.func_184614_ca().func_77973_b()).armorPiercing / 100.0f;
        }
        if (damage > this.getMaxBlockDamage()) {
            stack.func_77972_a((int)(armorPiercingFactor * 0.2f * (float)stack.func_77958_k()), (EntityLivingBase)player);
            float damage1 = damage - this.getMaxBlockDamage();
            float damage2 = CombatRules.func_189427_a((float)damage1, (float)player.func_70658_aO(), (float)((float)player.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
            player.func_70097_a(DamageSource.field_76377_j, damage2);
            return;
        }
        stack.func_77972_a((int)(armorPiercingFactor * damage), (EntityLivingBase)player);
    }

    public boolean isShield(ItemStack stack, EntityLivingBase entity) {
        return true;
    }
}

