/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.google.common.collect.Multimap;
import com.magistuarmory.KnightlyArmory;
import com.magistuarmory.effects.LacerationEffect;
import com.magistuarmory.init.ModItems;
import com.magistuarmory.util.IHasModel;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MedievalWeaponItem
extends ItemSword
implements IHasModel {
    protected float field_150934_a;
    protected float attackSpeed;
    protected int armorPiercing = 0;
    protected float reachDistance = 0.0f;
    protected boolean isSilver = false;
    protected boolean isFlamebladed = false;
    protected int twoHanded = 0;
    private float currentAttackDamage;
    private float currentAttackSpeed;
    private float decreasedAttackDamage;
    private float decreasedAttackSpeed;
    private float maxBlockDamage = 0.0f;
    private float weight = 1.0f;
    private boolean canBlock = false;
    private boolean blockingPriority = false;

    public MedievalWeaponItem(String unlocName, Item.ToolMaterial material, float baseAttackDamage, float materialFactor, float baseAttackSpeed, int armorPiercing, float reachDistance) {
        this(unlocName, material, baseAttackDamage, materialFactor, baseAttackSpeed);
        this.armorPiercing = armorPiercing;
        this.reachDistance = reachDistance;
    }

    public MedievalWeaponItem(String unlocName, Item.ToolMaterial material, float baseAttackDamage, float materialFactor, float baseAttackSpeed) {
        super(material);
        this.setRegistryName(unlocName);
        this.func_77655_b(unlocName);
        this.field_150934_a = baseAttackDamage + materialFactor * material.func_78000_c();
        this.attackSpeed = baseAttackSpeed;
        this.currentAttackDamage = this.field_150934_a;
        this.currentAttackSpeed = this.attackSpeed;
        if (material.equals((Object)ModItems.TOOL_MATERIAL_SILVER)) {
            this.isSilver = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return false;
    }

    @Override
    public void registerModels() {
        KnightlyArmory.PROXY.registerItemRenderer((Item)this, 0, "inventory");
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            this.replaceModifier((Multimap<String, AttributeModifier>)multimap, SharedMonsterAttributes.field_111264_e, field_111210_e, this.func_150931_i());
            this.replaceModifier((Multimap<String, AttributeModifier>)multimap, SharedMonsterAttributes.field_188790_f, field_185050_h, this.getAttackSpeed());
        }
        return multimap;
    }

    public boolean func_77644_a(ItemStack p_77644_1_, EntityLivingBase p_77644_2_, EntityLivingBase p_77644_3_) {
        if (this.isSilver && p_77644_2_.func_70668_bt().equals((Object)EnumCreatureAttribute.UNDEAD)) {
            p_77644_2_.func_70097_a(DamageSource.field_76376_m, this.func_150931_i() + 3.0f);
        }
        if (this.isFlamebladed) {
            float damage = (float)((double)this.func_150931_i() * (1.0 - Math.min(20.0, Math.max((double)(p_77644_2_.func_70658_aO() / 5), (double)p_77644_2_.func_70658_aO() - (double)this.func_150931_i() / (p_77644_2_.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e() / 4.0 + 2.0))) / 25.0));
            p_77644_2_.func_70690_d(new PotionEffect((Potion)LacerationEffect.LACERATION.setDamage(damage), 300, 1, true, true));
        }
        if (this.armorPiercing != 0 && p_77644_2_.func_70658_aO() > 0) {
            float piercedArmor = p_77644_2_.func_70658_aO() * (1 - this.armorPiercing / 100);
            float baseDamage = (float)((double)this.func_150931_i() * (1.0 - Math.min(20.0, Math.max((double)(p_77644_2_.func_70658_aO() / 5), (double)p_77644_2_.func_70658_aO() - (double)this.func_150931_i() / (p_77644_2_.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e() / 4.0 + 2.0))) / 25.0));
            float totalDamage = (float)((double)this.func_150931_i() * (1.0 - Math.min(20.0, Math.max((double)(piercedArmor / 5.0f), (double)piercedArmor - (double)this.func_150931_i() / (p_77644_2_.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e() / 4.0 + 2.0))) / 25.0));
            float bonusDamage = totalDamage - baseDamage;
            p_77644_2_.func_70097_a(DamageSource.field_76377_j, bonusDamage);
        }
        return super.func_77644_a(p_77644_1_, p_77644_2_, p_77644_3_);
    }

    private void replaceModifier(Multimap<String, AttributeModifier> modifierMultimap, IAttribute attribute, UUID id, double value) {
        Collection modifiers = modifierMultimap.get((Object)attribute.func_111108_a());
        Optional<AttributeModifier> modifierOptional = modifiers.stream().filter(attributeModifier -> attributeModifier.func_111167_a().equals(id)).findFirst();
        if (modifierOptional.isPresent()) {
            AttributeModifier modifier = modifierOptional.get();
            modifiers.remove(modifier);
            modifiers.add(new AttributeModifier(modifier.func_111167_a(), modifier.func_111166_b(), value, modifier.func_111169_c()));
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.isSilver) {
            tooltip.add("+2 damage against undead");
        }
        if (this.isFlamebladed) {
            tooltip.add("Inflicts non-healing wounds");
        }
        if (this.twoHanded == 1) {
            tooltip.add("Two-Handed I");
        } else if (this.twoHanded > 1) {
            tooltip.add("Two-Handed II");
        }
        if (this.armorPiercing != 0) {
            tooltip.add(this.armorPiercing + "% armor piercing");
        }
        if (this.reachDistance != 0.0f) {
            tooltip.add("+" + this.reachDistance + " reach distance");
        }
        if (this.canBlock()) {
            tooltip.add(this.getMaxBlockDamage() + " max damage block");
        }
        tooltip.add(this.getWeight() + "kg weight");
    }

    public MedievalWeaponItem setFlamebladed() {
        this.isFlamebladed = true;
        return this;
    }

    public MedievalWeaponItem setTwoHanded(int level) {
        this.twoHanded = level;
        this.decreasedAttackDamage = 12.0f * this.field_150934_a / (5.0f * (float)level + 10.0f);
        this.decreasedAttackSpeed = 14.0f * (this.attackSpeed + 4.0f) / (15.0f * (float)level + 5.0f) - 4.0f;
        return this;
    }

    public MedievalWeaponItem setBlocking(float weight, float maxBlockDamage) {
        this.weight = weight;
        this.maxBlockDamage = maxBlockDamage;
        this.canBlock = true;
        this.func_185043_a(new ResourceLocation("blocking"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
        return this;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        boolean flag = false;
        if (this.twoHanded > 0 && entityIn instanceof EntityLivingBase && !((EntityLivingBase)entityIn).func_184592_cb().func_77973_b().equals(Items.field_190931_a)) {
            if (this.currentAttackDamage != this.decreasedAttackDamage) {
                this.currentAttackDamage = this.decreasedAttackDamage;
                flag = true;
            }
            if (this.currentAttackDamage != this.decreasedAttackSpeed) {
                this.currentAttackSpeed = this.decreasedAttackSpeed;
                flag = true;
            }
        } else {
            if (this.currentAttackDamage != this.field_150934_a) {
                this.currentAttackDamage = this.field_150934_a;
                flag = true;
            }
            if (this.currentAttackDamage != this.attackSpeed) {
                this.currentAttackSpeed = this.attackSpeed;
                flag = true;
            }
        }
        if (flag) {
            ItemStack itemstack = ((EntityLivingBase)entityIn).func_184614_ca();
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                ((EntityLivingBase)entityIn).func_110140_aT().func_111148_a(itemstack.func_111283_C(entityequipmentslot));
                ((EntityLivingBase)entityIn).func_110140_aT().func_111147_b(itemstack.func_111283_C(entityequipmentslot));
            }
        }
        if (this.canBlock() && entityIn instanceof EntityLivingBase) {
            this.blockingPriority = !(((EntityLivingBase)entityIn).func_184614_ca().func_77973_b() instanceof ItemShield) && !(((EntityLivingBase)entityIn).func_184592_cb().func_77973_b() instanceof ItemShield);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return super.onEntitySwing(entityLiving, stack);
    }

    public float func_150931_i() {
        return this.currentAttackDamage;
    }

    public float getAttackSpeed() {
        return this.currentAttackSpeed;
    }

    public float getReachDistance() {
        return this.reachDistance + 5.0f;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (this.canBlock() && this.blockingPriority) {
            ItemStack itemstack = playerIn.func_184586_b(handIn);
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public int getUseDuration(ItemStack p_77626_1_) {
        return this.canBlock() ? (int)(500.0f / this.getWeight()) : 0;
    }

    public int func_77626_a(ItemStack stack) {
        return this.canBlock() ? (int)(500.0f / this.getWeight()) : 0;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.canBlock() && this.blockingPriority ? EnumAction.BLOCK : super.func_77661_b(stack);
    }

    public void onBlocked(ItemStack stack, float damage, EntityPlayer player, DamageSource source) {
        if (this.canBlock()) {
            EntityLivingBase attacker;
            float armorPiercingFactor = 1.0f;
            if (source.func_76346_g() instanceof EntityLivingBase && (attacker = (EntityLivingBase)source.func_76346_g()).func_184614_ca().func_77973_b() instanceof MedievalWeaponItem) {
                armorPiercingFactor += (float)((MedievalWeaponItem)attacker.func_184614_ca().func_77973_b()).armorPiercing / 100.0f;
            }
            if (source.func_76352_a()) {
                float damage2 = CombatRules.func_189427_a((float)damage, (float)player.func_70658_aO(), (float)((float)player.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
                player.func_70097_a(DamageSource.field_76377_j, damage2);
                return;
            }
            if (source.func_94541_c()) {
                player.func_70097_a(DamageSource.field_76377_j, damage);
                return;
            }
            if (damage > this.getMaxBlockDamage()) {
                stack.func_77972_a((int)(armorPiercingFactor * 0.2f * (float)stack.func_77958_k()), (EntityLivingBase)player);
                float damage1 = damage - this.getMaxBlockDamage();
                float damage2 = CombatRules.func_189427_a((float)damage1, (float)player.func_70658_aO(), (float)((float)player.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
                player.func_70097_a(DamageSource.field_76377_j, damage2);
                return;
            }
            stack.func_77972_a((int)(armorPiercingFactor * damage), (EntityLivingBase)player);
        }
    }

    public float getMaxBlockDamage() {
        return this.maxBlockDamage;
    }

    public float getWeight() {
        return this.weight;
    }

    public boolean canBlock() {
        return this.canBlock;
    }
}

