/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.network;

import com.magistuarmory.item.LanceItem;
import com.magistuarmory.network.PacketBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketLanceCollision
extends PacketBase<PacketLanceCollision> {
    private int entityId;
    private int bonusDamage;

    public PacketLanceCollision() {
    }

    public PacketLanceCollision(int entId, int bonusDamage) {
        this.entityId = entId;
        this.bonusDamage = bonusDamage;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = ByteBufUtils.readVarInt((ByteBuf)buf, (int)4);
        this.bonusDamage = ByteBufUtils.readVarInt((ByteBuf)buf, (int)4);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.entityId, (int)4);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.bonusDamage, (int)4);
    }

    @Override
    public void handleClientSide(PacketLanceCollision message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketLanceCollision message, EntityPlayerMP player) {
        if (message == null || player == null) {
            return;
        }
        Entity victim = player.field_70170_p.func_73045_a(message.entityId);
        if (!(victim instanceof EntityLivingBase)) {
            return;
        }
        ItemStack weapon = player.func_184582_a(EntityEquipmentSlot.MAINHAND);
        if (weapon.func_190926_b()) {
            return;
        }
        if (weapon.func_77973_b() instanceof LanceItem) {
            if (weapon.func_77952_i() <= weapon.func_77973_b().func_77626_a(weapon) - 1) {
                ((LanceItem)weapon.func_77973_b()).onBroken((EntityPlayer)player);
            } else if (!player.func_184812_l_() && ((EntityLivingBase)victim).func_70658_aO() >= 18) {
                weapon.func_77972_a((int)((0.6 + (double)(this.bonusDamage / 20)) * Math.random() * (double)weapon.func_77958_k()), (EntityLivingBase)player);
            }
            ((LanceItem)weapon.func_77973_b()).attacking = true;
            ((LanceItem)weapon.func_77973_b()).strength = this.bonusDamage;
            player.func_71059_n(victim);
            victim.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), ((LanceItem)weapon.func_77973_b()).func_150931_i() + (float)message.bonusDamage);
            if (weapon.func_77973_b() instanceof LanceItem) {
                ((LanceItem)weapon.func_77973_b()).attacking = false;
            }
            for (ItemStack itemStack : player.field_71069_bz.field_75153_a) {
                ((LanceItem)weapon.func_77973_b()).setRaised((EntityLivingBase)player, true);
                player.func_184811_cZ().func_185145_a(itemStack.func_77973_b(), (int)(40.0f / (4.0f + ((LanceItem)weapon.func_77973_b()).getAttackSpeed())));
            }
            player.func_184609_a(EnumHand.MAIN_HAND);
            if (weapon.func_77952_i() >= weapon.func_77958_k()) {
                ((LanceItem)weapon.func_77973_b()).onBroken((EntityPlayer)player);
                weapon.func_190920_e(0);
            }
        }
    }
}

