/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public final class Enchants {
    public static final int MAX_XAMPLIFIED_ENCHANTMENT_LEVEL_ALLOWED = 10;
    public static final int HIGH_FORTUNE = Enchantments.field_185308_t.func_77325_b();
    public static final int MAX_FORTUNE = 10;
    public static final int HIGH_LOOTING = Enchantments.field_185304_p.func_77325_b();
    public static final int MAX_LOOTING = 10;
    public static final int MAX_ATTACK_DAMAGE = 10;
    public static final int HIGH_PROTECTION = Enchantments.field_180310_c.func_77325_b();
    public static final int MAX_PROTECTION = 7;
    public static final int HIGH_UNBREAKING = Enchantments.field_185307_s.func_77325_b();
    public static final int MAX_UNBREAKING = 7;
    public static final int HIGH_CURSED_BINDING = Enchantments.field_190941_k.func_77325_b();
    public static final int MAX_CURSED_BINDING = 3;
    public static final int HIGH_EFFICIENCY = 5;
    public static final int MAX_EFFICIENCY = 10;
    public static final int INFINITE_INFINITY = 4;
    public static final String _NBT_ID = "id";
    public static final String _NBT_LEVEL = "lvl";
    public static final String _NBT_RES = "res";
    public static final Predicate<EnchantmentData> ANY_CURSE = new Predicate<EnchantmentData>(){

        public boolean apply(EnchantmentData edata) {
            return edata.field_76302_b == Enchantments.field_190940_C || edata.field_76302_b == Enchantments.field_190941_k || edata.field_76302_b.func_190936_d();
        }
    };

    public static final void removeEnchantments(@Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(SharedGlue.DEFAULT_NONBOOK_ENCHANTS_TAGNAME());
        }
    }

    public static final void initEnchantments(@Nonnull ItemStack to, NBTTagList enchantments, boolean copy) {
        Enchants.removeEnchantments(to);
        if (enchantments != null && enchantments.func_74745_c() > 0) {
            to.func_77983_a(SharedGlue.DEFAULT_NONBOOK_ENCHANTS_TAGNAME(), (NBTBase)(copy ? enchantments.func_74737_b() : enchantments));
        }
    }

    public static final void copyinitEnchantments(@Nonnull ItemStack from, @Nonnull ItemStack to) {
        Enchants.removeEnchantments(to);
        if (from.func_77948_v()) {
            to.func_77983_a(SharedGlue.DEFAULT_NONBOOK_ENCHANTS_TAGNAME(), (NBTBase)from.func_77986_q().func_74737_b());
        }
    }

    public static final void hideEnchantments(@Nonnull ItemStack on) {
        if (on.func_77942_o()) {
            int current = on.func_77978_p().func_74762_e(SharedGlue.ITEM_INFO_HIDDEN_TAGNAME());
            on.func_77978_p().func_74768_a(SharedGlue.ITEM_INFO_HIDDEN_TAGNAME(), current | 1);
        }
    }

    public static final boolean areHidden(@Nonnull ItemStack on) {
        boolean hidden = false;
        if (on.func_190926_b()) {
            hidden = true;
        } else if (on.func_77942_o() && on.func_77978_p().func_150297_b(SharedGlue.ITEM_INFO_HIDDEN_TAGNAME(), 99)) {
            int flags = on.func_77978_p().func_74762_e(SharedGlue.ITEM_INFO_HIDDEN_TAGNAME());
            hidden = (flags & 1) == 1;
        }
        return hidden;
    }

    public static final int checkedXLevel(Enchantment e, int level) {
        if ((e == Enchantments.field_185298_f || e == Enchantments.field_185300_i) && level > e.func_77325_b()) {
            level = e.func_77325_b();
        }
        return level;
    }

    @Nullable
    public static final NBTTagList getBrokenEnchantments(@Nonnull ItemStack stack) {
        NBTTagList enchList = null;
        if (stack.func_77942_o() && (enchList = stack.func_77978_p().func_150295_c("BrokenEnchantments", 10)) != null && enchList.func_74745_c() <= 0) {
            enchList = null;
        }
        return enchList;
    }

    public static final int getBrokenEnchantmentsOriginalSetsize(@Nonnull ItemStack stack) {
        int n = -1;
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("BrokenEnchantments_Setsize", 3) && (n = stack.func_77978_p().func_74762_e("BrokenEnchantments_Setsize")) > 10) {
            n = 10;
        }
        return n;
    }

    public static final void setBrokenEnchantments(@Nonnull ItemStack stack, @Nullable NBTTagList enchList, int original_count) {
        if (enchList == null || enchList.func_74745_c() == 0) {
            stack.func_190919_e("BrokenEnchantments");
        } else {
            stack.func_77983_a("BrokenEnchantments", (NBTBase)enchList);
            if (original_count > 1) {
                stack.func_77983_a("BrokenEnchantments_Setsize", (NBTBase)new NBTTagInt(original_count));
            }
        }
    }

    @Nullable
    public static final EnchantmentData getRawData(@Nonnull NBTTagCompound enchantmentNbt) {
        Enchantment enchantment = Enchantment.func_185262_c((int)enchantmentNbt.func_74765_d(_NBT_ID));
        EnchantmentData edata = null;
        if (enchantment != null) {
            short level = enchantmentNbt.func_74765_d(_NBT_LEVEL);
            edata = new EnchantmentData(enchantment, (int)level);
        }
        return edata;
    }

    @Nullable
    public static final EnchantmentData getData(@Nonnull NBTTagCompound enchantmentNbt, boolean clamp) {
        Enchantment enchantment = Enchantment.func_185262_c((int)enchantmentNbt.func_74765_d(_NBT_ID));
        int level = enchantmentNbt.func_74765_d(_NBT_LEVEL);
        if (enchantment == null && enchantmentNbt.func_150297_b(_NBT_RES, 8)) {
            String resource = enchantmentNbt.func_74779_i(_NBT_RES);
            enchantment = Enchantment.func_180305_b((String)resource);
        }
        EnchantmentData edata = null;
        if (enchantment != null) {
            if (clamp || level <= 0) {
                level = MathHelper.func_76125_a((int)level, (int)enchantment.func_77319_d(), (int)enchantment.func_77325_b());
            }
            edata = new EnchantmentData(enchantment, level);
        }
        return edata;
    }

    @Nonnull
    public static final Map<Enchantment, Integer> getEnchantments(@Nonnull ItemStack stack, boolean hiddenOk, Item broken) {
        NBTTagList enchList;
        NBTTagList nBTTagList;
        LinkedHashMap<Enchantment, Integer> map = new LinkedHashMap<Enchantment, Integer>();
        if (ItemStacks.isEmpty(stack) || !hiddenOk && Enchants.areHidden(stack)) {
            return map;
        }
        Item stackitem = stack.func_77973_b();
        if (stackitem instanceof ItemEnchantedBook) {
            ItemEnchantedBook cfr_ignored_0 = (ItemEnchantedBook)stackitem;
            nBTTagList = ItemEnchantedBook.func_92110_g((ItemStack)stack);
        } else {
            nBTTagList = enchList = stackitem == broken ? Enchants.getBrokenEnchantments(stack) : stack.func_77986_q();
        }
        if (enchList != null) {
            for (int i = 0; i < enchList.func_74745_c(); ++i) {
                Integer oldLevel;
                EnchantmentData edata = Enchants.getData(enchList.func_150305_b(i), false);
                if (edata == null || (oldLevel = map.put(edata.field_76302_b, edata.field_76303_c)) == null || oldLevel <= edata.field_76303_c) continue;
                map.put(edata.field_76302_b, oldLevel);
            }
        }
        return map;
    }

    @Nonnull
    public static final Map<Enchantment, Integer> getEnchantments(@Nonnull ItemStack stack) {
        return Enchants.getEnchantments(stack, true, null);
    }

    @Nullable
    public static final EnchantmentData getFirst(@Nonnull ItemStack stack, boolean hiddenOk) {
        NBTTagList enchList;
        NBTTagList nBTTagList;
        if (ItemStacks.isEmpty(stack) || !hiddenOk && Enchants.areHidden(stack)) {
            return null;
        }
        if (stack.func_77973_b() instanceof ItemEnchantedBook) {
            ItemEnchantedBook cfr_ignored_0 = (ItemEnchantedBook)stack.func_77973_b();
            nBTTagList = ItemEnchantedBook.func_92110_g((ItemStack)stack);
        } else {
            nBTTagList = enchList = stack.func_77986_q();
        }
        if (enchList != null) {
            for (int i = 0; i < enchList.func_74745_c(); ++i) {
                EnchantmentData edata = Enchants.getData(enchList.func_150305_b(i), false);
                if (edata == null) continue;
                return edata;
            }
        }
        return null;
    }

    public static final boolean isEnchanted(@Nonnull ItemStack stack, boolean hiddenOk) {
        EnchantmentData edata = Enchants.getFirst(stack, hiddenOk);
        return edata != null;
    }

    public static final boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        boolean is;
        boolean bl = is = !ItemStacks.isEmpty(stack);
        if (is) {
            Item itemimpl = stack.func_77973_b();
            if (!itemimpl.func_77616_k(stack)) {
                is = false;
            } else {
                for (Enchantment e : Enchants.getEnchantments(book).keySet()) {
                    if (itemimpl.canApplyAtEnchantingTable(stack, e)) continue;
                    is = false;
                    break;
                }
            }
        }
        return is;
    }

    public static final int getOtherCount(ItemStack itemstack, boolean stopquick, Enchantment ... endemicList) {
        int n = 0;
        if (!ItemStacks.isEmpty(itemstack) && endemicList.length > 0) {
            NBTTagList enchList = itemstack.func_77986_q();
            for (int i = 0; i < enchList.func_74745_c(); ++i) {
                EnchantmentData edata = Enchants.getData(enchList.func_150305_b(i), false);
                if (edata == null) continue;
                boolean found = false;
                for (Enchantment owned : endemicList) {
                    if (edata.field_76302_b != owned) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                ++n;
                if (stopquick) break;
            }
        }
        return n;
    }

    public static final void removeEnchantments(ItemStack stack, @Nullable Collection<Enchantment> filterList) {
        if (stack != null && stack.func_77948_v()) {
            if (filterList == null) {
                filterList = Collections.EMPTY_LIST;
            }
            if (filterList.isEmpty()) {
                Enchants.removeEnchantments(stack);
            } else {
                NBTTagList curList = stack.func_77986_q();
                NBTTagList newList = new NBTTagList();
                for (int i = 0; i < curList.func_74745_c(); ++i) {
                    EnchantmentData edata = Enchants.getData(curList.func_150305_b(i), false);
                    if (!filterList.contains(edata.field_76302_b)) continue;
                    newList.func_74742_a((NBTBase)curList.func_150305_b(i));
                }
                if (newList.func_74745_c() != curList.func_74745_c()) {
                    if (newList.func_74745_c() == 0) {
                        Enchants.removeEnchantments(stack);
                    } else {
                        stack.func_77983_a(SharedGlue.DEFAULT_NONBOOK_ENCHANTS_TAGNAME(), (NBTBase)newList);
                    }
                }
            }
        }
    }

    public static final NBTTagList sameItemEnchantments(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        NBTTagList outList = null;
        if (stack1.func_77948_v() && stack2.func_77948_v()) {
            NBTTagList tagList1 = stack1.func_77986_q();
            NBTTagList tagList2 = stack2.func_77986_q();
            int n = tagList1.func_74745_c();
            if (n == tagList2.func_74745_c() && n > 0) {
                for (int i = 0; i < n; ++i) {
                    EnchantmentData edata1 = Enchants.getRawData(tagList1.func_150305_b(i));
                    if (edata1 == null) {
                        return null;
                    }
                    boolean match_found = false;
                    for (int j = 0; j < n && !match_found; ++j) {
                        EnchantmentData edata2 = Enchants.getRawData(tagList2.func_150305_b(j));
                        if (edata2 == null) {
                            return null;
                        }
                        if (edata2.field_76302_b != edata1.field_76302_b) continue;
                        if (outList == null) {
                            outList = new NBTTagList();
                        }
                        if (edata1.field_76303_c <= edata2.field_76303_c) {
                            outList.func_74742_a((NBTBase)tagList1.func_150305_b(i).func_74737_b());
                        } else {
                            outList.func_74742_a((NBTBase)tagList2.func_150305_b(j).func_74737_b());
                        }
                        match_found = true;
                        break;
                    }
                    if (match_found) continue;
                    return null;
                }
            }
        }
        return outList;
    }

    public static final NBTTagList addEnchantmentToStack(Enchantment enchantment, int level, NBTTagList listNbt) {
        NBTTagCompound info = new NBTTagCompound();
        if (level <= 0) {
            level = enchantment.func_77319_d();
        }
        info.func_74777_a(_NBT_ID, (short)Enchantment.func_185258_b((Enchantment)enchantment));
        info.func_74777_a(_NBT_LEVEL, (short)level);
        if (enchantment.getRegistryName() != null) {
            info.func_74778_a(_NBT_RES, enchantment.getRegistryName().toString());
        }
        listNbt.func_74742_a((NBTBase)info);
        return listNbt;
    }

    public static void addEnchantmentToStack(Enchantment enchantment, int level, @Nonnull ItemStack stack) {
        Enchants.addEnchantmentToStack(enchantment, level, ItemStacks.getTagCompoundNonNull(stack));
    }

    public static final NBTTagCompound addEnchantmentToStack(Enchantment enchantment, int level, NBTTagCompound stackNbt) {
        NBTTagList listNbt = stackNbt.func_150295_c(SharedGlue.DEFAULT_NONBOOK_ENCHANTS_TAGNAME(), 10);
        Enchants.addEnchantmentToStack(enchantment, level, listNbt);
        stackNbt.func_74782_a(SharedGlue.DEFAULT_NONBOOK_ENCHANTS_TAGNAME(), (NBTBase)listNbt);
        return stackNbt;
    }

    public static ItemStack mergeEnchantmentToStack(@Nonnull Enchantment enchantment, int level, @Nonnull ItemStack stack) {
        boolean add;
        boolean bl = add = level > 0;
        if (stack.func_77948_v()) {
            NBTTagList list = stack.func_77986_q();
            int n = list.func_74745_c();
            for (int i = 0; i < n; ++i) {
                NBTTagCompound element = list.func_150305_b(i);
                if (enchantment != Enchantment.func_185262_c((int)element.func_74765_d(_NBT_ID))) continue;
                add = false;
                if (level <= 0) {
                    list.func_74744_a(i);
                    break;
                }
                short current_level = element.func_74765_d(_NBT_LEVEL);
                if (level <= current_level) break;
                element.func_74777_a(_NBT_LEVEL, (short)level);
                break;
            }
        }
        if (add) {
            stack.func_77966_a(enchantment, level);
        }
        return stack;
    }

    public static ItemStack clearEnchantmentFromStack(@Nonnull Enchantment enchantment, @Nonnull ItemStack stack) {
        return Enchants.mergeEnchantmentToStack(enchantment, -1, stack);
    }

    public static final boolean isLikely(ItemStack stack, @Nonnull Predicate<Map.Entry<Enchantment, Integer>> test) {
        boolean is = false;
        if (!ItemStacks.isEmpty(stack)) {
            for (Map.Entry<Enchantment, Integer> e : Enchants.getEnchantments(stack).entrySet()) {
                if (!test.apply(e)) continue;
                is = true;
                break;
            }
        }
        return is;
    }

    @Nonnull
    public static final List<EnchantmentData> strippedOf(@Nonnull List<EnchantmentData> elist, @Nonnull Predicate<EnchantmentData> test) {
        ListIterator<EnchantmentData> litr = elist.listIterator();
        while (litr.hasNext()) {
            if (!test.apply((Object)litr.next())) continue;
            litr.remove();
        }
        return elist;
    }

    @Nonnull
    public static final List<EnchantmentData> strippedOfCurses(@Nonnull List<EnchantmentData> elist) {
        return Enchants.strippedOf(elist, ANY_CURSE);
    }

    public static final List<EnchantmentData> strippedOfVanishingCurse(List<EnchantmentData> elist) {
        return Enchants.strippedOf(elist, new Predicate<EnchantmentData>(){

            public boolean apply(EnchantmentData edata) {
                return edata.field_76302_b == Enchantments.field_190940_C;
            }
        });
    }

    protected Enchants() {
    }

    public static final void init0() {
    }
}

